/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.enums;

import kd.epm.epbs.common.annotation.AppMark;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.enums.AppTypeEnum;

@AppMark
public enum AppModelEnum {
    CM(AppTypeEnum.CM, "1"),
    RPT(AppTypeEnum.RPT, "2"),
    BGMD(AppTypeEnum.BGMD, "7"),
    EB(AppTypeEnum.EB, "4"),
    BG(AppTypeEnum.BG, "6"),
    EPBS(AppTypeEnum.EPBS, null),
    FAR(AppTypeEnum.FAR, null),
    FIDM(AppTypeEnum.FIDM, null),
    EMR(AppTypeEnum.EMR, null);

    private AppTypeEnum appType;
    private String reportType;

    private AppModelEnum(AppTypeEnum appType, String reportType) {
        this.appType = appType;
        this.reportType = reportType;
    }

    public AppTypeEnum getAppType() {
        return this.appType;
    }

    public String getModelEntity() {
        return ConfigurationContext.INSTANCE.loadProp(this.appType.getAppNum(), AppConfigPropEnum.MODEL_FORM);
    }

    public String getModelPermEntity() {
        return ConfigurationContext.INSTANCE.loadProp(this.appType.getAppNum(), AppConfigPropEnum.MODEL_ADMIN_DISTRIBUTE_FORM);
    }

    public String getReportType() {
        return this.reportType;
    }

    public static AppModelEnum getByNumber(String appNumber) {
        AppModelEnum appModel = EPBS;
        for (AppModelEnum e : AppModelEnum.values()) {
            if (!e.getAppType().getAppNum().equalsIgnoreCase(appNumber)) continue;
            appModel = e;
        }
        return appModel;
    }
}

