/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.epm.epbs.common.bean.IAppType;
import kd.epm.epbs.common.enums.CloudTypeEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;

public enum AppTypeEnum implements IAppType
{
    CM(new MultiLangEnumBridge("\u5408\u5e76\u62a5\u8868", "AppTypeEnum_1", "epm-epbs-common"), "cm", "11H66HLOX4IC"),
    BGMD(new MultiLangEnumBridge("\u9884\u7b97\u4f53\u7cfb", "AppTypeEnum_2", "epm-epbs-common"), "bgmd", "/V79VI+W05+V"),
    EB(new MultiLangEnumBridge("\u8d39\u7528\u9884\u7b97", "AppTypeEnum_3", "epm-epbs-common"), "eb", "/G4ZXY9/MISN"),
    BG(new MultiLangEnumBridge("\u65b0\u8d39\u7528\u9884\u7b97", "AppTypeEnum_4", "epm-epbs-common"), "bg", ""),
    EPBS(new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u57fa\u7840\u670d\u52a1", "AppTypeEnum_5", "epm-epbs-common"), "epbs", "3J6GZ00WTQPR"),
    BGM(new MultiLangEnumBridge("\u5168\u9762\u9884\u7b97", "AppTypeEnum_6", "epm-epbs-common"), "bgm", "/Y7WRJVSYD+N"),
    BGC(new MultiLangEnumBridge("\u9884\u7b97\u63a7\u5236", "AppTypeEnum_7", "epm-epbs-common"), "bgc", "05VMP7NB3NVL"),
    FAR(new MultiLangEnumBridge("\u7ee9\u6548\u5206\u6790", "AppTypeEnum_8", "epm-epbs-common"), "far", "2K++OWYYMS5J"),
    FIDM(new MultiLangEnumBridge("\u62ab\u9732\u7ba1\u7406", "AppTypeEnum_9", "epm-epbs-common"), "fidm", "2IFNVZ0SS0W4"),
    RPT(new MultiLangEnumBridge("\u8d22\u52a1\u62a5\u8868", "AppTypeEnum_10", "epm-epbs-common"), "rpt", "L/B5N23NCFS"),
    DI(new MultiLangEnumBridge("\u6570\u636e\u96c6\u6210", "AppTypeEnum_11", "epm-epbs-common"), "di", "2Q=F/KOPM/UW"),
    BGBD(new MultiLangEnumBridge("\u4f01\u4e1a\u7ee9\u6548\u4e91\u57fa\u7840\u8d44\u6599", "AppTypeEnum_12", "epm-epbs-common"), "bgbd", "/V0B8OWYDBZL"),
    BGRP(new MultiLangEnumBridge("\u9884\u7b97\u7533\u62a5", "AppTypeEnum_13", "epm-epbs-common"), "bgrp", "1K2HGFCYLUGE"),
    EMR(new MultiLangEnumBridge("\u7ba1\u7406\u62a5\u544a", "AppTypeEnum_14", "epm-epbs-common"), "emr", "479/FARBLGCT"),
    EPDM(new MultiLangEnumBridge("EPM\u6570\u636e\u7ba1\u7406", "AppTypeEnum_15", "epm-epbs-common"), "epdm", "3ZYA/R/EUFHI"),
    EPML(new MultiLangEnumBridge("EPM\u51ed\u8bc1\u6c60", "AppTypeEnum_17", "epm-epbs-common"), "epml", "47WS4+9IE=XB");

    private MultiLangEnumBridge desc;
    private final String appNum;
    private String id;

    private AppTypeEnum(MultiLangEnumBridge desc, String appNum, String id) {
        this.desc = desc;
        this.appNum = appNum;
        this.id = id;
    }

    @Override
    public String getDesc() {
        return this.desc.loadKDString();
    }

    public LocaleString getDescWithLocale() {
        return this.desc.getLocaleString();
    }

    @Override
    public String getAppNum() {
        return this.appNum;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static List<AppTypeEnum> getApps(String appNum) {
        AppTypeEnum enumByAppnum = AppTypeEnum.getEnumByAppnum(appNum);
        if (enumByAppnum == EPBS) {
            return Arrays.stream(AppTypeEnum.values()).collect(Collectors.toList());
        }
        if (enumByAppnum == CM) {
            return Arrays.asList(CM, RPT, DI);
        }
        if (enumByAppnum == RPT) {
            return Arrays.asList(CM, RPT);
        }
        if (enumByAppnum == FIDM || enumByAppnum == FAR) {
            return Arrays.asList(FIDM, FAR);
        }
        if (enumByAppnum == BGMD || enumByAppnum == EB || enumByAppnum == BG || enumByAppnum == BGM || enumByAppnum == BGC || enumByAppnum == BGBD) {
            return Arrays.asList(BGMD, EB, BG, BGM, BGC, BGBD);
        }
        return Collections.singletonList(enumByAppnum);
    }

    public static AppTypeEnum getEnumByAppnum(String appnum) {
        AppTypeEnum result = EPBS;
        for (AppTypeEnum v : AppTypeEnum.values()) {
            if (!Objects.equals(appnum, v.appNum)) continue;
            result = v;
        }
        return result;
    }

    public String getAppId() {
        if (this == BG) {
            return EB.getAppNum();
        }
        return this.getAppNum();
    }

    public static boolean isCMApp(String appNum) {
        return CM.getAppNum().equals(appNum) || RPT.getAppNum().equals(appNum) || DI.getAppNum().equals(appNum);
    }

    public static boolean isFarApp(String appNum) {
        return FIDM.getAppNum().equals(appNum) || FAR.getAppNum().equals(appNum);
    }

    public static boolean isEbApp(String appNum) {
        return EB.getAppNum().equals(appNum) || BGMD.getAppNum().equals(appNum) || BG.getAppNum().equals(appNum) || BGM.getAppNum().equals(appNum) || BGC.getAppNum().equals(appNum) || BGBD.getAppNum().equals(appNum) || BGRP.getAppNum().equals(appNum);
    }

    public String getColudNum() {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)this.getAppId());
        String cloudNum = appInfo.getCloudNum().toLowerCase(Locale.ROOT);
        if (Objects.equals(CM.getAppId(), appInfo.getAppId())) {
            cloudNum = CloudTypeEnum.FI.name().toLowerCase(Locale.ROOT);
        }
        return cloudNum;
    }

    public String getMserivceAppId() {
        if (BGMD == this) {
            return EB.getAppId();
        }
        return this.getAppId();
    }
}

