/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;

public enum RangeEnum {
    ONLY(new MultiLangEnumBridge("\u4ec5\u81ea\u5df1", "RangeEnum_1", "epm-epbs-common"), "This", 10),
    DIRECTSUB_EXCLUDE(new MultiLangEnumBridge("\u76f4\u63a5\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", "RangeEnum_2", "epm-epbs-common"), "DirectsubExclude", 20),
    DIRECTSUB(new MultiLangEnumBridge("\u76f4\u63a5\u4e0b\u7ea7_\u542b\u81ea\u5df1", "RangeEnum_3", "epm-epbs-common"), "Directsub", 30),
    ALL_EXCLUDE(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", "RangeEnum_4", "epm-epbs-common"), "Children", 40),
    ALL(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1", "RangeEnum_5", "epm-epbs-common"), "All", 50),
    PEERS_EXCLUDE(new MultiLangEnumBridge("\u6240\u6709\u5e73\u7ea7_\u4e0d\u542b\u81ea\u5df1", "RangeEnum_6", "epm-epbs-common"), "PeersExclude", 60),
    PEERS(new MultiLangEnumBridge("\u6240\u6709\u5e73\u7ea7_\u542b\u81ea\u5df1", "RangeEnum_7", "epm-epbs-common"), "Peers", 70),
    ALL_DETAIL(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458", "RangeEnum_8", "epm-epbs-common"), "Detail", 90),
    ALL_DETAIL_INCLUDE(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458_\u542b\u81ea\u5df1", "RangeEnum_9", "epm-epbs-common"), "AllDetailInclude", 100),
    ALL_NOTDETAIL(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u4ec5\u975e\u660e\u7ec6\u6210\u5458", "RangeEnum_10", "epm-epbs-common"), "Item", 110),
    LEVEL(new MultiLangEnumBridge("\u6307\u5b9a\u4e0b\u7ea7_\u542b\u81ea\u5df1", "RangeEnum_11", "epm-epbs-common"), "Level", 170),
    LEVEL_EXCLUDE(new MultiLangEnumBridge("\u6307\u5b9a\u4e0b\u7ea7_\u4e0d\u542b\u81ea\u5df1", "RangeEnum_12", "epm-epbs-common"), "LevelExclude", 180);

    private MultiLangEnumBridge bridge;
    private String number;
    private int index;

    private RangeEnum(MultiLangEnumBridge bridge, String number, int index) {
        this.bridge = bridge;
        this.number = number;
        this.index = index;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public int getIndex() {
        return this.index;
    }

    public String getIndStr() {
        return String.valueOf(this.index);
    }

    public static RangeEnum getRangeByName(String name) {
        for (RangeEnum r : RangeEnum.values()) {
            if (!r.bridge.loadKDString().equals(name)) continue;
            return r;
        }
        return null;
    }

    public static RangeEnum getRangeByVal(int val) {
        for (RangeEnum r : RangeEnum.values()) {
            if (r.index != val) continue;
            return r;
        }
        throw new RuntimeException("RangeEnum error value:" + val);
    }

    public static RangeEnum getRangeByVal(String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        try {
            int _val = Integer.parseInt(val);
            for (RangeEnum r : RangeEnum.values()) {
                if (r.index != _val) continue;
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static RangeEnum getRangeByNumber(String number) {
        for (RangeEnum r : RangeEnum.values()) {
            if (!r.number.equals(number)) continue;
            return r;
        }
        throw new RuntimeException("RangeEnum error value:" + number);
    }

    public String getNumber() {
        return this.number;
    }

    public static RangeEnum[] valuesByNoLevel() {
        ArrayList<RangeEnum> oldRanges = new ArrayList<RangeEnum>(16);
        oldRanges.addAll(Arrays.asList(RangeEnum.values()));
        oldRanges.removeIf(item -> item == LEVEL || item == LEVEL_EXCLUDE);
        return oldRanges.toArray(new RangeEnum[oldRanges.size()]);
    }

    public static Map<Integer, RangeEnum> getRangeEnumMap() {
        HashMap<Integer, RangeEnum> map = new HashMap<Integer, RangeEnum>(16);
        for (RangeEnum r : RangeEnum.values()) {
            map.put(r.index, r);
        }
        return map;
    }
}

