/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.enums.model;

import java.time.LocalDate;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.DateBean;
import kd.epm.epbs.common.util.DateTimeUtils;

public enum MonthPeriodMemberEnum {
    HY1("HY1", 0, 6, null, new MultiLangEnumBridge("\u4e0a\u534a\u5e74", "MonthPeriodMemberEnum_1", "epm-epbs-common")),
    Q1("Q1", 0, 3, HY1, new MultiLangEnumBridge("1\u5b63\u5ea6", "MonthPeriodMemberEnum_2", "epm-epbs-common")),
    M01("M01", 0, 1, Q1, new MultiLangEnumBridge("1\u6708", "MonthPeriodMemberEnum_3", "epm-epbs-common")),
    M02("M02", 1, 2, Q1, new MultiLangEnumBridge("2\u6708", "MonthPeriodMemberEnum_4", "epm-epbs-common")),
    M03("M03", 2, 3, Q1, new MultiLangEnumBridge("3\u6708", "MonthPeriodMemberEnum_5", "epm-epbs-common")),
    Q2("Q2", 3, 6, HY1, new MultiLangEnumBridge("2\u5b63\u5ea6", "MonthPeriodMemberEnum_6", "epm-epbs-common")),
    M04("M04", 3, 4, Q2, new MultiLangEnumBridge("4\u6708", "MonthPeriodMemberEnum_7", "epm-epbs-common")),
    M05("M05", 4, 5, Q2, new MultiLangEnumBridge("5\u6708", "MonthPeriodMemberEnum_8", "epm-epbs-common")),
    M06("M06", 5, 6, Q2, new MultiLangEnumBridge("6\u6708", "MonthPeriodMemberEnum_9", "epm-epbs-common")),
    HY2("HY2", 6, 12, null, new MultiLangEnumBridge("\u4e0b\u534a\u5e74", "MonthPeriodMemberEnum_10", "epm-epbs-common")),
    Q3("Q3", 6, 9, HY1, new MultiLangEnumBridge("3\u5b63\u5ea6", "MonthPeriodMemberEnum_11", "epm-epbs-common")),
    M07("M07", 6, 7, Q3, new MultiLangEnumBridge("7\u6708", "MonthPeriodMemberEnum_12", "epm-epbs-common")),
    M08("M08", 7, 8, Q3, new MultiLangEnumBridge("8\u6708", "MonthPeriodMemberEnum_13", "epm-epbs-common")),
    M09("M09", 8, 9, Q3, new MultiLangEnumBridge("9\u6708", "MonthPeriodMemberEnum_14", "epm-epbs-common")),
    Q4("Q4", 9, 12, HY1, new MultiLangEnumBridge("4\u5b63\u5ea6", "MonthPeriodMemberEnum_15", "epm-epbs-common")),
    M10("M10", 9, 10, Q4, new MultiLangEnumBridge("10\u6708", "MonthPeriodMemberEnum_16", "epm-epbs-common")),
    M11("M11", 10, 11, Q4, new MultiLangEnumBridge("11\u6708", "MonthPeriodMemberEnum_17", "epm-epbs-common")),
    M12("M12", 11, 12, Q4, new MultiLangEnumBridge("12\u6708", "MonthPeriodMemberEnum_18", "epm-epbs-common"));

    private String number;
    private int startMonth;
    private int endMonth;
    private MultiLangEnumBridge bridge;
    private MonthPeriodMemberEnum parent;

    public String getNumber() {
        return this.number;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public MonthPeriodMemberEnum getParent() {
        return this.parent;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public int getEndMonth() {
        return this.endMonth;
    }

    private MonthPeriodMemberEnum(String number, int startMonth, int endMonth, MonthPeriodMemberEnum parent, MultiLangEnumBridge bridge) {
        this.number = number;
        this.bridge = bridge;
        this.parent = parent;
        this.startMonth = startMonth;
        this.endMonth = endMonth;
    }

    public DateBean getStartDay(int year, int month, int day) {
        LocalDate date = LocalDate.of(2024, month, day);
        LocalDate localDate = date.plusMonths(this.getStartMonth());
        int endMonth = localDate.getMonthValue();
        int enDay = localDate.getDayOfMonth();
        if (localDate.getYear() > 2024) {
            ++year;
        }
        return new DateBean(year, endMonth, enDay);
    }

    public DateBean getEndDay(int year, int month, int day) {
        LocalDate date = LocalDate.of(2024, month, day);
        LocalDate localDate = date.plusMonths(this.getEndMonth()).minusDays(1L);
        return DateTimeUtils.endDateToDateBean(localDate, year, day);
    }
}

