/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.excelimport;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;

public class ImportContextHolder {
    private static final Map<String, ImportInfo> IS_DRY_RUN_IMPORT_HOLDER = Collections.synchronizedMap(new HashMap(16));
    private static final Map<String, Set<String>> WAITING_PERSIST_PARENT_DEPENDS = new HashMap<String, Set<String>>(16);
    private static final ThreadLocal<Set<Long>> NEW_MEMBER_IDS = new ThreadLocal();
    private static final ThreadLocal<Set<Long>> OVERRIDE_MEMBER_IDS = new ThreadLocal();

    public static void setIsDryRunImport(boolean isDryRunPattern) {
        IS_DRY_RUN_IMPORT_HOLDER.put(RequestContext.getOrCreate().getRequestId(), new ImportInfo(isDryRunPattern));
    }

    public static boolean isDryRun() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)requestId) && null != IS_DRY_RUN_IMPORT_HOLDER.get(requestId) ? 1 : 0) != 0, (Object)"no import pattern setting. ");
        return IS_DRY_RUN_IMPORT_HOLDER.get(requestId).getDryRunPattern();
    }

    public static Date getImportBeginTime() {
        String requestId = RequestContext.getOrCreate().getRequestId();
        Preconditions.checkState((StringUtils.isNotEmpty((CharSequence)requestId) && null != IS_DRY_RUN_IMPORT_HOLDER.get(requestId) ? 1 : 0) != 0, (Object)"no import pattern setting. ");
        return IS_DRY_RUN_IMPORT_HOLDER.get(requestId).getBeginTime();
    }

    public static void addBatchNewIds(Collection<Long> memberIds) {
        if (Objects.isNull(NEW_MEMBER_IDS.get())) {
            NEW_MEMBER_IDS.set(new HashSet(16));
        }
        NEW_MEMBER_IDS.get().addAll(memberIds);
    }

    public static Set<Long> getNewMemberIds() {
        if (Objects.isNull(NEW_MEMBER_IDS.get())) {
            return Collections.EMPTY_SET;
        }
        return NEW_MEMBER_IDS.get();
    }

    public static void addBatchOverrideMemberIds(Collection<Long> memberIds) {
        if (Objects.isNull(OVERRIDE_MEMBER_IDS.get())) {
            OVERRIDE_MEMBER_IDS.set(new HashSet(16));
        }
        OVERRIDE_MEMBER_IDS.get().addAll(memberIds);
    }

    public static Set<Long> getOverrideMemberIds() {
        if (Objects.isNull(OVERRIDE_MEMBER_IDS.get())) {
            return Collections.EMPTY_SET;
        }
        return OVERRIDE_MEMBER_IDS.get();
    }

    private static boolean needCached() {
        return true;
    }

    public static boolean checkNumberIsDepended(String memberNumber) {
        if (!ImportContextHolder.needCached()) {
            throw new IllegalStateException("current import no need cache imported data");
        }
        String requestId = RequestContext.getOrCreate().getRequestId();
        return WAITING_PERSIST_PARENT_DEPENDS.get(requestId).contains(memberNumber);
    }

    private static class ImportInfo {
        private Boolean isDryRunPattern;
        private Date beginTime;

        public ImportInfo(Boolean isDryRunPattern) {
            this.isDryRunPattern = isDryRunPattern;
            this.beginTime = new Date();
        }

        public Boolean getDryRunPattern() {
            return this.isDryRunPattern;
        }

        public void setDryRunPattern(Boolean dryRunPattern) {
            this.isDryRunPattern = dryRunPattern;
        }

        public Date getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(Date beginTime) {
            this.beginTime = beginTime;
        }
    }
}

