/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.excelimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.epm.epbs.common.excelimport.ImportOperateType;

public class ImportHelper {
    private ImportHelper() {
    }

    public static ImportOperateType getImportType(ImportContext ctx) {
        return ImportOperateType.codeOf((String)ctx.getOption().get("importtype"));
    }

    public static void numberCheck(List<ImportBillData> billDatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = billDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData row = iterator.next();
            JSONObject data = row.getData();
            ImportEntityMapping entityMapping = row.getEntityMapping();
            entityMapping.getCols().forEach((k, v) -> {
                IDataEntityProperty property = v.getProperty();
                if (Objects.nonNull(data.get(k)) && (property instanceof BigIntProp || property instanceof IntegerProp || property instanceof DecimalProp)) {
                    try {
                        new BigDecimal((String)data.get(k));
                    }
                    catch (NumberFormatException e) {
                        String displayName = v.getDisplayName();
                        logger.log(Integer.valueOf(row.getStartIndex()), ResManager.loadKDString((String)"%s\u8bf7\u8f93\u5165\u6570\u5b57\u7c7b\u578b", (String)"ImportHelper_1", (String)"epm-epbs-common", (Object[])new Object[]{displayName})).fail();
                        iterator.remove();
                    }
                }
            });
        }
    }

    public static String getNumber(DynamicObject dynamicObject) {
        return dynamicObject.getString("number");
    }

    public static long getBaseDataIdCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public static Object getImportBillProp(ImportBillData billData, String prop) {
        String[] propPathKeys = prop.split("\\.");
        if (propPathKeys.length > 2) {
            throw new IllegalArgumentException("current just support the depth 2. ");
        }
        if (Objects.isNull(billData.getData().get((Object)propPathKeys[0]))) {
            return "";
        }
        Object parentObj = billData.getData().get((Object)propPathKeys[0]);
        if (propPathKeys.length < 2) {
            return parentObj;
        }
        if (!(parentObj instanceof Map)) {
            throw new IllegalArgumentException("invalid prop path, parentObj is " + (parentObj == null ? "null" : parentObj.getClass()));
        }
        Map parentMap = (Map)parentObj;
        if (!parentMap.containsKey(propPathKeys[1])) {
            return "";
        }
        Object secondObj = parentMap.get(propPathKeys[1]);
        return Objects.isNull(secondObj) ? "" : secondObj;
    }

    public static List<Object> getImportBillProp(ImportBillData billData, String entity, String prop) {
        String[] propPathKeys = prop.split("\\.");
        if (propPathKeys.length > 2) {
            throw new IllegalArgumentException("current just support the depth 2. ");
        }
        JSONArray entityList = (JSONArray)billData.getData().get((Object)entity);
        ArrayList res = Lists.newArrayListWithExpectedSize((int)entityList.size());
        for (Object jObj : entityList) {
            res.add(ImportHelper.getImportBillProp((JSONObject)jObj, propPathKeys));
        }
        return res;
    }

    private static Object getImportBillProp(JSONObject jObj, String[] propPathKeys) {
        Object parentObj = jObj.get((Object)propPathKeys[0]);
        if (Objects.isNull(parentObj)) {
            return "";
        }
        if (propPathKeys.length < 2) {
            return parentObj;
        }
        if (!(parentObj instanceof Map)) {
            throw new IllegalArgumentException("invalid prop path, parentObj is " + (parentObj == null ? "null" : parentObj.getClass()));
        }
        Map parentMap = (Map)parentObj;
        if (!parentMap.containsKey(propPathKeys[1])) {
            return "";
        }
        Object secondObj = parentMap.get(propPathKeys[1]);
        return Objects.isNull(secondObj) ? "" : secondObj;
    }

    public static boolean getImportBillBooleanProp(ImportBillData billData, String prop) {
        Object value = ImportHelper.getImportBillProp(billData, prop);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return "1".equals(value.toString()) || "yes".equalsIgnoreCase(value.toString()) || ResManager.loadKDString((String)"\u662f", (String)"ImportHelper_2", (String)"epm-epbs-common", (Object[])new Object[0]).equals(value.toString()) || Boolean.TRUE.toString().equalsIgnoreCase(value.toString());
    }

    public static String buildExceptionMsg(Exception e, int stackLimit, boolean isSimple) {
        List stackMsgs = Arrays.stream(e.getStackTrace()).filter(ele -> Objects.nonNull(ele.getClassName()) && ele.getClassName().startsWith("kd.fi.bcm")).map(ele -> isSimple ? String.format("%s:%s", ele.getFileName(), ele.getLineNumber()) : ele.toString()).collect(Collectors.toList());
        if (stackLimit > 0) {
            stackMsgs = stackMsgs.subList(0, Math.min(stackMsgs.size(), stackLimit));
        }
        return String.format("%s %s[%s] %s", ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff1a", (String)"ImportHelper_3", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage(), RequestContext.get().getTraceId(), String.join((CharSequence)",", stackMsgs));
    }
}

