/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.excelimport;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.CommonServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class POIUtils {
    private static final Log log = LogFactory.getLog(POIUtils.class);

    public static POIUtils get() {
        return new POIUtils();
    }

    public void copyBook(Workbook book, Workbook cloneBook) {
        this.copyBook(book, cloneBook, null);
    }

    public void copyBook(Workbook book, Workbook cloneBook, POIConfig config) {
        if (book == null || cloneBook == null) {
            return;
        }
        int sheetCount = book.getNumberOfSheets();
        if (config == null) {
            config = POIConfig.Default;
        }
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            Sheet sheet = book.getSheetAt(sheetIndex);
            Sheet cloneSheet = cloneBook.createSheet(sheet.getSheetName());
            this.copySheet(sheet, cloneSheet, config.getSheetConfig(sheetIndex));
        }
    }

    public void copySheet(Sheet sheet, Sheet cloneSheet, SheetConfig sheetConfig) {
        if (sheet == null || cloneSheet == null) {
            return;
        }
        if (sheetConfig == null) {
            sheetConfig = SheetConfig.Default;
        }
        if (sheetConfig.COPY_Style) {
            this.copySheetStyle(sheet, cloneSheet);
        }
        this.copyMerger(sheet, cloneSheet);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Row cloneRow = cloneSheet.createRow(row.getRowNum() + sheetConfig.COPY_RowBeginIndex);
            this.copyRow(row, cloneRow, sheetConfig);
        }
    }

    public void copySheetStyle(Sheet sheet, Sheet cloneSheet) {
        if (sheet == null || cloneSheet == null || sheet.getRow(0) == null) {
            return;
        }
        int colCount = sheet.getRow(0).getPhysicalNumberOfCells();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            cloneSheet.setColumnWidth(colIndex, sheet.getColumnWidth(colIndex));
        }
    }

    public void copyMerger(Sheet sheet, Sheet cloneSheet) {
        if (sheet == null || cloneSheet == null) {
            return;
        }
        int mergerCount = sheet.getNumMergedRegions();
        for (int mergerIndex = 0; mergerIndex < mergerCount; ++mergerIndex) {
            CellRangeAddress range = sheet.getMergedRegion(mergerIndex);
            cloneSheet.addMergedRegionUnsafe(range);
        }
    }

    public void copyRow(Row row, Row cloneRow, SheetConfig sheetConfig) {
        RowConfig rowConfig;
        if (row == null || cloneRow == null) {
            return;
        }
        if (sheetConfig == null) {
            sheetConfig = SheetConfig.Default;
        }
        if ((rowConfig = sheetConfig.rowConfig) == null) {
            rowConfig = RowConfig.Default;
        }
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            Cell cell = (Cell)cells.next();
            Cell cloneCell = cloneRow.createCell(cell.getColumnIndex() + sheetConfig.COPY_ColBeginIndex, cell.getCellType());
            this.copyCell(cell, cloneCell, rowConfig.cellConfig);
        }
    }

    public void copyCell(Cell cell, Cell cloneCell, CellConfig cellConfig) {
        CellType cellType;
        if (cell == null || cloneCell == null) {
            return;
        }
        if (cellConfig == null) {
            cellConfig = CellConfig.Default;
        }
        if ((cellType = cell.getCellType()) == CellType.STRING) {
            cloneCell.setCellValue(cell.getStringCellValue());
        } else if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                cloneCell.setCellValue(cell.getDateCellValue());
            } else {
                cloneCell.setCellValue(cell.getNumericCellValue());
            }
        } else if (cellType == CellType.FORMULA) {
            cloneCell.setCellValue(cell.getCellFormula());
        }
        if (cellConfig.COPY_Style) {
            this.copyCellStyle(cell.getCellStyle(), cloneCell.getCellStyle());
        }
    }

    public void copyCellStyle(CellStyle style, CellStyle cloneStyle) {
        if (style == null || cloneStyle == null) {
            return;
        }
        cloneStyle.setAlignment(style.getAlignment());
        cloneStyle.setBorderTop(style.getBorderTop());
        cloneStyle.setBorderBottom(style.getBorderBottom());
        cloneStyle.setBorderLeft(style.getBorderLeft());
        cloneStyle.setBorderRight(style.getBorderRight());
        cloneStyle.setTopBorderColor(style.getTopBorderColor());
        cloneStyle.setBottomBorderColor(style.getBottomBorderColor());
        cloneStyle.setLeftBorderColor(style.getLeftBorderColor());
        cloneStyle.setRightBorderColor(style.getRightBorderColor());
        cloneStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        cloneStyle.setFillForegroundColor(style.getFillForegroundColor());
        cloneStyle.setDataFormat(style.getDataFormat());
        cloneStyle.setFillPattern(style.getFillPattern());
        cloneStyle.setHidden(style.getHidden());
        cloneStyle.setIndention(style.getIndention());
        cloneStyle.setLocked(style.getLocked());
        cloneStyle.setRotation(style.getRotation());
        cloneStyle.setVerticalAlignment(style.getVerticalAlignment());
        cloneStyle.setWrapText(style.getWrapText());
    }

    public static boolean isBreak(Row row, int lastCellNum) {
        if (row == null || lastCellNum == -1) {
            return true;
        }
        for (int i = 0; i < lastCellNum; ++i) {
            String value = POIUtils.getStringValue(row.getCell(i));
            if (!StringUtils.isNotEmpty((String)value)) continue;
            return false;
        }
        return true;
    }

    public static Cell getCell(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell;
        if (sheet == null) {
            return null;
        }
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(colIndex)) == null) {
            cell = row.createCell(colIndex);
        }
        return cell;
    }

    public static String getStringValue(Cell cell) {
        if (cell == null || CellType.BLANK == cell.getCellType()) {
            return null;
        }
        if (CellType.STRING == cell.getCellType()) {
            return cell.getStringCellValue().trim();
        }
        if (CellType.NUMERIC == cell.getCellType()) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        return null;
    }

    public static void setCellStyleOfRed(Cell cell) {
        if (cell == null) {
            return;
        }
        CellStyle style = POIUtils.getErrorStyle(cell.getSheet().getWorkbook());
        cell.setCellStyle(style);
    }

    public static CellStyle getErrorStyle(Workbook book) {
        CellStyle style = book.createCellStyle();
        Font font = book.createFont();
        font.setColor((short)10);
        style.setFont(font);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.LEFT);
        return style;
    }

    public static void downloadFile(@NotNull IFormView view, @NotNull Workbook errorBook) {
        POIUtils.downloadFile(view, null, errorBook);
    }

    public static void downloadFile(@NotNull IFormView view, String filename, @NotNull Workbook errorBook) {
        if (filename == null) {
            filename = ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u51fa\u9519\u8be6\u60c5", (String)"POIUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]);
        }
        try {
            String fileUrl = POIUtils.writeFile(errorBook, filename);
            if (StringUtils.isNotEmpty((String)fileUrl)) {
                POIUtils.downloadFile(view, fileUrl);
            }
        }
        catch (IOException ex) {
            log.error((Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public static void downloadFile(@NotNull IFormView view, @NotNull String url) {
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    public static String downloadFile(File file) {
        ByteArrayInputStream inStream;
        ByteArrayOutputStream outStream;
        block9: {
            outStream = null;
            inStream = null;
            BufferedInputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[((InputStream)fis).available()];
                ((InputStream)fis).read(buffer);
                outStream = new ByteArrayOutputStream();
                outStream.write(buffer);
                outStream.flush();
                inStream = new ByteArrayInputStream(outStream.toByteArray());
                if (fis == null) break block9;
            }
            catch (IOException e) {
                try {
                    throw new KDBizException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        POIUtils.safeClose(fis);
                    }
                    if (inStream != null) {
                        POIUtils.safeClose(inStream);
                    }
                    if (outStream != null) {
                        POIUtils.safeClose(outStream);
                    }
                    throw throwable;
                }
            }
            POIUtils.safeClose((Closeable)fis);
        }
        if (inStream != null) {
            POIUtils.safeClose((Closeable)inStream);
        }
        if (outStream != null) {
            POIUtils.safeClose((Closeable)outStream);
        }
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(file.getName(), (InputStream)inStream, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(@NotNull Workbook book, @NotNull String fileName) throws IOException {
        String fileUrl;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            book.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileUrl = book instanceof XSSFWorkbook ? CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000) : CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xls", (InputStream)inStream, 10000);
        }
        catch (Throwable throwable) {
            POIUtils.safeClose(outStream, inStream);
            throw throwable;
        }
        POIUtils.safeClose(outStream, inStream);
        return fileUrl;
    }

    public static void safeClose(Iterable<Closeable> closeables) {
        if (closeables != null) {
            for (Closeable _closeable : closeables) {
                POIUtils.safeClose(_closeable);
            }
        }
    }

    public static void safeClose(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable _closeable : closeables) {
                POIUtils.safeClose(_closeable);
            }
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                log.error("close-error:", (Object)CommonServiceHelper.getStackTraceStr(ex));
            }
        }
    }

    public static boolean isExistValueRow(Row row) {
        boolean existValueRow = false;
        Iterator iterator = row.cellIterator();
        while (iterator.hasNext()) {
            Cell curRowCell = (Cell)iterator.next();
            String curRowCellValue = POIUtils.getStringValue(curRowCell);
            if (!StringUtils.isNotEmpty((String)curRowCellValue)) continue;
            existValueRow = true;
            break;
        }
        return existValueRow;
    }

    @NotNull
    public CellStyle getTextCellStyle(Workbook workbook) {
        CellStyle textStyle = workbook.createCellStyle();
        DataFormat dataFormat = workbook.createDataFormat();
        textStyle.setDataFormat(dataFormat.getFormat("@"));
        return textStyle;
    }

    public static class CellConfig {
        public static final CellConfig Default = new CellConfig();
        public boolean COPY_Style = true;
    }

    public static class RowConfig {
        public static final RowConfig Default = new RowConfig();
        public CellConfig cellConfig = new CellConfig();
    }

    public static class SheetConfig {
        public static final SheetConfig Default = new SheetConfig();
        public int COPY_RowBeginIndex = 0;
        public int COPY_ColBeginIndex = 0;
        public boolean COPY_Style = true;
        public RowConfig rowConfig = new RowConfig();
    }

    public static class POIConfig {
        public static final POIConfig Default = new POIConfig();
        private final Map<Integer, SheetConfig> sheetConfigs = Maps.newLinkedHashMap();

        public SheetConfig getSheetConfig(int sheetIndex) {
            return this.sheetConfigs.computeIfAbsent(sheetIndex, f -> new SheetConfig());
        }
    }
}

