/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.export.ExportDynamicParamVo;
import kd.epm.epbs.common.util.GZIPUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class ExportDynamicUtil {
    public static void export(ExportDynamicParamVo exportDynamicParamVo) {
        try {
            List<DynamicObject> dynamicObjects;
            JSONArray jsonArray = new JSONArray();
            HashSet<String> dyTypeIdSet = new HashSet<String>(16);
            dyTypeIdSet.addAll(exportDynamicParamVo.getIgPkSet());
            for (DynamicObject object : exportDynamicParamVo.getMainResources()) {
                jsonArray.add(ExportDynamicUtil.dynamicObjectToJSON(object, false));
                dynamicObjects = ExportDynamicUtil.parseDynamicObject(object, dyTypeIdSet, exportDynamicParamVo.getIgEntitySet());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    jsonArray.add(ExportDynamicUtil.dynamicObjectToJSON(dynamicObject, true));
                }
            }
            if (exportDynamicParamVo.getRefResources() != null) {
                for (DynamicObject refObject : exportDynamicParamVo.getRefResources()) {
                    jsonArray.add(ExportDynamicUtil.dynamicObjectToJSON(refObject, true));
                    dynamicObjects = ExportDynamicUtil.parseDynamicObject(refObject, dyTypeIdSet, exportDynamicParamVo.getIgEntitySet());
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        jsonArray.add(ExportDynamicUtil.dynamicObjectToJSON(dynamicObject, true));
                    }
                }
            }
            ObjectMapper mapper = JSONUtils.getMapper();
            String jsonString = mapper.writeValueAsString((Object)jsonArray);
            byte[] bytes = GZIPUtils.zipAndBase64(jsonString).getBytes(StandardCharsets.UTF_8);
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(exportDynamicParamVo.getFileName(), (InputStream)input, 1800);
                IFormView view = exportDynamicParamVo.getView();
                view.openUrl(urls);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExportDynamicUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static Map<String, Object> dynamicObjectToJSON(DynamicObject dynamicObject, boolean isRef) {
        String serializedToDynaObj = ObjectSerialUtil.toSerializedToDynaObj(dynamicObject);
        JSONObject jsonObject = JSON.parseObject((String)serializedToDynaObj);
        jsonObject.put("$id", dynamicObject.getPkValue());
        jsonObject.put("$entityname", (Object)dynamicObject.getDataEntityType().getName());
        jsonObject.put("$isref", (Object)isRef);
        return jsonObject;
    }

    private static List<DynamicObject> parseDynamicObject(DynamicObject dynamicObject, Set<String> dyTypeIdSet, Set<String> igEntityList) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
        if (dynamicObject != null) {
            DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
            String dynamicObjectTypeName = dynamicObjectType.getName();
            if (dynamicObjectType instanceof BillEntityType && !igEntityList.contains(dynamicObjectTypeName)) {
                DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                for (IDataEntityProperty property : properties) {
                    String name = property.getName();
                    if (property instanceof UserProp) continue;
                    if (property instanceof BasedataProp) {
                        DynamicObject basedata = dynamicObject.getDynamicObject(name);
                        if (basedata == null) continue;
                        String basedataName = basedata.getDynamicObjectType().getName();
                        DynamicObject basedataLoad = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)basedataName);
                        if (igEntityList.contains(basedataName) || !dyTypeIdSet.add(basedataName + "_" + basedataLoad.getPkValue())) continue;
                        dynamicObjects.add(basedataLoad);
                        dynamicObjects.addAll(ExportDynamicUtil.parseDynamicObject(basedataLoad, dyTypeIdSet, igEntityList));
                        continue;
                    }
                    if (!(property instanceof DynamicCollectionProperty)) continue;
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(name);
                    for (DynamicObject object : dynamicObjectCollection) {
                        dynamicObjects.addAll(ExportDynamicUtil.parseDynamicObject(object, dyTypeIdSet, igEntityList));
                    }
                }
            }
        }
        return dynamicObjects;
    }
}

