/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.fileImport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.excel.AbstractExcelUtils;
import kd.epm.epbs.common.fileImport.entity.Header;
import kd.epm.epbs.common.fileImport.entity.ImportEntity;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileImportUtils
extends AbstractExcelUtils {
    private ImportEntity importEntity;

    public static FileImportUtils getInstance(ImportEntity importEntity) {
        return new FileImportUtils(importEntity);
    }

    public static FileImportUtils getInstance() {
        return new FileImportUtils();
    }

    public FileImportUtils(ImportEntity importEntity) {
        this.importEntity = importEntity;
    }

    public FileImportUtils() {
    }

    public Workbook createImportTemplate() {
        XSSFWorkbook excelBook = new XSSFWorkbook();
        this.createImportSheetIndex((Workbook)excelBook, 0);
        return excelBook;
    }

    public void createImportSheetIndex(Workbook excelBook, int startColumn) {
        Sheet sheetIndex = null;
        String sheetName = this.importEntity.getSheetName();
        sheetIndex = StringUtils.isEmpty((String)sheetName) ? excelBook.createSheet("sheet1") : excelBook.createSheet(sheetName);
        Row titleRow = this.getRow(sheetIndex, 0);
        Cell titleCell = this.getCell(titleRow, startColumn);
        this.setCellStringValue(titleCell, this.importEntity.getSheetTitle());
        Row noteRow = this.getRow(sheetIndex, 1);
        Cell noteCell = this.getCell(noteRow, startColumn);
        this.setCellStringValue(noteCell, this.importEntity.getSheetNotes());
        this.setFontColor(this.createCellstyle(noteCell), this.createXSSFFont(noteCell), IndexedColors.RED);
        Row headRow = this.getRow(sheetIndex, 2);
        Cell headCell = null;
        Map<String, Header> sheetHeaderMap = this.importEntity.getSheetHeaderMap();
        int i = startColumn;
        for (Map.Entry<String, Header> entry : sheetHeaderMap.entrySet()) {
            Header header = entry.getValue();
            headCell = this.getCell(headRow, i);
            String headName = header.getHeader();
            this.setCellStringValue(headCell, headName);
            CellStyle cellstyle = this.createCellstyle(headCell);
            if (headName != null && headName.startsWith("*")) {
                this.setFontColor(cellstyle, this.createXSSFFont(headCell), IndexedColors.RED);
            }
            this.setBackgroundColor(cellstyle, IndexedColors.GREY_25_PERCENT);
            sheetIndex.setColumnWidth(headCell.getColumnIndex(), 5120);
            this.setCellTips(headCell, header.getTips());
            ++i;
        }
        Map<Integer, String[]> comboBoxList = this.importEntity.getComboBoxList();
        for (Map.Entry<Integer, String[]> entry : comboBoxList.entrySet()) {
            this.setColumnFormatAsCombo(sheetIndex, entry.getKey() + startColumn, entry.getValue());
        }
        if (startColumn >= 1) {
            String string = ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5", (String)"FileImportUtils_1", (String)"epm-epbs-common", (Object[])new Object[0]);
            Cell cell = this.getCell(headRow, 0);
            this.setCellStringValue(cell, string);
            this.setFontColor(this.createCellstyle(cell), this.createXSSFFont(cell), IndexedColors.BLUE);
            sheetIndex.setColumnWidth(0, 10240);
            if (startColumn == 2) {
                Cell cell2 = this.getCell(headRow, 1);
                String string2 = ResManager.loadKDString((String)"\u9519\u8bef\u884c", (String)"FileImportUtils_2", (String)"epm-epbs-common", (Object[])new Object[0]);
                this.setCellStringValue(cell2, string2);
                this.setFontColor(this.createCellstyle(cell2), this.createXSSFFont(cell2), IndexedColors.BLUE);
                sheetIndex.setColumnWidth(0, 10240);
            }
        }
    }

    public Row getRow(Sheet sheet, int rowNum) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            row = sheet.createRow(rowNum);
        }
        return row;
    }

    public Cell getCell(Row row, int columnIndex) {
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public void setCellStringValue(Cell cell, String value) {
        cell.setCellType(CellType.STRING);
        if (value != null && value.length() > Short.MAX_VALUE) {
            value = value.substring(0, Short.MAX_VALUE);
        }
        cell.setCellValue(value);
    }

    public void setCellObjValue(Cell cell, Object value) {
        if (value instanceof BigDecimal || value instanceof Double || value instanceof Integer || value instanceof Float) {
            BigDecimal numberValue = new BigDecimal(String.valueOf(value));
            cell.setCellType(CellType.NUMERIC);
            cell.setCellValue(numberValue.doubleValue());
        } else {
            this.setCellStringValue(cell, String.valueOf(value));
        }
    }

    public String getCellStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (CellType.STRING.equals((Object)cell.getCellType())) {
            return cell.getStringCellValue().trim();
        }
        if (CellType.NUMERIC.equals((Object)cell.getCellType())) {
            return NumberToTextConverter.toText((double)cell.getNumericCellValue()).trim();
        }
        return "";
    }

    public String getCellValue(FormulaEvaluator evaluator, Cell cell) {
        if (cell != null && CellType.FORMULA.equals((Object)cell.getCellType())) {
            CellValue evaluate = evaluator.evaluate(cell);
            return evaluate.formatAsString();
        }
        return this.getCellStringValue(cell);
    }

    public CellStyle createCellstyle(Cell cell) {
        CellStyle cellStyle = cell.getRow().getSheet().getWorkbook().createCellStyle();
        cell.setCellStyle(cellStyle);
        return cellStyle;
    }

    public Font createXSSFFont(Cell cell) {
        return cell.getRow().getSheet().getWorkbook().createFont();
    }

    public void setFontColor(CellStyle cellStyle, Font font, IndexedColors color) {
        font.setColor(color.index);
        cellStyle.setFont(font);
    }

    public void setBackgroundColor(CellStyle cellStyle, IndexedColors color) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(color.index);
    }

    public void setCellTips(Cell cell, String tips) {
        Sheet sheet = cell.getRow().getSheet();
        Drawing draw = sheet.createDrawingPatriarch();
        if (cell instanceof XSSFCell) {
            XSSFClientAnchor clientAnchor = new XSSFClientAnchor();
            Comment comment = draw.createCellComment((ClientAnchor)clientAnchor);
            XSSFRichTextString rtf = new XSSFRichTextString(tips);
            comment.setString((RichTextString)rtf);
            cell.setCellComment(comment);
        } else if (cell instanceof HSSFCell) {
            HSSFClientAnchor clientAnchor = new HSSFClientAnchor();
            Comment comment = draw.createCellComment((ClientAnchor)clientAnchor);
            HSSFRichTextString rtf = new HSSFRichTextString(tips);
            comment.setString((RichTextString)rtf);
            cell.setCellComment(comment);
        }
    }

    public void setColumnFormatAsCombo(Sheet sheet, int columnNum, String[] textList) {
        XSSFDataValidationHelper dvHelper = null;
        if (sheet instanceof XSSFSheet) {
            dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
        } else if (sheet instanceof HSSFSheet) {
            dvHelper = new HSSFDataValidationHelper((HSSFSheet)sheet);
        }
        if (dvHelper != null) {
            DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(textList);
            CellRangeAddressList addressList = new CellRangeAddressList(3, 50000, columnNum, columnNum);
            XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation(dvConstraint, addressList);
            sheet.addValidationData((DataValidation)validation);
        }
    }

    public String saveFileAsUrl(Workbook excelBook, String fileName) {
        String string;
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            excelBook.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
        }
        catch (IOException e) {
            try {
                KDBizException kdBizException = new KDBizException(e.getMessage());
                kdBizException.initCause((Throwable)e);
                throw kdBizException;
            }
            catch (Throwable throwable) {
                this.close(outStream);
                this.close(inStream);
                throw throwable;
            }
        }
        this.close(outStream);
        this.close(inStream);
        return string;
    }

    public boolean checkTemplate(Sheet sheet) {
        Row row = this.getRow(sheet, 2);
        Map<String, Header> headerMap = this.importEntity.getSheetHeaderMap();
        for (Map.Entry<String, Header> entry : headerMap.entrySet()) {
            Cell cell = this.getCell(row, Integer.parseInt(entry.getKey()));
            if (entry.getValue().getHeader().equals(this.getCellStringValue(cell))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isNullRow(Row row) {
        Cell cell = null;
        Map<String, Header> headerMap = this.importEntity.getSheetHeaderMap();
        for (Map.Entry<String, Header> entry : headerMap.entrySet()) {
            cell = this.getCell(row, Integer.parseInt(entry.getKey()));
            if (entry.getValue().getHeader().startsWith("~") || !StringUtils.isNotEmpty((String)this.getCellStringValue(cell))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Row createErrorRowByTemplate(Workbook errorBook, Row row) {
        Sheet sheet = errorBook.getSheetAt(0);
        Row errorRow = this.getRow(sheet, row.getRowNum());
        for (int i = 0; i < this.importEntity.getSheetHeaderMap().size(); ++i) {
            this.setCellStringValue(this.getCell(errorRow, i + 1), this.getCellStringValue(this.getCell(row, i)));
        }
        return errorRow;
    }

    public void writeErrorTip(Row errorRow, String tip) {
        Cell cell = this.getCell(errorRow, 0);
        this.setCellStringValue(cell, tip);
        this.setFontColor(this.createCellstyle(cell), this.createXSSFFont(cell), IndexedColors.RED);
    }

    public int getRealCount(Sheet sheet, int endValidRowIndex, int endValidCellIndex) {
        int lastRowNum = sheet.getLastRowNum();
        int realLastRowNum = 0;
        for (int i = lastRowNum; i > endValidRowIndex; --i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            boolean isEmpty = true;
            for (int j = 0; j <= endValidCellIndex; ++j) {
                String cellStringValue;
                Cell cell = row.getCell(j);
                if (cell == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(cellStringValue = this.getCellStringValue(cell)))) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) continue;
            realLastRowNum = i;
            break;
        }
        return realLastRowNum;
    }

    public void downloadErrorFile(InputStream inputStream, IFormView formView, String fileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inputStream, 10000);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)url)) {
            ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
    }

    public void resetCellMaxTextLength() {
    }
}

