/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.formula;

import java.util.List;
import java.util.Stack;
import kd.epm.epbs.common.formula.expr.BinaryOperationExpr;
import kd.epm.epbs.common.formula.expr.BoolExpr;
import kd.epm.epbs.common.formula.expr.EmptyArgExpr;
import kd.epm.epbs.common.formula.expr.Expression;
import kd.epm.epbs.common.formula.expr.FunctionExpr;
import kd.epm.epbs.common.formula.expr.IntExpr;
import kd.epm.epbs.common.formula.expr.NameExpr;
import kd.epm.epbs.common.formula.expr.NumberExpr;
import kd.epm.epbs.common.formula.expr.StringExpr;
import kd.epm.epbs.common.formula.expr.UnaryOperationExpr;
import kd.epm.epbs.common.formula.ptg.AddPtg;
import kd.epm.epbs.common.formula.ptg.BoolPtg;
import kd.epm.epbs.common.formula.ptg.ConcatPtg;
import kd.epm.epbs.common.formula.ptg.DividePtg;
import kd.epm.epbs.common.formula.ptg.EmptyArgPtg;
import kd.epm.epbs.common.formula.ptg.EqualPtg;
import kd.epm.epbs.common.formula.ptg.FuncVarPtg;
import kd.epm.epbs.common.formula.ptg.GreaterEqualPtg;
import kd.epm.epbs.common.formula.ptg.GreaterThanPtg;
import kd.epm.epbs.common.formula.ptg.IntPtg;
import kd.epm.epbs.common.formula.ptg.LessEqualPtg;
import kd.epm.epbs.common.formula.ptg.LessThanPtg;
import kd.epm.epbs.common.formula.ptg.MultiplyPtg;
import kd.epm.epbs.common.formula.ptg.NamePtg;
import kd.epm.epbs.common.formula.ptg.NotEqualPtg;
import kd.epm.epbs.common.formula.ptg.NumberPtg;
import kd.epm.epbs.common.formula.ptg.OperationPtg;
import kd.epm.epbs.common.formula.ptg.PercentPtg;
import kd.epm.epbs.common.formula.ptg.PowerPtg;
import kd.epm.epbs.common.formula.ptg.StringPtg;
import kd.epm.epbs.common.formula.ptg.SubtractPtg;
import kd.epm.epbs.common.formula.ptg.UnaryMinusPtg;
import kd.epm.epbs.common.formula.ptg.UnaryPlusPtg;

public class ExcelFormulaParser {
    private final List<Object> tokens;

    public ExcelFormulaParser(List<Object> tokens) {
        this.tokens = tokens;
    }

    public Expression parse() throws Exception {
        if (this.tokens == null || this.tokens.isEmpty()) {
            return null;
        }
        Stack<Expression> stack = new Stack<Expression>();
        for (Object object : this.tokens) {
            Expression e;
            if (object instanceof OperationPtg) {
                if (object instanceof AddPtg) {
                    this.buildBinaryOp(stack, 7);
                    continue;
                }
                if (object instanceof SubtractPtg) {
                    this.buildBinaryOp(stack, 8);
                    continue;
                }
                if (object instanceof MultiplyPtg) {
                    this.buildBinaryOp(stack, 5);
                    continue;
                }
                if (object instanceof DividePtg) {
                    this.buildBinaryOp(stack, 6);
                    continue;
                }
                if (object instanceof PowerPtg) {
                    this.buildBinaryOp(stack, 4);
                    continue;
                }
                if (object instanceof LessEqualPtg) {
                    this.buildBinaryOp(stack, 13);
                    continue;
                }
                if (object instanceof EqualPtg) {
                    this.buildBinaryOp(stack, 10);
                    continue;
                }
                if (object instanceof LessThanPtg) {
                    this.buildBinaryOp(stack, 14);
                    continue;
                }
                if (object instanceof NotEqualPtg) {
                    this.buildBinaryOp(stack, 15);
                    continue;
                }
                if (object instanceof GreaterEqualPtg) {
                    this.buildBinaryOp(stack, 11);
                    continue;
                }
                if (object instanceof GreaterThanPtg) {
                    this.buildBinaryOp(stack, 12);
                    continue;
                }
                if (object instanceof ConcatPtg) {
                    this.buildBinaryOp(stack, 9);
                    continue;
                }
                if (object instanceof FuncVarPtg) {
                    FunctionExpr bop = new FunctionExpr(((FuncVarPtg)object).getName());
                    int numOperands = ((FuncVarPtg)object).getNumberOfOperands();
                    for (int j = 0; j < numOperands; ++j) {
                        bop.getParameters().add(0, stack.pop());
                    }
                    stack.push(bop);
                    continue;
                }
                if (!(object instanceof UnaryMinusPtg) && !(object instanceof UnaryPlusPtg) && !(object instanceof PercentPtg)) continue;
                Expression expr = stack.pop();
                int type = object instanceof UnaryPlusPtg ? 1 : (object instanceof UnaryMinusPtg ? 2 : 3);
                UnaryOperationExpr e2 = new UnaryOperationExpr(type);
                e2.setOperand(expr);
                stack.push(e2);
                continue;
            }
            if (object instanceof IntPtg) {
                e = new IntExpr();
                e.setValue(((IntPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof NumberPtg) {
                e = new NumberExpr(((NumberPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof StringPtg) {
                e = new StringExpr(((StringPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof BoolPtg) {
                e = new BoolExpr(((BoolPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof NamePtg) {
                stack.push(new NameExpr(((NamePtg)object).getText()));
                continue;
            }
            if (!(object instanceof EmptyArgPtg)) continue;
            stack.push(new EmptyArgExpr());
        }
        return (Expression)stack.pop();
    }

    public void buildBinaryOp(Stack<Expression> stack, int type) {
        BinaryOperationExpr bop = new BinaryOperationExpr(type);
        bop.setRight(stack.pop());
        bop.setLeft(stack.pop());
        stack.push(bop);
    }
}

