/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.f7;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.member.f7.ITreeBuilder;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMemberF7Parameter
implements Serializable,
ITreeBuilder {
    protected static final Log log = LogFactory.getLog(AbstractMemberF7Parameter.class);
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_SHOW = 0;
    public static final int SHOW_RANGE = 1;
    private int functionType = 0;
    private boolean verifyPermission = true;
    @JsonIgnore
    private boolean checkPermission = false;
    @JsonIgnore
    private transient Set<Long> permissionIds = null;
    @JsonIgnore
    private boolean checkManagerPermission = false;
    @JsonIgnore
    private transient Set<Long> managerPermissionIds = null;
    private boolean verifyManagerPermission = false;
    private boolean showLeaf = false;
    private boolean cutTree = true;
    private Map<Long, Integer> selectRange = null;
    private Map<Long, Integer> rangeLevel = null;
    private Set<Long> selectRangeIds = null;
    private boolean mustSelected = true;
    private boolean showDisableVisible = true;
    private boolean showDisable = false;
    private boolean showNotEnable = false;
    private String fields = null;
    private transient QFBuilder treeBuilder = null;
    private transient QFBuilder noTreeBuilder = null;
    private boolean isFillParent = false;
    private boolean canSelectRoot = true;
    private String customCommFilters = null;
    private boolean onlySelLeaf = false;
    public String customFilters = null;
    private Long modelId;
    private Long dimensionId;
    private String dimensionNumber;
    private String dimensionName = null;
    private boolean stepLoad = false;
    protected String orderBy;
    private boolean multiSelect = true;
    protected List<String> selectIds = null;
    private String entityNumber = null;
    private boolean showView = true;
    private boolean showCustomProperty;
    private String showType;
    private String showScope;
    private transient DynamicObject dimension = null;
    private transient DynamicObject rootMember = null;
    private static final String DEFAULT_ORDER = "longnumber";
    private Long version = 0L;
    private List<String> cusRange = null;
    private boolean lockRangeSelect = false;
    private boolean showLevel = false;
    private boolean showExclude = false;
    private Set<Long> excludeMemberIds = null;
    private boolean showChildren = true;
    private boolean includeChildren = true;
    private Long rootMemberId = null;
    private boolean showCustomPropertyColumn = true;
    private Long viewId = null;
    private String viewNumber = null;
    private boolean enableView = false;
    private String defRangeValue = null;
    private String returnClassName = null;
    private boolean returnAllData = false;
    protected Boolean isView = null;
    private String viewSign = null;
    private List<Long> viewFilterList;
    private boolean isFloat = true;
    private boolean isFloatAddNew = false;
    private Long floatParentId = null;
    private boolean clearSelectWhenChangeView = true;

    public void setFunctionType(int functionType) {
        this.functionType = functionType;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public void setVerifyPermission(boolean verifyPermission) {
        this.verifyPermission = verifyPermission;
    }

    public boolean isVerifyPermission() {
        return this.verifyPermission;
    }

    public Set<Long> getPermissionIds() {
        return this.$loadPermission();
    }

    public QFilter getPermissionIdFilter() {
        return null;
    }

    public Set<Long> $loadPermission() {
        if (!this.checkPermission) {
            this.permissionIds = this.loadPermission();
            this.checkPermission = true;
        }
        return this.permissionIds;
    }

    protected abstract Set<Long> loadPermission();

    public void setVerifyManagerPermission(boolean verifyManagerPermission) {
        this.verifyManagerPermission = verifyManagerPermission;
    }

    public boolean isVerifyManagerPermission() {
        return this.verifyManagerPermission;
    }

    public void setShowLeaf(boolean showLeaf) {
        this.showLeaf = showLeaf;
    }

    public boolean isShowLeaf() {
        return this.showLeaf;
    }

    public void setCutTree(boolean cutTree) {
        this.cutTree = cutTree;
    }

    public boolean isCutTree() {
        return this.cutTree;
    }

    public void setSelectRange(Map<Long, Integer> selectRange) {
        this.selectRange = selectRange;
    }

    public Map<Long, Integer> getSelectRange() {
        return this.selectRange;
    }

    public void addSelectRange(@NotNull Long memberId, int range) {
        if (IDUtils.isNull(memberId)) {
            return;
        }
        if (this.selectRange == null) {
            this.selectRange = Maps.newLinkedHashMap();
        }
        this.selectRange.put(memberId, range);
    }

    public void addSelectRange(Map<Long, Integer> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        if (this.selectRange == null) {
            this.selectRange = Maps.newLinkedHashMap();
        }
        this.selectRange.putAll(ranges);
    }

    public void setRangeLevel(Map<Long, Integer> rangeLevel) {
        this.rangeLevel = rangeLevel;
    }

    public Map<Long, Integer> getRangeLevel() {
        return this.rangeLevel;
    }

    public void addRangeLevel(Long memberId, int level) {
        if (IDUtils.isNull(memberId) || level <= 0) {
            return;
        }
        if (this.rangeLevel == null) {
            this.rangeLevel = Maps.newLinkedHashMap();
        }
        this.rangeLevel.put(memberId, level);
    }

    public void addRangeLevel(Map<Long, Integer> rangeLevels) {
        if (rangeLevels == null || rangeLevels.isEmpty()) {
            return;
        }
        if (this.rangeLevel == null) {
            this.rangeLevel = Maps.newLinkedHashMap();
        }
        this.rangeLevel.putAll(rangeLevels);
    }

    public void setSelectRangeIds(Set<Long> selectRangeIds) {
        this.selectRangeIds = selectRangeIds;
    }

    public Set<Long> getSelectRangeIds() {
        return this.selectRangeIds;
    }

    public void setMustSelected(boolean mustSelected) {
        this.mustSelected = mustSelected;
    }

    public boolean isMustSelected() {
        return this.mustSelected;
    }

    public void setShowDisableVisible(boolean showDisableVisible) {
        this.showDisableVisible = showDisableVisible;
    }

    public boolean isShowDisableVisible() {
        return this.showDisableVisible;
    }

    public void setShowDisable(boolean showDisable) {
        this.showDisable = showDisable;
    }

    public boolean isShowDisable() {
        return this.showDisable;
    }

    public boolean isShowNotEnable() {
        return this.showNotEnable;
    }

    public void setShowNotEnable(boolean showNotEnable) {
        this.showNotEnable = showNotEnable;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String getFields() {
        return this.fields;
    }

    public String fields() {
        return this.fields;
    }

    public QFBuilder filters() {
        return this.filters(false);
    }

    public QFBuilder filters(boolean isBuildTree) {
        if (isBuildTree) {
            if (this.treeBuilder == null) {
                this.treeBuilder = this.$filters(true);
            }
            return this.treeBuilder;
        }
        if (this.noTreeBuilder == null) {
            this.noTreeBuilder = this.$filters(false);
        }
        return this.noTreeBuilder;
    }

    public QFilter getModelFilter() {
        return new QFilter("model", "=", (Object)this.modelId);
    }

    public QFilter getDimensionFilter() {
        return new QFilter("dimension", "=", (Object)this.dimensionId);
    }

    public void setFillParent(boolean fillParent) {
        this.isFillParent = fillParent;
    }

    protected QFBuilder $filters(boolean isBuildTree) {
        log.info("begin-filters.");
        QFBuilder builder = new QFBuilder();
        builder.add(this.getModelFilter());
        builder.add(this.getDimensionFilter());
        if (!this.isShowNotEnable()) {
            builder.add("enable", "=", "1");
        }
        if (this.isShowDisable()) {
            builder.remove("enable");
        }
        if (!this.isCanSelectRoot() && !isBuildTree) {
            builder.add("level", ">", 1);
        }
        if (this.getCustomCommFilters() != null) {
            builder.add(this.customCommFilter());
        }
        if (isBuildTree) {
            if (this.getSelectRangeIds() != null) {
                HashSet<Long> tmpIds = new HashSet<Long>(this.getSelectRangeIds());
                if (tmpIds.isEmpty()) {
                    tmpIds.add(0L);
                }
                builder.add(this.pkField(), "in", tmpIds);
            }
        } else if (!this.isFillParent) {
            if (this.isVerifyPermission()) {
                Set<Long> _permissionIds = this.$loadPermission();
                if (_permissionIds != null) {
                    if (_permissionIds.isEmpty()) {
                        log.info("f7-permission-is-null");
                        builder.add(this.pkField(), "=", 0L);
                    } else if (this.getPermissionIdFilter() == null) {
                        builder.add(this.pkField(), "in", _permissionIds);
                    } else {
                        builder.add(this.getPermissionIdFilter());
                    }
                } else {
                    log.info("f7-is-model-manager");
                }
            } else {
                log.info("f7-not-verifyPermission");
            }
            if (this.isVerifyManagerPermission()) {
                if (!this.checkManagerPermission) {
                    this.managerPermissionIds = this.loadManagerPermission();
                    this.checkManagerPermission = true;
                }
                if (this.managerPermissionIds != null) {
                    if (this.managerPermissionIds.isEmpty()) {
                        log.info("f7-managerPermission-is-null");
                        builder.add(this.pkField(), "=", 0L);
                    } else {
                        builder.add(this.pkField(), "in", this.managerPermissionIds);
                    }
                } else {
                    log.info("f7-is-model-manager");
                }
            } else {
                log.info("f7-not-verifyManagerPermission");
            }
        }
        log.info(builder.toString());
        log.info("end-filters.");
        return builder;
    }

    protected abstract QFilter getSelectRangeFilter();

    public QFBuilder listFilter() {
        QFBuilder builder = this.filters();
        if (this.getSelectRange() != null && !this.getSelectRange().isEmpty()) {
            QFilter selectRangeFilter = this.getSelectRangeFilter();
            if (selectRangeFilter != null) {
                builder.add(selectRangeFilter);
            }
        } else if (this.getSelectRangeIds() != null) {
            HashSet<Long> _selectRangeIds = new HashSet<Long>(this.getSelectRangeIds());
            if (_selectRangeIds.isEmpty()) {
                builder.add(this.pkField(), "=", 0L);
            } else {
                builder.add(this.pkField(), "in", _selectRangeIds);
            }
        }
        if (this.isOnlySelLeaf()) {
            builder.add("isleaf", "=", "1");
        }
        if (this.getCustomFilters() != null) {
            builder.add(this.customFilter());
        }
        return builder;
    }

    protected QFilter getBusinessFilter() {
        return null;
    }

    @JsonIgnore
    public String pkField() {
        return this.isView() ? "memberid" : "id";
    }

    public Set<Long> loadManagerPermission() {
        return null;
    }

    public void setCanSelectRoot(boolean canSelectRoot) {
        this.canSelectRoot = canSelectRoot;
    }

    public boolean isCanSelectRoot() {
        return this.canSelectRoot;
    }

    public void setCustomCommFilters(String customCommFilters) {
        this.customCommFilters = customCommFilters;
    }

    public String getCustomCommFilters() {
        return this.customCommFilters;
    }

    public QFilter customCommFilter() {
        if (this.customCommFilters != null) {
            return QFilter.fromSerializedString((String)this.customCommFilters);
        }
        return null;
    }

    public void addCustomCommFilter(List<QFilter> filters) {
        QFilter filter;
        if (filters == null || filters.isEmpty()) {
            return;
        }
        int index = 0;
        if (StringUtils.isNotEmpty((CharSequence)this.customCommFilters)) {
            filter = QFilter.fromSerializedString((String)this.customCommFilters);
        } else {
            filter = filters.get(0);
            index = 1;
        }
        int in = filters.size();
        for (int i = index; i < in; ++i) {
            filter.and(filters.get(i));
        }
        this.customCommFilters = filter.toSerializedString();
    }

    public void addCustomCommFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        this.addCustomCommFilter(Collections.singletonList(filter));
    }

    public void setOnlySelLeaf(boolean onlySelLeaf) {
        this.onlySelLeaf = onlySelLeaf;
    }

    public boolean isOnlySelLeaf() {
        return this.onlySelLeaf;
    }

    public boolean isShowView() {
        return this.showView;
    }

    public void setShowView(boolean showView) {
        this.showView = showView;
    }

    public String getShowScope() {
        return this.showScope;
    }

    public void setShowScope(String showScope) {
        this.showScope = showScope;
    }

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    @JsonIgnore
    protected List<String> toArrays(Map<Long, Integer> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return null;
        }
        ArrayList _selectIds = Lists.newArrayListWithExpectedSize((int)selectIds.size());
        for (Map.Entry<Long, Integer> entry : selectIds.entrySet()) {
            _selectIds.add(entry.getKey() + "@" + entry.getValue());
        }
        return _selectIds;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public DynamicObject getDimension() {
        return this.dimension;
    }

    private void setDimension(@NotNull DynamicObject dimension) {
        this.dimension = dimension;
    }

    public void setRootMember(DynamicObject rootMember) {
        this.rootMember = rootMember;
    }

    public DynamicObject getRootMember() {
        return this.rootMember;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public void setDimensionNumber(String dimensionNumber) {
        this.dimensionNumber = dimensionNumber;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getEntityNumber() {
        if (this.isView()) {
            return this.getViewMemberFormId();
        }
        return this.baseEntityNumber();
    }

    public String baseEntityNumber() {
        return this.entityNumber;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setStepLoad(boolean stepLoad) {
        this.stepLoad = stepLoad;
    }

    public boolean isStepLoad() {
        return this.stepLoad && this.getFunctionType() == 1 && !this.isVerifyPermission();
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderBy() {
        if (StringUtils.isEmpty((CharSequence)this.orderBy)) {
            this.orderBy = DEFAULT_ORDER;
        }
        return this.orderBy;
    }

    public void setSelectIds(List<String> selectIds) {
        this.selectIds = selectIds;
    }

    public List<String> getSelectIds() {
        return this.selectIds;
    }

    @JsonIgnore
    public Map<Long, Integer> getSelectedData() {
        return this.toMap(this.getSelectIds());
    }

    @JsonIgnore
    public void setSelectIds(Map<Long, Integer> selectIds) {
        Map<Long, Integer> _selectIds = this.filterSelectedData(selectIds);
        this.selectIds = this.toArrays(_selectIds);
    }

    protected Map<Long, Integer> filterSelectedData(Map<Long, Integer> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (!this.isVerifyPermission()) {
            return selectIds;
        }
        Set<Long> _permissionIds = this.$loadPermission();
        if (_permissionIds == null) {
            return selectIds;
        }
        LinkedHashMap _selectIds = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
        for (Map.Entry<Long, Integer> entry : selectIds.entrySet()) {
            if (this.isMember(entry.getKey())) {
                if (!_permissionIds.contains(entry.getKey())) continue;
                _selectIds.put(entry.getKey(), entry.getValue());
                continue;
            }
            _selectIds.put(entry.getKey(), entry.getValue());
        }
        return selectIds;
    }

    protected abstract boolean isMember(Long var1);

    @JsonIgnore
    public void setSelectIds(Set<Long> selectIds) {
        if (selectIds == null) {
            this.selectIds = null;
        } else {
            LinkedHashMap _selectIds = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
            for (Long selectId : selectIds) {
                _selectIds.put(selectId, 10);
            }
            this.setSelectIds(_selectIds);
        }
    }

    @JsonIgnore
    public void setSelectId(Long selectId) {
        if (IDUtils.isNull(selectId)) {
            return;
        }
        this.setSelectIds(Collections.singleton(selectId));
    }

    @JsonIgnore
    private Map<Long, Integer> toMap(List<String> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return null;
        }
        LinkedHashMap selectIdMap = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
        for (String entry : selectIds) {
            String[] tmpStr = entry.split("@");
            if (tmpStr.length != 2) continue;
            try {
                Long memberId = Long.valueOf(tmpStr[0]);
                Integer scope = Integer.valueOf(tmpStr[1]);
                selectIdMap.put(memberId, scope);
            }
            catch (Exception ex) {
                log.error("selectedIds-trans-error:", (Object)entry);
            }
        }
        return selectIdMap;
    }

    public void setCustomFilters(String customFilters) {
        this.customFilters = customFilters;
    }

    public String getCustomFilters() {
        return this.customFilters;
    }

    public QFilter customFilter() {
        if (this.customFilters != null) {
            return QFilter.fromSerializedString((String)this.customFilters);
        }
        return null;
    }

    public boolean isShowCustomProperty() {
        return this.showCustomProperty;
    }

    public void setShowCustomProperty(boolean showCustomProperty) {
        this.showCustomProperty = showCustomProperty;
    }

    public abstract boolean canShowCustomProperty();

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public void check() {
        if (IDUtils.isNull(this.getModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractMemberF7Parameter_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (IDUtils.isNull(this.getDimensionId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractMemberF7Parameter_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
    }

    public void loadData() {
        if (IDUtils.isNotNull(this.getDimensionId()) && (this.getDimension() == null || !this.getDimensionId().equals(this.getDimension().getLong("id")))) {
            this.setDimension(this.getDimension(this.getDimensionId()));
            this.entityNumber = this.getDimension().getString("membermodel");
            this.dimensionNumber = this.getDimension().getString("number");
            this.dimensionName = this.getDimension().getString("name");
            QFBuilder builder = new QFBuilder();
            builder.add("model", "=", this.getModelId());
            builder.add("dimension", "=", this.getDimensionId());
            builder.add("number", "=", this.getDimensionNumber());
            this.rootMember = BusinessDataServiceHelper.loadSingleFromCache((String)this.entityNumber, (String)"id", (QFilter[])builder.toArray());
            if (this.rootMember != null) {
                this.rootMemberId = this.rootMember.getLong("id");
            }
        }
    }

    public void setCusRange(List<String> cusRange) {
        this.cusRange = cusRange;
    }

    public List<String> getCusRange() {
        return this.cusRange;
    }

    @JsonIgnore
    public abstract List<ComboItem> getRangeItems();

    public void setLockRangeSelect(boolean lockRangeSelect) {
        this.lockRangeSelect = lockRangeSelect;
    }

    public boolean isLockRangeSelect() {
        return this.lockRangeSelect;
    }

    public void setShowLevel(boolean showLevel) {
        this.showLevel = showLevel;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public void setShowExclude(boolean showExclude) {
        this.showExclude = showExclude;
    }

    public boolean isShowExclude() {
        return this.showExclude;
    }

    public void setExcludeMemberIds(Set<Long> excludeMemberIds) {
        this.excludeMemberIds = excludeMemberIds;
    }

    public Set<Long> getExcludeMemberIds() {
        return this.excludeMemberIds;
    }

    public void addExcludeMemberId(Long memberId) {
        if (IDUtils.isNull(memberId)) {
            return;
        }
        if (this.excludeMemberIds == null) {
            this.excludeMemberIds = new HashSet<Long>();
        }
        this.excludeMemberIds.add(memberId);
    }

    public void setShowChildren(boolean showChildren) {
        this.showChildren = showChildren;
    }

    public boolean isShowChildren() {
        return this.showChildren;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public boolean isIncludeChildren() {
        if (!this.isShowChildren()) {
            return false;
        }
        return this.includeChildren;
    }

    public void setRootMemberId(Long rootMemberId) {
        this.rootMemberId = rootMemberId;
    }

    public Long getRootMemberId() {
        return this.rootMemberId;
    }

    public void setShowCustomPropertyColumn(boolean showCustomPropertyColumn) {
        this.showCustomPropertyColumn = showCustomPropertyColumn;
    }

    public boolean isShowCustomPropertyColumn() {
        return this.showCustomPropertyColumn;
    }

    public abstract String getCustomPropertyValueForm();

    public abstract String getCustomPropertyForm();

    public void setViewId(Long viewId) {
        this.viewId = viewId;
        this.isView = null;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setViewNumber(String viewNumber) {
        this.viewNumber = viewNumber;
        if (IDUtils.isNull(this.viewId)) {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get(this.getModelId());
            Object view = modelCache.getView(this.getDimensionNumber(), viewNumber);
            this.setViewId(((BaseBean)view).getId());
        }
    }

    public String getViewNumber() {
        return this.viewNumber;
    }

    public void setEnableView(boolean enableView) {
        this.enableView = enableView;
    }

    public boolean isEnableView() {
        return this.enableView;
    }

    public void setDefRangeValue(String defRangeValue) {
        this.defRangeValue = defRangeValue;
    }

    public void setDefRangeValue(int defRangeValue) {
        this.defRangeValue = String.valueOf(defRangeValue);
    }

    public String getDefRangeValue() {
        return this.defRangeValue;
    }

    public void setReturnClassName(String returnClassName) {
        this.returnClassName = returnClassName;
    }

    public String getReturnClassName() {
        return this.returnClassName;
    }

    public void setReturnAllData(boolean returnAllData) {
        this.returnAllData = returnAllData;
    }

    public boolean isReturnAllData() {
        return this.returnAllData;
    }

    @JsonIgnore
    public ListSelectedRowCollection selectedListRows() {
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        Map<Long, Integer> _selectIds = this.getSelectedData();
        if (_selectIds != null && !_selectIds.isEmpty()) {
            for (Map.Entry<Long, Integer> entry : _selectIds.entrySet()) {
                ListSelectedRow row = new ListSelectedRow((Object)entry.getKey());
                if (entry.getValue() != null) {
                    HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
                    dataMap.put("scope", entry.getValue());
                    row.setDataMap(dataMap);
                }
                rows.add((Object)row);
            }
        }
        return rows;
    }

    protected AbstractMemberF7Parameter() {
    }

    protected AbstractMemberF7Parameter(@NotNull Long modelId, @NotNull Long dimensionId) {
        this.modelId = modelId;
        this.initBaseParam(modelId, this.getDimension(dimensionId));
    }

    protected AbstractMemberF7Parameter(@NotNull Long modelId, @NotNull String dimensionNumber) {
        this.modelId = modelId;
        this.initBaseParam(modelId, this.getDimension(modelId, dimensionNumber));
    }

    protected AbstractMemberF7Parameter(@NotNull Long modelId, @NotNull DynamicObject dimension) {
        this.modelId = modelId;
        this.initBaseParam(modelId, dimension);
    }

    protected AbstractMemberF7Parameter(@NotNull Long modelId, @NotNull DynamicObject dimension, @NotNull String returnClassName) {
        this.modelId = modelId;
        this.initBaseParam(modelId, dimension);
        this.setReturnClassName(returnClassName);
    }

    public void initF8() {
        this.setFunctionType(1);
        this.setShowLeaf(true);
        this.setCutTree(false);
    }

    protected abstract DynamicObject getDimension(@NotNull Long var1, @NotNull String var2);

    protected abstract DynamicObject getDimension(@NotNull Long var1);

    protected void initBaseParam(@NotNull Long modelId, DynamicObject dimension) {
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractMemberF7Parameter_3", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        this.setModelId(modelId);
        this.initDimensionInfo(dimension);
    }

    public void initDimensionInfo(long dimensionId) {
        DynamicObject dimension = this.getDimension(dimensionId);
        this.setDimension(dimension);
        this.initDimensionInfo(dimension);
    }

    public void initDimensionInfo(DynamicObject dimension) {
        this.setDimensionId(dimension.getLong("id"));
        this.setDimensionNumber(dimension.getString("number"));
        this.setDimensionName(dimension.getString("name"));
        this.setEntityNumber(dimension.getString("membermodel"));
    }

    public abstract boolean isView();

    public abstract String getF7FormId();

    public abstract String getF8FormId();

    public String getF8FloatFormId() {
        return "";
    }

    public String getViewMemberFormId() {
        return "";
    }

    public void setViewSign(String viewSign) {
        this.viewSign = viewSign;
    }

    public String getViewSign() {
        return this.viewSign;
    }

    public List<Long> getViewFilterList() {
        return this.viewFilterList;
    }

    public void setViewFilterList(List<Long> viewFilterList) {
        this.viewFilterList = viewFilterList;
    }

    public void setFloat(boolean aFloat) {
        this.isFloat = aFloat;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public void setFloatAddNew(boolean floatAddNew) {
        this.isFloatAddNew = floatAddNew;
    }

    public boolean isFloatAddNew() {
        return this.isFloatAddNew;
    }

    public void setFloatParentId(Long floatParentId) {
        this.floatParentId = floatParentId;
    }

    public Long getFloatParentId() {
        return this.floatParentId;
    }

    public boolean isClearSelectWhenChangeView() {
        return this.clearSelectWhenChangeView;
    }

    public void setClearSelectWhenChangeView(boolean clearSelectWhenChangeView) {
        this.clearSelectWhenChangeView = clearSelectWhenChangeView;
    }

    public boolean isNewReturn() {
        return false;
    }
}

