/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.f7;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.constant.F7Constant;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.util.GZIPUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class F7TreeUtils {
    private static final Log log = LogFactory.getLog(F7TreeUtils.class);

    public static void cacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root) {
        if (root != null) {
            log.info("begin-cache-node");
            String _cacheTreeNode = SerializationUtils.toJsonString((Object)root);
            log.info("before-zip-size=" + _cacheTreeNode.length());
            try {
                _cacheTreeNode = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress(_cacheTreeNode));
            }
            catch (Exception ex) {
                log.error("gzip-compress-error:", (Throwable)ex);
            }
            log.info("end-zip");
            pageCache.put(cacheKey, _cacheTreeNode);
            log.info("end-cache-node. cacheSize=" + _cacheTreeNode.length());
        } else {
            pageCache.remove(cacheKey);
            log.info("end-remove-cache-node.");
        }
    }

    public static TreeNode getCacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
        log.info("begin-parse-node");
        TreeNode node = F7TreeUtils.getCacheTreeNodeData(pageCache.get(cacheKey));
        log.info("end-parse-node");
        return node;
    }

    public static TreeNode getCacheTreeNodeData(String cacheTreeData) {
        if (StringUtils.isEmpty((CharSequence)cacheTreeData)) {
            return null;
        }
        TreeNode node = null;
        String _cacheTreeNode = cacheTreeData;
        try {
            _cacheTreeNode = GZIPUtils.uncompressToString((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheTreeNode));
        }
        catch (Exception ex) {
            log.error("gzip-uncompress-error:", (Throwable)ex);
        }
        log.info("end-gzip-node");
        try {
            node = (TreeNode)SerializationUtils.fromJsonString((String)_cacheTreeNode, TreeNode.class);
        }
        catch (Exception ex) {
            log.error("json-parse-error:", (Throwable)ex);
        }
        return node;
    }

    public static String nodeShowType(@NotNull Map<String, Object> nodeData, String showType) {
        String[] showTypes = F7Constant.DEFAULT_SHOW_FIELDS;
        if (ShowTypeEnum.NUMBER.getValue().equals(showType)) {
            showTypes = F7Constant.SHOW_NUMBER;
        } else if (ShowTypeEnum.NAME.getValue().equals(showType)) {
            showTypes = F7Constant.SHOW_NAME;
        } else if (ShowTypeEnum.SHOWNUMBER.getValue().equals(showType)) {
            showTypes = F7Constant.SHOW_SHOWNUMBER;
        } else if (ShowTypeEnum.SHOWNUMBERNAME.getValue().equals(showType)) {
            showTypes = new String[]{"shownumber", "name"};
        }
        Object[] shows = new String[showTypes.length];
        for (int i = 0; i < showTypes.length; ++i) {
            shows[i] = (String)nodeData.get(showTypes[i]);
        }
        return StringUtils.join((Object[])shows, (String)"\u3000");
    }
}

