/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.f7.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.F7TreeUtils;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.util.CommonServiceHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BaseCusPropertyTreeBuilder
extends BaseTreeBuilder {
    private final AbstractMemberF7Parameter f7Parameter;
    private boolean loadSelected = false;
    private Map<Long, Integer> selectIds = null;

    protected AbstractMemberF7Parameter getF7Parameter() {
        return this.f7Parameter;
    }

    public static BaseCusPropertyTreeBuilder get(@NotNull AbstractMemberF7Parameter f7Parameter) {
        return new BaseCusPropertyTreeBuilder(f7Parameter);
    }

    protected BaseCusPropertyTreeBuilder(@NotNull AbstractMemberF7Parameter f7Parameter) {
        this.f7Parameter = f7Parameter;
    }

    @Override
    protected String getCacheTreeKey() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTreeKey())) {
            return "CACHE_TREE_PROPERTY_NODE_DATA." + this.getTreeKey();
        }
        return "CACHE_TREE_PROPERTY_NODE_DATA";
    }

    @Override
    public boolean isShowRoot() {
        return false;
    }

    @Override
    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.builderPropertyTree(pageCache);
    }

    protected TreeNode builderPropertyTree(@NotNull IPageCache pageCache) {
        TreeNode root = this.createNode("", "root", "root");
        List<Map<String, Object>> properties = this.queryCustomProperty();
        if (properties != null && !properties.isEmpty()) {
            for (Map<String, Object> property : properties) {
                property.put("parent.id", root.getId());
            }
        }
        List<TreeNode> memNodes = this.transTreeNodes(properties, true);
        root.addChildren(memNodes);
        return root;
    }

    protected QFBuilder getQueryCustomPropertyQFBuilder() {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", this.getF7Parameter().getModelId());
        builder.add("dimension", "=", this.getF7Parameter().getDimensionId());
        return builder;
    }

    protected List<Map<String, Object>> queryCustomProperty() {
        List<Map<String, Object>> propertyData;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryCusProperty", (String)this.getF7Parameter().getCustomPropertyForm(), (String)"id,number,name", (QFilter[])this.getQueryCustomPropertyQFBuilder().toArray(), (String)"dseq");){
            propertyData = CommonServiceHelper.transDataSet(ds);
        }
        return propertyData;
    }

    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> nodeDatas, boolean hasProperty) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(nodeDatas.size());
        for (Map<String, Object> nodeData : nodeDatas) {
            TreeNode node = this.transNode(nodeData, hasProperty);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    protected boolean isCheckedProperty() {
        return false;
    }

    protected TreeNode transNode(@NotNull Map<String, Object> nodeData, boolean hasProperty) {
        TreeNode node = new TreeNode();
        node.setId(IDUtils.toString(nodeData.get("id")));
        node.setParentid(IDUtils.toString(nodeData.get("parent.id")));
        String showType = this.getF7Parameter().getShowType();
        if (ShowTypeEnum.SHOWNUMBERNAME.getValue().equals(showType)) {
            showType = ShowTypeEnum.NUMNAME.getValue();
        } else if (ShowTypeEnum.SHOWNUMBER.getValue().equals(showType)) {
            showType = ShowTypeEnum.NUMBER.getValue();
        }
        node.setText(F7TreeUtils.nodeShowType(nodeData, showType));
        Long propertyId = IDUtils.toLong(nodeData.get("id"));
        if (this.checkHasSelect(propertyId)) {
            this.getSelected().add(node);
        }
        if (hasProperty) {
            node.addChildren(new ArrayList());
            node.setDisabled(!this.isCheckedProperty());
        }
        return node;
    }

    protected boolean checkHasSelect(@NotNull Long pk) {
        if (this.getF7Parameter().getFunctionType() == 1) {
            if (!this.loadSelected) {
                this.selectIds = this.getF7Parameter().getSelectedData();
                this.loadSelected = true;
            }
            return this.selectIds != null && this.selectIds.containsKey(pk) || this.getShowSelectedIds() != null && this.getShowSelectedIds().contains(pk);
        }
        return false;
    }

    @Override
    protected void afterBuilderTree(@NotNull TreeView treeView) {
        super.afterBuilderTree(treeView);
        if (this.getF7Parameter().getFunctionType() == 1 && CollectionUtils.isNotEmpty(this.getSelected())) {
            treeView.checkNodesWithoutChild(this.getSelectedClone());
        }
    }

    @Override
    protected List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root) {
        List<Map<String, Object>> treeDatas;
        if (parent == null) {
            return null;
        }
        String propertyId = parent.getId();
        QFBuilder builder = new QFBuilder();
        if (this.getF7Parameter().getSelectRangeIds() != null) {
            HashSet<Long> tmpIds = new HashSet<Long>(this.getF7Parameter().getSelectRangeIds());
            if (tmpIds.isEmpty()) {
                tmpIds.add(0L);
            }
            builder.add("id", "in", tmpIds);
        }
        log.info("begin-query-stepData.");
        QFilter filter = new QFilter(this.getParentPkField(), "=", (Object)IDUtils.toLong(propertyId));
        if (builder != null && !builder.getFilters().isEmpty()) {
            filter.and(builder.toFilter());
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPropertyValue", (String)this.getF7Parameter().getCustomPropertyValueForm(), (String)this.getCustomPropertyValueFields(), (QFilter[])filter.toArray(), (String)"number");){
            treeDatas = CommonServiceHelper.transDataSet(ds);
        }
        if (!treeDatas.isEmpty()) {
            for (Map<String, Object> treeData : treeDatas) {
                treeData.put("parent.id", propertyId);
            }
        }
        log.info("end-query-stepData.");
        return this.transTreeNodes(treeDatas, false);
    }

    @NotNull
    protected String getCustomPropertyValueFields() {
        return "id,number,name";
    }

    @NotNull
    protected String getParentPkField() {
        return "property";
    }

    @Override
    protected List<TreeNode> getCheckedChildrenNode(List<TreeNode> children) {
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        ArrayList checkedNodes = Lists.newArrayListWithExpectedSize((int)children.size());
        for (TreeNode child : children) {
            if (!this.checkHasSelect(IDUtils.toLong(child.getId()))) continue;
            checkedNodes.add(child);
        }
        return checkedNodes;
    }

    @Override
    protected boolean isVerifyPermission() {
        return false;
    }

    @Override
    protected Set<Long> loadPermission() {
        return null;
    }
}

