/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.f7.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.member.f7.F7TreeUtils;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.util.CommonServiceHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BaseDynamicTreeBuilder
extends BaseTreeBuilder {
    protected static final String DATA_TYPE = "dt";
    private final AbstractMemberF7Parameter f7Parameter;
    private String initFields = null;
    private int stopLevel = 3;
    private Set<Long> cusFilterIds = null;
    private boolean loadSelected = false;
    private Map<Long, Integer> selectIds = null;

    public static BaseDynamicTreeBuilder get(@NotNull AbstractMemberF7Parameter f7Parameter) {
        return new BaseDynamicTreeBuilder(f7Parameter);
    }

    protected BaseDynamicTreeBuilder(@NotNull AbstractMemberF7Parameter f7Parameter) {
        this.f7Parameter = f7Parameter;
    }

    protected AbstractMemberF7Parameter getF7Parameter() {
        return this.f7Parameter;
    }

    @Override
    protected TreeNode getFocusNode(TreeNode root) {
        TreeNode _root = super.getFocusNode(root);
        AbstractMemberF7Parameter f7Parameter = this.getF7Parameter();
        Map<Long, Integer> selectedData = f7Parameter.getSelectedData();
        if (selectedData != null && !selectedData.isEmpty()) {
            Long firstId = selectedData.keySet().iterator().next();
            TreeNode _node = _root.getTreeNode(firstId.toString());
            if (_node == null) {
                _node = root;
            }
            if (_node != null) {
                _root = _node;
            }
        }
        return _root;
    }

    @Override
    protected void nodeClick(TreeView treeView, TreeNode node) {
        if (this.getF7Parameter().getFunctionType() == 0) {
            super.nodeClick(treeView, node);
        }
    }

    @Override
    protected String getCacheTreeKey() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTreeKey())) {
            return "CACHE_F7_TREE_MEMBER_NODE_DATA." + this.getTreeKey();
        }
        return "CACHE_F7_TREE_MEMBER_NODE_DATA";
    }

    protected QFilter[] getInitRootFilters() {
        AbstractMemberF7Parameter f7Param = this.getF7Parameter();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", f7Param.getModelId());
        builder.add("dimension", "=", f7Param.getDimensionId());
        builder.add("number", "=", f7Param.getDimensionNumber());
        builder.add("level", "<=", 1);
        if (f7Param.getViewMemberFormId().equals(f7Param.getEntityNumber())) {
            builder.add("view", "=", f7Param.getViewId());
        }
        return builder.toArray();
    }

    protected String getInitFields() {
        if (this.initFields == null) {
            this.initFields = this.getF7Parameter().fields();
            String tmpStr = this.getInitOrder();
            if (StringUtils.isNotEmpty((CharSequence)tmpStr)) {
                String[] tmpStrs;
                for (String _field : tmpStrs = tmpStr.split(",")) {
                    if (this.initFields.indexOf(_field.trim()) != -1) continue;
                    this.initFields = this.initFields + "," + _field.trim();
                }
            }
        }
        return this.initFields;
    }

    protected QFilter[] getInitFilters() {
        ArrayList<QFilter> _filters = new ArrayList<QFilter>(this.getF7Parameter().filters(true).getFilters());
        if (this.getF7Parameter().isStepLoad()) {
            this.replaceFilter(_filters, new QFilter("level", "<=", (Object)this.getStopLevel()));
        }
        if (!this.getF7Parameter().isShowLeaf()) {
            this.replaceFilter(_filters, new QFilter("isleaf", "=", (Object)"0"));
        }
        return _filters.toArray(new QFilter[0]);
    }

    protected String getInitOrder() {
        return "level, dseq, number";
    }

    protected QFilter[] getInitParentFilters() {
        AbstractMemberF7Parameter f7Parameter = this.getF7Parameter();
        f7Parameter.setFillParent(true);
        QFBuilder builder = f7Parameter.listFilter();
        builder.add("isleaf", "=", "0");
        return builder.toArrays();
    }

    protected QFilter[] getStepFilters(TreeNode parent) {
        ArrayList<QFilter> _filters = new ArrayList<QFilter>(this.getF7Parameter().filters().getFilters());
        this.replaceFilter(_filters, new QFilter("parent", "=", (Object)IDUtils.toLong(parent.getId())));
        if (this.getF7Parameter().getFunctionType() == 0) {
            this.replaceFilter(_filters, new QFilter("isleaf", "=", (Object)"0"));
        }
        return _filters.toArray(new QFilter[0]);
    }

    protected void replaceFilter(List<QFilter> filters, QFilter filter) {
        if (filters == null || filter == null) {
            return;
        }
        QFilter _exitFilter = null;
        for (QFilter _filter : filters) {
            if (!_filter.getProperty().equals(filter.getProperty())) continue;
            _exitFilter = _filter;
            break;
        }
        if (_exitFilter != null) {
            _exitFilter.__setCP(filter.getCP());
            _exitFilter.__setValue(filter.getValue());
        } else {
            filters.add(filter);
        }
    }

    public void setStopLevel(int stopLevel) {
        this.stopLevel = stopLevel;
    }

    public int getStopLevel() {
        return this.stopLevel;
    }

    @Override
    protected void afterBuilderTree(@NotNull TreeView treeView) {
        super.afterBuilderTree(treeView);
        if (this.getF7Parameter().getFunctionType() == 1 && CollectionUtils.isNotEmpty(this.getSelected())) {
            treeView.checkNodesWithoutChild(this.getSelectedClone());
        }
    }

    @Override
    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.buildRootTree(pageCache);
    }

    protected TreeNode buildRootTree(@NotNull IPageCache pageCache) {
        TreeNode root;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        List<Map<String, Object>> memberTreeData = this.queryInitData();
        Set<String> parentData = this.queryInitParentData(memberTreeData);
        List<TreeNode> memNodes = this.transTreeNodes(memberTreeData, parentData, pageCache);
        nodes.addAll(memNodes);
        this.afterTransTreeNodes(nodes);
        if (nodes.size() == 1) {
            TreeNode _root = (TreeNode)nodes.get(0);
            _root.setParentid("");
            return _root;
        }
        if (nodes.isEmpty()) {
            root = this.createRoot();
        } else {
            this.setShowRoot(false);
            root = super.getRoot(pageCache);
            for (TreeNode _child : nodes) {
                _child.setParentid(root.getId());
                root.addChild(_child);
            }
        }
        return root;
    }

    @Override
    protected void cacheNode(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root) {
        super.cacheNode(pageCache, cacheKey, root);
    }

    protected TreeNode createRoot() {
        TreeNode root;
        DynamicObject rootMember = BusinessDataServiceHelper.loadSingleFromCache((String)this.getEntityNumber(this.getF7Parameter()), (String)"id,number,name", (QFilter[])this.getInitRootFilters());
        if (rootMember != null) {
            root = new TreeNode("", rootMember.getString("id"), rootMember.getString("name"));
            if (!this.getF7Parameter().isCanSelectRoot()) {
                root.setDisabled(true);
            } else if (this.isDisabled(rootMember.getLong("id"))) {
                root.setDisabled(true);
            }
        } else {
            root = new TreeNode("", "#", ResManager.loadKDString((String)"\u5168\u90e8", (String)"BaseDynamicTreeBuilder_1", (String)"epm-epbs-common", (Object[])new Object[0]));
            root.setDisabled(true);
        }
        return root;
    }

    protected boolean isDisabled(Long memberId) {
        boolean isDisabled = false;
        if (this.getF7Parameter().getSelectRangeIds() != null) {
            if (!this.getF7Parameter().getSelectRangeIds().contains(memberId)) {
                isDisabled = true;
            }
        } else if (this.getF7Parameter().getCustomCommFilters() != null) {
            block22: {
                if (this.cusFilterIds == null) {
                    this.cusFilterIds = new HashSet<Long>();
                    try {
                        QFilter filter = this.getF7Parameter().customCommFilter();
                        if (filter == null) break block22;
                        filter.and("model", "=", (Object)this.getF7Parameter().getModelId()).and("dimension", "=", (Object)this.getF7Parameter().getDimensionId());
                        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberRangeIds", (String)this.getEntityNumber(this.getF7Parameter()), (String)this.getF7Parameter().pkField(), (QFilter[])filter.toArray(), null);){
                            if (ds != null) {
                                for (Row row : ds) {
                                    this.cusFilterIds.add(row.getLong(this.getF7Parameter().pkField()));
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        log.error("load-cus-filter-error", ex);
                    }
                }
            }
            if (!this.cusFilterIds.contains(memberId)) {
                isDisabled = true;
            }
        }
        return isDisabled;
    }

    protected List<TreeNode> transTreeNodes(@NotNull List<Map<String, Object>> memberTreeData, Set<String> parentData, IPageCache pageCache) {
        LinkedList linkedList;
        block14: {
            TreeNode root = null;
            Map<Object, Object> _tmpNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)memberTreeData.size());
            LinkedHashMap noPermissionNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)memberTreeData.size());
            for (Map<String, Object> map : memberTreeData) {
                TreeNode node = this.transNode(map);
                boolean isRoot = this.isRootNode(node);
                if (parentData != null && !parentData.contains(node.getId()) && !isRoot) continue;
                Long l = (Long)map.get(this.f7Parameter.pkField());
                if (this.hasVerifyPermission(map) && !this.verifyPermission(l) && !isRoot) {
                    noPermissionNodeMap.put(node.getId(), node);
                    continue;
                }
                _tmpNodeMap.put(node.getId(), node);
            }
            _tmpNodeMap = this.transNodeId((Map<String, TreeNode>)_tmpNodeMap);
            ArrayList<String> allParentNodes = new ArrayList<String>(10);
            if (!noPermissionNodeMap.isEmpty()) {
                for (TreeNode treeNode : _tmpNodeMap.values()) {
                    TreeNode parentNode = this.getParentNode(treeNode, _tmpNodeMap);
                    if (parentNode != null) continue;
                    this.fillAllParentNodes(allParentNodes, treeNode, _tmpNodeMap, noPermissionNodeMap);
                }
                for (String string : allParentNodes) {
                    TreeNode treeNode = (TreeNode)noPermissionNodeMap.get(string);
                    if (treeNode == null) continue;
                    _tmpNodeMap.put(string, treeNode);
                }
            }
            if (pageCache != null) {
                pageCache.put("CACHE_TREE_ALL", String.valueOf(_tmpNodeMap.size()));
            }
            linkedList = Lists.newLinkedList();
            LinkedList linkedList2 = Lists.newLinkedList();
            for (TreeNode treeNode : _tmpNodeMap.values()) {
                if (this.isRootNode(treeNode)) {
                    if (root == null) {
                        root = treeNode;
                    }
                    linkedList.add(treeNode);
                    continue;
                }
                TreeNode parent = this.getParentNode(treeNode, _tmpNodeMap);
                if (parent != null) {
                    parent.addChild(treeNode);
                    continue;
                }
                linkedList2.add(treeNode);
            }
            if (linkedList2.isEmpty()) break block14;
            if (root != null) {
                for (TreeNode treeNode : linkedList2) {
                    treeNode.setParentid(root.getId());
                    root.addChild(treeNode);
                }
            } else {
                for (TreeNode treeNode : linkedList2) {
                    treeNode.setParentid("");
                    linkedList.add(treeNode);
                }
            }
        }
        return linkedList;
    }

    protected void fillAllParentNodes(List<String> allParentNodes, TreeNode node, Map<String, TreeNode> nodeMap, Map<String, TreeNode> noPermissionNodeMap) {
        TreeNode parentNode = noPermissionNodeMap.get(node.getParentid());
        if (parentNode == null) {
            parentNode = nodeMap.get(node.getParentid());
        } else {
            allParentNodes.add(parentNode.getId());
        }
        if (parentNode != null) {
            this.fillAllParentNodes(allParentNodes, parentNode, nodeMap, noPermissionNodeMap);
        }
    }

    protected TreeNode getParentNode(TreeNode node, Map<String, TreeNode> nodeMap) {
        if (node == null || nodeMap == null) {
            return null;
        }
        return nodeMap.get(node.getParentid());
    }

    protected void afterTransTreeNodes(List<TreeNode> nodes) {
        this.checkNode(nodes);
    }

    protected boolean isRootNode(TreeNode node) {
        return StringUtils.isEmpty((CharSequence)node.getParentid()) || "0".equals(node.getParentid());
    }

    protected Map<String, TreeNode> transNodeId(Map<String, TreeNode> nodeMap) {
        if (!this.getF7Parameter().isView()) {
            return nodeMap;
        }
        LinkedHashMap<String, TreeNode> _tmpNodeMap = new LinkedHashMap<String, TreeNode>(nodeMap.size());
        for (TreeNode _node : nodeMap.values()) {
            Map _data = (Map)_node.getData();
            Long _memberId = (Long)_data.get("memberid");
            _node.setId(_memberId.toString());
            TreeNode _parent = nodeMap.get(_node.getParentid());
            if (_parent != null) {
                Long _pMemberId = (Long)this.getTreeNodeProperty(_parent, "memberid");
                _node.setParentid(_pMemberId.toString());
            }
            _tmpNodeMap.put(_node.getId(), _node);
        }
        return _tmpNodeMap;
    }

    protected void checkNode(List<TreeNode> nodes) {
        if (this.getF7Parameter().isStepLoad()) {
            return;
        }
        nodes.forEach(this::$checkNode);
    }

    private void $checkNode(TreeNode node) {
        List _children;
        Map nodeData;
        if (node == null) {
            return;
        }
        if (node.getData() instanceof Map && this.hasClearNodeData(nodeData = (Map)node.getData())) {
            node.setData(null);
        }
        if ((_children = node.getChildren()) != null) {
            if (_children.isEmpty()) {
                node.setChildren(null);
            } else {
                for (TreeNode _child : _children) {
                    this.$checkNode(_child);
                }
            }
        }
    }

    protected boolean hasClearNodeData(Map<String, Object> nodeData) {
        return nodeData == null || !nodeData.containsKey(DATA_TYPE);
    }

    protected Object getTreeNodeProperty(TreeNode node, String propertyName) {
        if (node == null || propertyName == null) {
            return null;
        }
        if (node.getData() instanceof Map) {
            return ((Map)node.getData()).get(propertyName);
        }
        return null;
    }

    protected List<TreeNode> transTreeNodes(@NotNull TreeNode parent, TreeNode root, @NotNull List<Map<String, Object>> treeData) {
        LinkedList children = Lists.newLinkedList();
        for (Map<String, Object> _data : treeData) {
            Long nodeId = (Long)_data.get(this.getF7Parameter().pkField());
            if (this.hasVerifyPermission(_data) && !this.verifyPermission(nodeId)) continue;
            TreeNode node = this.transNode(_data);
            node.setId(nodeId.toString());
            node.setParentid(parent.getId());
            children.add(node);
        }
        return children;
    }

    protected boolean isRootMember(AbstractMemberF7Parameter _f7Param, Map<String, Object> data) {
        return _f7Param.getDimensionNumber().equals(data.get("number"));
    }

    protected List<Map<String, Object>> queryInitData() {
        Map<String, Object> data;
        LinkedList memberTreeDate = Lists.newLinkedList();
        log.info("begin-query-initData.");
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        String entityNumber = this.getEntityNumber(_f7Param);
        Map<String, Object> root = null;
        List<Map<String, Object>> filterData = this.getFilterData(entityNumber);
        if (!filterData.isEmpty() && this.isRootMember(_f7Param, data = filterData.get(0))) {
            root = data;
        }
        if (root == null) {
            List<Map<String, Object>> rootData = this.queryRootData(entityNumber);
            memberTreeDate.addAll(rootData);
        }
        memberTreeDate.addAll(filterData);
        log.info("end-query-initData.");
        return memberTreeDate;
    }

    @NotNull
    protected List<Map<String, Object>> queryRootData(String entityNumber) {
        List<Map<String, Object>> rootData;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeRootData", (String)entityNumber, (String)this.getInitFields(), (QFilter[])this.getInitRootFilters(), (String)this.getInitOrder(), (int)1);){
            rootData = CommonServiceHelper.transDataSet(ds);
        }
        return rootData;
    }

    protected List<Map<String, Object>> getFilterData(String entityNumber) {
        List<Map<String, Object>> filterData;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)this.getInitFields(), (QFilter[])this.getInitFilters(), (String)this.getInitOrder());){
            filterData = CommonServiceHelper.transDataSet(ds);
        }
        return filterData;
    }

    protected String getEntityNumber(AbstractMemberF7Parameter _f7Param) {
        return _f7Param.getEntityNumber();
    }

    /*
     * Unable to fully structure code
     */
    protected Set<String> queryInitParentData(List<Map<String, Object>> memberTreeData) {
        _f7Param = this.getF7Parameter();
        if (!_f7Param.isCutTree()) {
            return null;
        }
        parentData = Sets.newLinkedHashSetWithExpectedSize((int)1024);
        entityNumber = this.getEntityNumber(_f7Param);
        BaseDynamicTreeBuilder.log.info("begin-query-initParentData.");
        if (_f7Param.isShowLeaf()) {
            if (_f7Param.getSelectRangeIds() == null) {
                ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id", (QFilter[])this.getInitParentFilters(), null);
                var6_8 = null;
                try {
                    if (ds == null) ** GOTO lbl86
                    for (Row row : ds) {
                        parentData.add(row.getString("id"));
                    }
                }
                catch (Throwable var7_13) {
                    var6_8 = var7_13;
                    throw var7_13;
                }
                finally {
                    if (ds != null) {
                        if (var6_8 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable var7_12) {
                                var6_8.addSuppressed(var7_12);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            } else {
                ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id,parent,isleaf,longnumber", (QFilter[])this.getInitParentFilters(), null);
                var6_9 = null;
                try {
                    if (ds != null) {
                        for (Row row : ds) {
                            parentData.add(row.getString("id"));
                            parentData.add(row.getString("parent"));
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var6_9 = var7_16;
                    throw var7_16;
                }
                finally {
                    if (ds != null) {
                        if (var6_9 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable var7_15) {
                                var6_9.addSuppressed(var7_15);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                this.fillBackParentData(_f7Param, new ArrayList<String>(parentData), parentData, memberTreeData);
            }
        } else {
            ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)entityNumber, (String)"id,parent,isleaf,longnumber", (QFilter[])this.getInitParentFilters(), null).distinct();
            var6_10 = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        if (row.getBoolean("isleaf").booleanValue()) continue;
                        parentData.add(row.getString("id"));
                    }
                }
            }
            catch (Throwable var7_19) {
                var6_10 = var7_19;
                throw var7_19;
            }
            finally {
                if (ds != null) {
                    if (var6_10 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable var7_18) {
                            var6_10.addSuppressed(var7_18);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            this.fillBackParentData(_f7Param, new ArrayList<String>(parentData), parentData, memberTreeData);
        }
lbl86:
        // 4 sources

        BaseDynamicTreeBuilder.log.info("end-query-initParentData.");
        return parentData;
    }

    protected Set<String> getAllParentIdSetByLongNumber(AbstractMemberF7Parameter _f7Param, List<String> longNumberList) {
        return null;
    }

    protected void fillBackParentData(AbstractMemberF7Parameter f7Param, List<String> longNumberList, Set<String> parentData, List<Map<String, Object>> memberTreeData) {
        if (f7Param == null || longNumberList == null || longNumberList.isEmpty() || parentData == null || memberTreeData == null) {
            return;
        }
        Set<String> allParentIdSetByLongNumber = this.getAllParentIdSetByLongNumber(f7Param, longNumberList);
        if (allParentIdSetByLongNumber != null) {
            parentData.addAll(allParentIdSetByLongNumber);
        }
        log.info("queryInitParentData-size=" + parentData.size());
        if (!parentData.isEmpty() && memberTreeData != null && !memberTreeData.isEmpty()) {
            Set set;
            HashMap parentMap = Maps.newHashMapWithExpectedSize((int)memberTreeData.size());
            for (Map<String, Object> map : memberTreeData) {
                parentMap.put(IDUtils.toString(map.get("id")), IDUtils.toString(map.get("parent.id")));
            }
            LinkedHashSet allParentIds = Sets.newLinkedHashSet();
            for (String _parentId : parentData) {
                this.findAllParents(_parentId, parentMap, allParentIds);
            }
            allParentIds.remove("0");
            parentData.addAll(allParentIds);
            if (!CollectionUtils.containsAll(parentMap.keySet(), parentData) && !(set = parentData.stream().filter(_id -> !parentMap.containsKey(_id)).collect(Collectors.toSet())).isEmpty()) {
                List<Map<String, Object>> _parentMembers;
                QFilter filter = new QFilter("id", "in", IDUtils.toLongs(set));
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)f7Param.getEntityNumber(), (String)this.getInitFields(), (QFilter[])filter.toArray(), (String)this.getInitOrder());){
                    _parentMembers = CommonServiceHelper.transDataSet(ds);
                }
                memberTreeData.addAll(_parentMembers);
                String order = this.getInitOrder();
                if (StringUtils.isNotEmpty((CharSequence)order)) {
                    String[] orders = order.split(",");
                    Comparator comparator = (m1, m2) -> {
                        int re = 0;
                        for (String _order : orders) {
                            Object value1 = m1.get(_order.trim());
                            Object value2 = m2.get(_order.trim());
                            if (value1 instanceof Comparable && value2 instanceof Comparable) {
                                re = ((Comparable)value1).compareTo(value2);
                            }
                            if (re != 0) break;
                        }
                        return re;
                    };
                    memberTreeData.sort(comparator);
                }
            }
        }
    }

    private void findAllParents(String memberId, Map<String, String> parentMap, Set<String> parentData) {
        if (memberId == null) {
            return;
        }
        parentData.add(memberId);
        String parentId = parentMap.get(memberId);
        if (parentId != null) {
            parentData.add(parentId);
            this.findAllParents(parentId, parentMap, parentData);
        }
    }

    protected TreeNode transNode(@NotNull Map<String, Object> nodeData) {
        AbstractMemberF7Parameter f7Parameter;
        boolean _isLeaf;
        boolean isF8;
        TreeNode node = new TreeNode();
        Long memberId = (Long)nodeData.get("id");
        node.setId(IDUtils.toString(memberId));
        node.setParentid(IDUtils.toString(nodeData.get("parent.id")));
        node.setText(F7TreeUtils.nodeShowType(nodeData, this.getF7Parameter().getShowType()));
        Object isLeaf = nodeData.get("isleaf");
        boolean bl = isF8 = this.getF7Parameter().getFunctionType() == 1;
        if (isLeaf instanceof Boolean && !(_isLeaf = ((Boolean)isLeaf).booleanValue())) {
            node.addChildren(new ArrayList());
            if (isF8 && this.getF7Parameter().isOnlySelLeaf()) {
                node.setDisabled(true);
            }
            if (isF8 && (StringUtils.isEmpty((CharSequence)node.getParentid()) || "0".equals(node.getParentid())) && !this.getF7Parameter().isCanSelectRoot()) {
                node.setDisabled(true);
            }
        }
        if (this.checkHasSelect(memberId)) {
            this.getSelected().add(node);
        }
        if ((f7Parameter = this.getF7Parameter()).isVerifyPermission()) {
            Set<Long> permissionIds = f7Parameter.getPermissionIds();
            if (isF8 && permissionIds != null && !permissionIds.contains(memberId)) {
                node.setDisabled(true);
            }
        }
        return node;
    }

    protected boolean checkHasSelect(@NotNull Long pk) {
        if (this.getF7Parameter().getFunctionType() == 1) {
            if (!this.loadSelected) {
                this.selectIds = this.getF7Parameter().getSelectedData();
                this.loadSelected = true;
            }
            return this.selectIds != null && this.selectIds.containsKey(pk) || this.getShowSelectedIds() != null && this.getShowSelectedIds().contains(pk);
        }
        return false;
    }

    protected Long getNodeId(@NotNull Map<String, Object> nodeData) {
        return (Long)nodeData.get("id");
    }

    protected Long getNodeMemberId(@NotNull Map<String, Object> nodeData) {
        return (Long)nodeData.get("memberid");
    }

    @Override
    protected List<TreeNode> getChildrenNode(TreeNode parent, TreeNode root) {
        List<Map<String, Object>> treeData;
        if (parent == null) {
            return null;
        }
        AbstractMemberF7Parameter _f7Param = this.getF7Parameter();
        log.info("begin-query-stepData.");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)this.getEntityNumber(_f7Param), (String)_f7Param.fields(), (QFilter[])this.getStepFilters(parent), (String)_f7Param.getOrderBy());){
            treeData = CommonServiceHelper.transDataSet(ds);
        }
        log.info("end-query-stepData.");
        return this.transTreeNodes(parent, root, treeData);
    }

    @Override
    protected boolean isVerifyPermission() {
        return this.getF7Parameter().isVerifyPermission();
    }

    @Override
    protected Set<Long> loadPermission() {
        return this.getF7Parameter().$loadPermission();
    }
}

