/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.f7.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.member.f7.F7TreeUtils;
import kd.epm.epbs.common.util.TreeNodeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTreeBuilder {
    public static final Log log = LogFactory.getLog(BaseTreeBuilder.class);
    public static final String DEFAULT_CANT_CHECK_PERM = "cp";
    private boolean showRoot = true;
    private Set<Long> showSelectedIds = null;
    @JsonIgnore
    private List<TreeNode> selected = Lists.newLinkedList();
    private String treeKey = null;
    private boolean unLoadPermission = true;
    private Set<Long> permissions = null;

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    public boolean isShowRoot() {
        return this.showRoot;
    }

    public void setShowSelectedIds(Set<Long> showSelectedIds) {
        this.showSelectedIds = showSelectedIds;
    }

    public Set<Long> getShowSelectedIds() {
        return this.showSelectedIds;
    }

    @JsonIgnore
    protected List<TreeNode> getSelected() {
        return this.selected;
    }

    protected List<TreeNode> getSelectedClone() {
        return TreeNodeUtils.getBaseClone(this.getSelected());
    }

    public static void registerNodeListener(@NotNull TreeView treeView, @NotNull TreeNodeClickListener listener) {
        treeView.addTreeNodeClickListener(listener);
    }

    public static void registerNodeCheckListener(@NotNull TreeView treeView, @NotNull TreeNodeCheckListener listener) {
        treeView.addTreeNodeCheckListener(listener);
    }

    public static void registerQueryListener(@NotNull TreeView treeView, @NotNull TreeNodeQueryListener listener) {
        treeView.addTreeNodeQueryListener(listener);
    }

    public TreeNode buildTree(@NotNull TreeView treeView, @NotNull IPageCache pageCache) {
        return this.buildTree(treeView, pageCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeNode buildTree(@NotNull TreeView treeView, @NotNull IPageCache pageCache, Set<Long> selectNodeIds) {
        TreeNode root;
        log.info("begin-buildTree");
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        try {
            root = this.getRoot(pageCache);
            this.cacheNode(pageCache, this.getCacheTreeKey(), root);
            treeView.deleteAllNodes();
            treeView.setRootVisible(this.isShowRoot());
            treeView.addNode(root);
            TreeNode node = this.getFocusNode(root);
            treeView.expand(node.getId());
            treeView.focusNode(TreeNodeUtils.getBaseClone(node));
            this.nodeClick(treeView, node);
            this.afterBuilderTree(treeView);
        }
        finally {
            log.info("end-buildTree");
        }
        return root;
    }

    protected TreeNode getFocusNode(TreeNode root) {
        return root;
    }

    protected void nodeClick(TreeView treeView, TreeNode node) {
        treeView.treeNodeClick(node.getParentid(), node.getId());
    }

    protected abstract String getCacheTreeKey();

    public BaseTreeBuilder setTreeKey(String treeKey) {
        this.treeKey = treeKey;
        return this;
    }

    public String getTreeKey() {
        return this.treeKey;
    }

    protected TreeNode getRoot(@NotNull IPageCache pageCache) {
        return this.createNode("", "root", "root");
    }

    protected TreeNode createNode(String parentId, String id, String text) {
        return new TreeNode(parentId, id, text);
    }

    protected void cacheNode(@NotNull IPageCache pageCache, String cacheKey, TreeNode root) {
        F7TreeUtils.cacheTreeNodeData(pageCache, cacheKey, root);
    }

    protected void afterBuilderTree(@NotNull TreeView treeView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepLoadTree(@NotNull TreeView treeView, @NotNull List<String> nodeIds, @NotNull String cacheKey, String focusNodeId, Set<Long> selectNodeIds, @NotNull IPageCache pageCache) throws Exception {
        log.info("begin-stopLoad-tree");
        TreeNode root = F7TreeUtils.getCacheTreeNodeData(pageCache, cacheKey);
        if (root == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6811\u8282\u70b9\u6570\u636e\u7f13\u5b58\u52a0\u8f7d\u4e3a\u7a7a", (String)"BaseTreeBuilder_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        ArrayList<TreeNode> checkedNodes = new ArrayList<TreeNode>();
        try {
            TreeNode focusNode;
            for (String _nodeId : nodeIds) {
                List<TreeNode> _checked;
                TreeNode node = root.getTreeNode(_nodeId);
                if (node == null || node.getChildren() == null || !node.getChildren().isEmpty()) continue;
                List<TreeNode> _children = this.getChildrenNode(node, root);
                if (CollectionUtils.isEmpty(_children)) {
                    node.setChildren(null);
                    treeView.updateNode(node);
                } else {
                    node.addChildren(_children);
                    treeView.addNodes(_children);
                }
                if (!CollectionUtils.isNotEmpty(_checked = this.getCheckedChildrenNode(_children))) continue;
                checkedNodes.addAll(_checked);
            }
            if (CollectionUtils.isNotEmpty(checkedNodes)) {
                treeView.checkNodesWithoutChild(TreeNodeUtils.getBaseClone(checkedNodes));
            }
            F7TreeUtils.cacheTreeNodeData(pageCache, cacheKey, root);
            if (focusNodeId != null && (focusNode = root.getTreeNode(focusNodeId)) != null) {
                treeView.focusNode(focusNode);
            }
        }
        finally {
            log.info("end-stopLoad-tree");
        }
    }

    protected abstract List<TreeNode> getChildrenNode(TreeNode var1, TreeNode var2);

    protected List<TreeNode> getCheckedChildrenNode(List<TreeNode> children) {
        return null;
    }

    protected boolean hasVerifyPermission(@NotNull Map<String, Object> nodeData) {
        return !nodeData.containsKey(DEFAULT_CANT_CHECK_PERM);
    }

    protected boolean verifyPermission(@NotNull Long memberId) {
        if (this.isVerifyPermission()) {
            if (this.unLoadPermission) {
                this.permissions = this.loadPermission();
                this.unLoadPermission = false;
            }
            return this.permissions == null || this.permissions.contains(memberId);
        }
        return true;
    }

    protected abstract boolean isVerifyPermission();

    protected abstract Set<Long> loadPermission();
}

