/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.range;

import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.range.IMemberRangeItem;
import kd.epm.epbs.common.member.range.strategy.RangeControlStrategy;
import kd.epm.epbs.common.member.range.strategy.SimpleItem;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ViewBean;

public class MemberRangeItem
implements IMemberRangeItem {
    private long modelId;
    private String dimNum;
    private String viewNum;
    private String propNumber;
    private String memNum;
    private long viewId;
    private long memberId;
    private RangeEnum rangeEnum;
    private boolean isCustom = false;
    private boolean isApply = true;
    private String mLongNum;
    private long parentId;

    public MemberRangeItem(long modelId, String dimNum, String viewNum, String propNumber, String memNum, RangeEnum rangeEnum, boolean isApply) {
        this.modelId = modelId;
        this.dimNum = dimNum;
        this.viewNum = viewNum;
        this.propNumber = propNumber;
        this.memNum = memNum;
        this.rangeEnum = rangeEnum;
        this.isApply = isApply;
        this.isCustom = true;
        this.initViewBean(EpbsThreadCache.findViewBeanByNum(modelId, dimNum, viewNum));
    }

    public MemberRangeItem(long modelId, String dimNum, String viewNum, String memNum, RangeEnum rangeEnum, boolean isApply) {
        this.modelId = modelId;
        this.dimNum = dimNum;
        this.viewNum = viewNum;
        this.memNum = memNum;
        this.rangeEnum = rangeEnum;
        this.isApply = isApply;
        this.initMemberBean(EpbsThreadCache.findMemberBeanByNum(modelId, dimNum, viewNum, memNum));
        this.initViewBean(EpbsThreadCache.findViewBeanByNum(modelId, dimNum, viewNum));
        this.isCustom = false;
    }

    public MemberRangeItem(long modelId, String dimNum, long viewId, long memberId, RangeEnum rangeEnum, boolean isApply) {
        this.modelId = modelId;
        this.dimNum = dimNum;
        this.viewId = viewId;
        this.memberId = memberId;
        this.rangeEnum = rangeEnum;
        this.isCustom = false;
        this.isApply = isApply;
        this.initMemberBean(EpbsThreadCache.findMemberBeanById(modelId, dimNum, memberId));
        this.initViewBean(EpbsThreadCache.findViewBeanById(modelId, viewId));
    }

    private final void initMemberBean(MemberBean memberBean) {
        if (memberBean != null) {
            this.memNum = memberBean.getNumber();
            this.mLongNum = memberBean.getLongNumber();
            this.parentId = memberBean.getParentId();
            this.memberId = memberBean.getId();
        }
    }

    private final void initViewBean(ViewBean viewBean) {
        if (viewBean != null) {
            this.viewNum = viewBean.getNumber();
            this.viewId = viewBean.getId();
        }
    }

    @Override
    public void matchItems(Consumer<SimpleItem> m) {
        RangeControlStrategy.getContolByRange(this.getRangeEnum()).matchItems(this, m);
    }

    @Override
    public QFilter buildFilterByScope() {
        return RangeControlStrategy.getContolByRange(this.getRangeEnum()).buildFilterByScope(this);
    }

    @Override
    public Set<String> getMemberNums() {
        return RangeControlStrategy.getContolByRange(this.getRangeEnum()).matchItem4UnmodifiableSet(this);
    }

    @Override
    public boolean isMatch(long id) {
        return RangeControlStrategy.getContolByRange(this.getRangeEnum()).isMatchPermission(this, id);
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public String getDimNum() {
        return this.dimNum;
    }

    public void setDimNum(String dimNum) {
        this.dimNum = dimNum;
    }

    public String getViewNum() {
        return this.viewNum;
    }

    public void setViewNum(String viewNum) {
        this.viewNum = viewNum;
    }

    public String getMemNum() {
        return this.memNum;
    }

    public void setMemNum(String memNum) {
        this.memNum = memNum;
    }

    public long getViewId() {
        return this.viewId;
    }

    public void setViewId(long viewId) {
        this.viewId = viewId;
    }

    public long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(long memberId) {
        this.memberId = memberId;
    }

    public RangeEnum getRangeEnum() {
        return this.rangeEnum;
    }

    public void setRangeEnum(RangeEnum rangeEnum) {
        this.rangeEnum = rangeEnum;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean custom) {
        this.isCustom = custom;
    }

    public boolean isApply() {
        return this.isApply;
    }

    public void setApply(boolean apply) {
        this.isApply = apply;
    }

    public String getLongNum() {
        return this.mLongNum;
    }

    public String getPropNumber() {
        return this.propNumber;
    }

    public void setPropNumber(String propNumber) {
        this.propNumber = propNumber;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String genKey(Object cpId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.modelId).append(this.viewId);
        if (this.isCustom) {
            builder.append(this.propNumber).append(this.memNum);
        } else {
            builder.append(this.memberId).append((Object)this.rangeEnum);
        }
        builder.append(this.isCustom).append(cpId);
        return builder.toString();
    }
}

