/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.range.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.common.member.range.MemberRangeItem;
import kd.epm.epbs.common.member.range.strategy.PermControlCacheHelper;
import kd.epm.epbs.common.member.range.strategy.SimpleItem;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import org.apache.commons.collections4.CollectionUtils;

public interface IRangeControl {
    default public boolean isMatchPermission(MemberRangeItem item, long memberId) {
        String cacheKey;
        Map map = (Map)ThreadCache.get((Object)"matchCache", HashMap::new);
        if (!map.containsKey(cacheKey = item.genKey(null))) {
            HashSet ids = new HashSet(16);
            this.matchItems(item, c -> ids.add(c.getId()));
            map.put(cacheKey, ids);
        }
        return ((Set)map.get(cacheKey)).contains(memberId);
    }

    default public void matchItems(MemberRangeItem item, Consumer<SimpleItem> m) {
        List<SimpleItem> simpleItems = PermControlCacheHelper.matchItems(item, () -> {
            ArrayList itemList = new ArrayList(16);
            if (item.isCustom()) {
                ((EpbsPropCache)EpbsPropCacheHelper.get(item.getModelId(), item.getDimNum())).getMembers(item.getPropNumber(), item.getMemNum(), item.getViewId()).forEach(s -> {
                    if (s != null) {
                        itemList.add(new SimpleItem(s.getId(), s.getNumber()));
                    }
                });
            } else {
                ((EpbsMemberCache)EpbsMemberCacheHelper.get(item.getModelId(), item.getDimNum())).getMembers(item.getMemberId(), item.getRangeEnum()).forEach(s -> {
                    if (s != null) {
                        itemList.add(new SimpleItem(s.getId(), s.getNumber()));
                    }
                });
            }
            return itemList;
        });
        if (CollectionUtils.isNotEmpty(simpleItems)) {
            simpleItems.forEach(m);
        }
    }

    default public Set<String> matchItem4UnmodifiableSet(MemberRangeItem item) {
        return PermControlCacheHelper.matchItemSets(item, () -> {
            HashSet members = new HashSet(16);
            this.matchItems(item, c -> members.add(c.getNumber()));
            return members;
        });
    }

    default public QFilter buildFilterByScope(MemberRangeItem item) {
        if (item.isCustom()) {
            return this.buildCusQFilterByScope(item);
        }
        QFilter filter = new QFilter("model", "=", (Object)item.getModelId());
        filter.and("view", "=", (Object)item.getViewId());
        filter.and(this.buildMemberQfilterByScope(item));
        return filter;
    }

    public QFilter buildMemberQfilterByScope(MemberRangeItem var1);

    default public QFilter buildCusQFilterByScope(MemberRangeItem item) {
        List memberIds = ((EpbsPropCache)EpbsPropCacheHelper.get(item.getModelId(), item.getDimNum())).getMembers(item.getPropNumber(), item.getMemNum(), item.getViewId()).stream().map(BaseBean::getId).collect(Collectors.toList());
        QFilter qFilter = new QFilter("1", "=", (Object)0);
        if (CollectionUtils.isNotEmpty(memberIds)) {
            qFilter = new QFilter("id", "in", memberIds);
        }
        return qFilter;
    }
}

