/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.member.range.strategy;

import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.range.strategy.AllChildrenExcludSelfControl;
import kd.epm.epbs.common.member.range.strategy.AllChildrenIncSelfControl;
import kd.epm.epbs.common.member.range.strategy.AllChildrenOnlyDetailControl;
import kd.epm.epbs.common.member.range.strategy.AllChildrenOnlyDetailIncSelfControl;
import kd.epm.epbs.common.member.range.strategy.AllChildrenOnlyNonDetailControl;
import kd.epm.epbs.common.member.range.strategy.BrotherExcludeSelfControl;
import kd.epm.epbs.common.member.range.strategy.BrotherIncSelfControl;
import kd.epm.epbs.common.member.range.strategy.DirectChildrenExcludSelfControl;
import kd.epm.epbs.common.member.range.strategy.DirectChildrenIncSelfControl;
import kd.epm.epbs.common.member.range.strategy.IRangeControl;
import kd.epm.epbs.common.member.range.strategy.OnlySelfControl;

public class RangeControlStrategy {
    public static IRangeControl getContolByRange(RangeEnum range) {
        IRangeControl control = null;
        switch (range) {
            case ONLY: {
                control = new OnlySelfControl();
                break;
            }
            case DIRECTSUB_EXCLUDE: {
                control = new DirectChildrenExcludSelfControl();
                break;
            }
            case DIRECTSUB: {
                control = new DirectChildrenIncSelfControl();
                break;
            }
            case ALL_EXCLUDE: {
                control = new AllChildrenExcludSelfControl();
                break;
            }
            case ALL: {
                control = new AllChildrenIncSelfControl();
                break;
            }
            case PEERS: {
                control = new BrotherIncSelfControl();
                break;
            }
            case PEERS_EXCLUDE: {
                control = new BrotherExcludeSelfControl();
                break;
            }
            case ALL_DETAIL: {
                control = new AllChildrenOnlyDetailControl();
                break;
            }
            case ALL_DETAIL_INCLUDE: {
                control = new AllChildrenOnlyDetailIncSelfControl();
                break;
            }
            case ALL_NOTDETAIL: {
                control = new AllChildrenOnlyNonDetailControl();
                break;
            }
            default: {
                throw new RuntimeException("not support perm Range:" + range.getName());
            }
        }
        return control;
    }
}

