/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.model.DayEnum;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.enums.model.MonthEnum;
import kd.epm.epbs.common.enums.model.PeriodYearEnum;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.YearPeriod;
import kd.epm.epbs.common.util.DateTimeUtils;

public class BaseMemberBean {
    private long id;
    private MemberSourceTypeEnum sourceType;
    private ILocaleString desc;
    private ILocaleString shortName;
    private DimTypeBean dimTypeBean;
    private DataTypeEnum dataType;
    private PeriodYearEnum startYear;
    private String startMonth;
    private String startDay;
    private PeriodYearEnum endYear;
    private String endMonth;
    private String endDay;
    private List<Long> treeMemberIds = new ArrayList<Long>(10);
    private Map<String, Object> extData = new HashMap<String, Object>(16);

    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    public MemberSourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    protected void setSourceType(MemberSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public String getDesc() {
        if (this.desc != null) {
            String localeValue = (String)this.desc.computeIfAbsent((Object)Lang.get().name(), k -> {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.dimTypeBean.getBaseMemberModel(), (String)"description", (QFilter[])new QFilter("id", "=", (Object)this.getId()).toArray());
                if (dynamicObject != null) {
                    return dynamicObject.getString("description");
                }
                return null;
            });
            if (localeValue == null) {
                localeValue = (String)this.desc.get((Object)"GLang");
            }
            return localeValue;
        }
        return null;
    }

    protected void setDesc(ILocaleString desc) {
        this.desc = desc;
    }

    public String getShortName() {
        if (this.shortName != null) {
            String localeValue = (String)this.shortName.computeIfAbsent((Object)Lang.get().name(), k -> {
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.dimTypeBean.getBaseMemberModel(), (String)"shortname", (QFilter[])new QFilter("id", "=", (Object)this.getId()).toArray());
                if (dynamicObject != null) {
                    return dynamicObject.getString("shortname");
                }
                return null;
            });
            if (localeValue == null) {
                localeValue = (String)this.shortName.get((Object)"GLang");
            }
            return localeValue;
        }
        return null;
    }

    protected void setShortName(ILocaleString shortName) {
        this.shortName = shortName;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    protected void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public Map<String, Object> getExtData() {
        return this.extData;
    }

    public void setExtData(String key, Object data) {
        this.extData.put(key, data);
    }

    public boolean isPreset() {
        return MemberSourceTypeEnum.PRESET == this.sourceType;
    }

    public PeriodYearEnum getStartYear() {
        return this.startYear;
    }

    protected void setStartYear(PeriodYearEnum startYear) {
        this.startYear = startYear;
    }

    public String getStartMonth() {
        return this.startMonth;
    }

    protected void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }

    public String getStartDay() {
        return this.startDay;
    }

    protected void setStartDay(String startDay) {
        this.startDay = startDay;
    }

    public PeriodYearEnum getEndYear() {
        return this.endYear;
    }

    protected void setEndYear(PeriodYearEnum endYear) {
        this.endYear = endYear;
    }

    public String getEndMonth() {
        return this.endMonth;
    }

    protected void setEndMonth(String endMonth) {
        this.endMonth = endMonth;
    }

    public String getEndDay() {
        return this.endDay;
    }

    protected void setEndDay(String endDay) {
        this.endDay = endDay;
    }

    public String getStartDate() {
        MonthEnum month = MonthEnum.get(this.getStartMonth());
        DayEnum startDay = DayEnum.get(this.getStartDay());
        return String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s", (String)"BaseMemberBean_1", (String)"epm-epbs-common", (Object[])new Object[0]), this.getStartYear().getName().getLocaleString(), month.getBridge().getLocaleString(), startDay.getBridge().getLocaleString());
    }

    public List<Long> getTreeMemberIds() {
        return this.treeMemberIds;
    }

    protected void setTreeMemberIds(List<Long> treeMemberIds) {
        this.treeMemberIds = treeMemberIds;
    }

    protected void addTreeMemberId(Long treeMemberId) {
        this.treeMemberIds.add(treeMemberId);
    }

    public String getEndDate() {
        MonthEnum endMonth = MonthEnum.get(this.getEndMonth());
        DayEnum endDay = DayEnum.get(this.getEndDay());
        return String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s", (String)"BaseMemberBean_1", (String)"epm-epbs-common", (Object[])new Object[0]), this.getEndYear().getName().getLocaleString(), endMonth.getBridge().getLocaleString(), endDay.getBridge().getLocaleString());
    }

    public String getStartDate(YearPeriod yearPeriod) {
        MonthEnum month = MonthEnum.get(this.getStartMonth());
        DayEnum startDay = DayEnum.get(this.getRealDay(yearPeriod, this.getStartDay()));
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74 %2$s %3$s", (String)"BaseMemberBean_2", (String)"epm-epbs-common", (Object[])new Object[0]), this.getStartYear().getYear(yearPeriod.getYearNumber()), month.getBridge().getLocaleString(), startDay.getBridge().getLocaleString());
    }

    public String getEndDate(YearPeriod yearPeriod) {
        MonthEnum endMonth = MonthEnum.get(this.getEndMonth());
        DayEnum endDay = DayEnum.get(this.getRealDay(yearPeriod, this.getEndDay()));
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74 %2$s %3$s", (String)"BaseMemberBean_2", (String)"epm-epbs-common", (Object[])new Object[0]), this.getEndYear().getYear(yearPeriod.getYearNumber()), endMonth.getBridge().getLocaleString(), endDay.getBridge().getLocaleString());
    }

    private String getRealDay(YearPeriod yearPeriod, String day) {
        String yearNumber = yearPeriod.getYearNumber();
        try {
            if (DateTimeUtils.isLeapYear(Integer.parseInt(yearNumber)) && "2".equals(this.getStartMonth()) && "29".equals(this.getStartDay())) {
                day = "28";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return day;
    }

    public DimTypeBean getDimTypeBean() {
        return this.dimTypeBean;
    }

    protected void setDimTypeBean(DimTypeBean dimTypeBean) {
        this.dimTypeBean = dimTypeBean;
    }
}

