/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.LinkedHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.enums.model.MemberSourceTypeEnum;
import kd.epm.epbs.common.enums.model.PeriodYearEnum;
import kd.epm.epbs.common.model.bean.BaseMemberBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class BaseMemberFactory {
    protected String getSelectField(DimTypeBean dimType) {
        String select = "id,datatype,sourcetype,description,shortname";
        if (DimTypeEnum.Period.getValue().equals(dimType.getType())) {
            select = select + ",startyear,startmonth,startday,endyear,endmonth,endday";
        }
        return select;
    }

    public LinkedHashMap<Long, BaseMemberBean> queryBeanMap(long modelId, long dimensionId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
        Object dimension = modelCache.getDimensionById(dimensionId);
        DimTypeBean dimType = modelCache.getDimTypeById(((DimensionBean)dimension).getDimTypeId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dimType.getBaseMemberModel(), (String)this.getSelectField(dimType), (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimensionId)});
        LinkedHashMap<Long, BaseMemberBean> beanLinkedHashMap = new LinkedHashMap<Long, BaseMemberBean>(dynamicObjects.size());
        for (DynamicObject baseMember : dynamicObjects) {
            BaseMemberBean memberBean = new BaseMemberBean();
            memberBean.setDimTypeBean(dimType);
            memberBean.setId(baseMember.getLong("id"));
            memberBean.setDataType(DataTypeEnum.getDataTypeEnumByCode(baseMember.getString("datatype")));
            memberBean.setSourceType(MemberSourceTypeEnum.getMemberSourceType(baseMember.getString("sourcetype")));
            memberBean.setDesc((ILocaleString)new LocaleString(Lang.get().name(), baseMember.getString("description")));
            memberBean.setShortName((ILocaleString)new LocaleString(Lang.get().name(), baseMember.getString("shortname")));
            if (DimTypeEnum.Period.getValue().equals(dimType.getType())) {
                memberBean.setStartYear(PeriodYearEnum.get(baseMember.getString("startyear")));
                memberBean.setStartMonth(baseMember.getString("startmonth"));
                memberBean.setStartDay(baseMember.getString("startday"));
                memberBean.setEndYear(PeriodYearEnum.get(baseMember.getString("endyear")));
                memberBean.setEndMonth(baseMember.getString("endmonth"));
                memberBean.setEndDay(baseMember.getString("endday"));
            }
            beanLinkedHashMap.put(memberBean.getId(), memberBean);
        }
        return beanLinkedHashMap;
    }
}

