/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.model.bean.BizModelDomainBean;
import kd.epm.epbs.common.model.bean.ModelBean;

public class BizModelDomainFactory<T extends BizModelDomainBean> {
    public Map<Long, T> queryBeansByModel(ModelBean modelBean) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelBean.getId());
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_businessdomain"), (QFilter[])qFilter.toArray());
        LinkedHashMap<Long, BizModelDomainBean> beanMap = new LinkedHashMap<Long, BizModelDomainBean>(objectMap.size());
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            BizModelDomainBean bean = new BizModelDomainBean();
            String number = dy.getString("number");
            bean.setNumber(number);
            bean.setName(dy.getLocaleString("name"));
            long id = dy.getLong("id");
            bean.setId(id);
            beanMap.put(id, bean);
        }
        Map dimRefMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_dimmodelref"), (QFilter[])new QFilter[]{new QFilter("businessdomain", "in", beanMap.keySet())});
        for (Map.Entry entry : dimRefMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            long domainId = dy.getLong("businessdomain_id");
            BizModelDomainBean bizModelDomainBean = (BizModelDomainBean)beanMap.get(domainId);
            if (bizModelDomainBean == null) continue;
            long dimension = dy.getLong("dimension_id");
            DynamicObjectCollection dimViews = dy.getDynamicObjectCollection("dimviews");
            List views = dimViews.stream().map(o -> o.getLong("view_id")).collect(Collectors.toList());
            Map<Long, List<Long>> dimViewMap = bizModelDomainBean.getDimViewMap();
            dimViewMap.put(dimension, views);
        }
        return Collections.unmodifiableMap(beanMap);
    }
}

