/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.enums.model.BizModelAggoprtTypeEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.ModelBean;
import kd.epm.epbs.common.model.bean.RelationFieldBean;
import kd.epm.epbs.common.model.bean.RelationFieldDimsBean;
import org.jetbrains.annotations.NotNull;

public class BizModelFactory<T extends BizModelBean> {
    public Map<Long, T> queryBeansByModel(ModelBean modelBean) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelBean.getId());
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_bizmodel"), (QFilter[])qFilter.toArray());
        LinkedHashMap<Long, BizModelBean> beanMap = new LinkedHashMap<Long, BizModelBean>(objectMap.size());
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            BizModelBean bizModelBean = new BizModelBean();
            String string = dy.getString("number");
            bizModelBean.setNumber(string);
            bizModelBean.setName(dy.getLocaleString("name"));
            long id = dy.getLong("id");
            bizModelBean.setId(id);
            bizModelBean.setBizModelDomainId(dy.getLong("businessdomainid_id"));
            bizModelBean.setCube(dy.getString("cubenumber"));
            bizModelBean.setEnable("1".equals(dy.getString("enable")));
            bizModelBean.setBizModelType(BizModelTypeEnum.getBizModelType(dy.getString("type")));
            bizModelBean.setDataModelId(dy.getLong("datamodelid"));
            bizModelBean.setUniquecheck(dy.getString("uniquecheck"));
            beanMap.put(id, bizModelBean);
        }
        QFilter qFilterDim = new QFilter("model", "=", (Object)modelBean.getId());
        Map dimRefMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_dimmodelref"), (QFilter[])qFilterDim.toArray());
        for (Map.Entry entry : dimRefMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            long bizModelId = dynamicObject.getLong("bizmodel_id");
            BizModelBean bizModelBean = (BizModelBean)beanMap.get(bizModelId);
            if (bizModelBean == null) continue;
            this.initDimView(dynamicObject, bizModelBean);
        }
        Map relationRefMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_relationmodelentity"), (QFilter[])qFilterDim.toArray());
        for (Map.Entry<Object, DynamicObject> entry : relationRefMap.entrySet()) {
            DynamicObject dy = (DynamicObject)entry.getValue();
            long bizModelId = dy.getLong("bizmodel_id");
            BizModelBean bizModelBean = (BizModelBean)beanMap.get(bizModelId);
            if (bizModelBean == null) continue;
            if (bizModelBean.getRelationFieldMap() == null) {
                bizModelBean.setRelationFieldMap(new HashMap<Long, RelationFieldBean>());
            }
            RelationFieldBean relationFieldBean = BizModelFactory.initRelationBean(entry);
            if (bizModelBean.getRelationFieldMap() == null) continue;
            bizModelBean.getRelationFieldMap().put(dy.getLong("id"), relationFieldBean);
        }
        for (Map.Entry entry : beanMap.entrySet()) {
            if (entry.getValue() == null) continue;
            ((BizModelBean)entry.getValue()).setRelationFieldMap(Collections.unmodifiableMap(((BizModelBean)entry.getValue()).getRelationFieldMap()));
        }
        for (Map.Entry entry : beanMap.entrySet()) {
            BizModelBean value = (BizModelBean)entry.getValue();
            value.setDimMap(Collections.unmodifiableMap(value.getDimMap()));
        }
        return Collections.unmodifiableMap(beanMap);
    }

    @NotNull
    private static RelationFieldBean initRelationBean(Map.Entry<Object, DynamicObject> entry) {
        RelationFieldBean relationFieldBean = new RelationFieldBean();
        relationFieldBean.setId((Long)entry.getKey());
        relationFieldBean.setNumber(entry.getValue().getString("number"));
        relationFieldBean.setName(entry.getValue().getLocaleString("name"));
        relationFieldBean.setType(entry.getValue().getString("type"));
        relationFieldBean.setDseq(entry.getValue().getInt("dseq"));
        relationFieldBean.setDataTye(entry.getValue().getString("datatye"));
        relationFieldBean.setMustInput(entry.getValue().getBoolean("ismustinput"));
        relationFieldBean.setEnable(entry.getValue().getBoolean("isenable"));
        relationFieldBean.setIsconnect(entry.getValue().getBoolean("isconnect"));
        relationFieldBean.setSelectBizmodelId(entry.getValue().getLong("selectmodelid.id"));
        relationFieldBean.setDimensionId(entry.getValue().getLong("dimensionid.id"));
        relationFieldBean.setBusinessDomainId(entry.getValue().getLong("businessdomainid.id"));
        DynamicObjectCollection dimmembers = entry.getValue().getDynamicObjectCollection("dimmembers");
        for (DynamicObject dimmember : dimmembers) {
            RelationFieldDimsBean relationFieldDimsBean = new RelationFieldDimsBean();
            relationFieldDimsBean.setId(dimmember.getLong("id"));
            relationFieldDimsBean.setMemberId(dimmember.getLong("memberid"));
            relationFieldDimsBean.setViewId(dimmember.getLong("view.id"));
            relationFieldDimsBean.setViewName(dimmember.getString("view.name"));
            relationFieldDimsBean.setViewName(dimmember.getString("view.number"));
            relationFieldDimsBean.setScope(dimmember.getString("scope"));
            relationFieldBean.getDimMembers().add(relationFieldDimsBean);
        }
        relationFieldBean.setDimMembers(Collections.unmodifiableList(relationFieldBean.getDimMembers()));
        return relationFieldBean;
    }

    private void initDimView(DynamicObject dy, T bizModelBean) {
        long dimension = dy.getLong("dimension_id");
        DynamicObjectCollection dimViews = dy.getDynamicObjectCollection("dimviews");
        List views = dimViews.stream().map(o -> o.getLong("view_id")).collect(Collectors.toList());
        BizModelDimBean bizModelDimBean = new BizModelDimBean();
        bizModelDimBean.setViewIds(Collections.unmodifiableList(views));
        bizModelDimBean.setSyncCube(dy.getBoolean("issync"));
        bizModelDimBean.setDseq(dy.getInt("dseq"));
        bizModelDimBean.setBizModelAggoprtType(BizModelAggoprtTypeEnum.getBizModelAggoprtType(dy.getString("aggoprttype")));
        Map<Long, BizModelDimBean> dimMap = ((BizModelBean)bizModelBean).getDimMap();
        dimMap.put(dimension, bizModelDimBean);
    }
}

