/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.enums.model.AggoprtEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BaseMemberBean;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class MemberFactory {
    protected String getSelectField(DimTypeBean dimType) {
        String select = "id,view,parent,number,name,shownumber,longnumber,member,level,aggoprt,enable";
        if (DimTypeEnum.Year.getValue().equals(dimType.getType())) {
            select = select + ",isstandard";
        } else if (DimTypeEnum.Version.getValue().equals(dimType.getType())) {
            select = select + ",versiontype";
        }
        return select;
    }

    public Map<Long, LinkedHashMap<Long, MemberBean>> queryBeanMap(long modelId, long dimensionId, Map<Long, BaseMemberBean> baseMemberMap) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
        Object dimension = modelCache.getDimensionById(dimensionId);
        DimTypeBean dimType = modelCache.getDimTypeById(((DimensionBean)dimension).getDimTypeId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)dimType.getMemberTreemodel(), (String)this.getSelectField(dimType), (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimensionId)}, (String)"level,dseq");
        LinkedHashMap<Long, LinkedHashMap> viewBeanLinkedHashMap = new LinkedHashMap<Long, LinkedHashMap>(dynamicObjects.size());
        for (DynamicObject treeMember : dynamicObjects) {
            MemberBean memberBean = new MemberBean();
            memberBean.setDimTypeBean(dimType);
            memberBean.setId(treeMember.getLong("id"));
            memberBean.setParentId(treeMember.getLong("parent"));
            memberBean.setViewId(treeMember.getLong("view"));
            memberBean.setNumber(treeMember.getString("number"));
            memberBean.setShowNumber(treeMember.getString("shownumber"));
            memberBean.setAggoprt(AggoprtEnum.getAggport(treeMember.getString("aggoprt")));
            memberBean.setLevel(treeMember.getInt("level"));
            memberBean.setLongNumber(treeMember.getString("longnumber"));
            memberBean.setName((ILocaleString)new LocaleString(Lang.get().name(), treeMember.getString("name")));
            memberBean.setEnable(treeMember.getBoolean("enable"));
            if (DimTypeEnum.Year.getValue().equals(dimType.getType())) {
                memberBean.setStandardYear(treeMember.getBoolean("isstandard"));
            } else if (DimTypeEnum.Version.getValue().equals(dimType.getType())) {
                memberBean.setVersionType(treeMember.getString("versiontype"));
            }
            BaseMemberBean baseMemberBean = baseMemberMap.get(treeMember.getLong("member"));
            if (baseMemberBean != null) {
                baseMemberBean.addTreeMemberId(memberBean.getId());
                memberBean.setBaseMemberBean(baseMemberBean);
            }
            LinkedHashMap beanLinkedHashMap = viewBeanLinkedHashMap.computeIfAbsent(memberBean.getViewId(), f -> new LinkedHashMap(160));
            beanLinkedHashMap.put(memberBean.getId(), memberBean);
        }
        for (Map.Entry entry : viewBeanLinkedHashMap.entrySet()) {
            Collection memberBeans = ((LinkedHashMap)entry.getValue()).values();
            Map<Long, MemberBean> parentMap = memberBeans.stream().collect(Collectors.toMap(BaseBean::getId, o -> o));
            for (MemberBean memberBean : memberBeans) {
                MemberBean parent = parentMap.get(memberBean.getParentId());
                if (parent == null) continue;
                parent.addChildren(memberBean);
            }
        }
        for (LinkedHashMap value : viewBeanLinkedHashMap.values()) {
            for (MemberBean memberBean : value.values()) {
                memberBean.setChildren(Collections.unmodifiableList(memberBean.getChildren()));
                memberBean.setExtData(Collections.unmodifiableMap(memberBean.getExtData()));
            }
        }
        return Collections.unmodifiableMap(viewBeanLinkedHashMap);
    }
}

