/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.enums.model.PropScopeEnum;
import kd.epm.epbs.common.enums.model.PropTimeTypeEnum;
import kd.epm.epbs.common.enums.model.PropTypeEnum;
import kd.epm.epbs.common.model.bean.MemberPropBean;
import kd.epm.epbs.common.model.bean.PropBean;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class PropFactory {
    public Map<Long, PropBean> queryBeanMap(long modelId, long dimensionId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
        String select = "id,number,name,scope,datatype,timetype,enum,basedata,refdimension,bizmodel,propvalues.id,propvalues.sourcenumber,propvalues.sourcename";
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)modelCache.getMetaDataEntity("epbs_propertydefined"), (String)select, (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimensionId)});
        HashMap<Long, PropBean> beanMap = new HashMap<Long, PropBean>(objectMap.size());
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            PropBean propBean = new PropBean();
            propBean.setId(dynamicObject.getLong("id"));
            propBean.setNumber(dynamicObject.getString("number"));
            propBean.setName(dynamicObject.getLocaleString("name"));
            propBean.setPropScope(PropScopeEnum.get(dynamicObject.getString("scope")));
            propBean.setPropType(PropTypeEnum.getPropTypeEnum(dynamicObject.getString("datatype")));
            propBean.setPropTimeType(PropTimeTypeEnum.get(dynamicObject.getString("timetype")));
            propBean.setEnumId(dynamicObject.getLong("enum_id"));
            propBean.setRefDimensionId(dynamicObject.getLong("refdimension_id"));
            propBean.setBizModelId(dynamicObject.getLong("bizmodel_id"));
            propBean.setBaseDataId(dynamicObject.getLong("basedata_id"));
            DynamicObjectCollection propValues = dynamicObject.getDynamicObjectCollection("propvalues");
            HashMap<String, PropValueBean> propValueMap = new HashMap<String, PropValueBean>(propValues.size());
            HashMap<Long, PropValueBean> propValueBeanIdMap = new HashMap<Long, PropValueBean>(propValues.size());
            for (DynamicObject propValue : propValues) {
                PropValueBean bean = new PropValueBean();
                bean.setId(propValue.getLong("id"));
                bean.setNumber(propValue.getString("sourcenumber"));
                bean.setName(propValue.getLocaleString("sourcename"));
                bean.setPropId(propBean.getId());
                propValueMap.put(bean.getNumber(), bean);
                propValueBeanIdMap.put(bean.getId(), bean);
            }
            propBean.setPropValueBeanMap(propValueMap);
            propBean.setPropValueBeanIdMap(propValueBeanIdMap);
            beanMap.put(propBean.getId(), propBean);
        }
        Map memberPropMap = BusinessDataServiceHelper.loadFromCache((String)modelCache.getMetaDataEntity("epbs_membpropval"), (String)"id,propval,propertydefined,memberid", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimensionId)});
        for (Map.Entry entry : memberPropMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            long propertyDefinedId = dynamicObject.getLong("propertydefined_id");
            PropBean propBean = (PropBean)beanMap.get(propertyDefinedId);
            if (propBean == null) continue;
            String propVal = dynamicObject.getString("propval");
            MemberPropBean memberPropBean = new MemberPropBean();
            memberPropBean.setId(dynamicObject.getLong("id"));
            if (propBean.getPropType().isHasPropValue()) {
                for (Map.Entry<String, PropValueBean> propValueBeanEntry : propBean.getPropValueBeanMap().entrySet()) {
                    if (!Objects.equals(String.valueOf(propValueBeanEntry.getValue().getId()), propVal)) continue;
                    memberPropBean.setPropValueBean(propValueBeanEntry.getValue());
                    break;
                }
            } else {
                memberPropBean.setPropValue(propVal);
            }
            memberPropBean.setMemberId(dynamicObject.getLong("memberid"));
            memberPropBean.setPropertyId(propertyDefinedId);
            List memberPropBeans = propBean.getMemberPropBeanMap().computeIfAbsent(propVal, k -> new ArrayList(10));
            memberPropBeans.add(memberPropBean);
        }
        return Collections.unmodifiableMap(beanMap);
    }
}

