/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.enums.model.PeriodTypeEnum;
import kd.epm.epbs.common.enums.model.ViewScopeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.ModelBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;

public class ViewFactory<T extends ViewBean> {
    public Map<Long, T> queryBeansByModel(EpbsModelCache modelCache) {
        ModelBean modelBean = (ModelBean)modelCache.getModel();
        QFilter qFilter = new QFilter("model", "=", (Object)modelBean.getId()).and("isgroup", "=", (Object)false);
        List periodDims = modelCache.getDimensionsByDimType(DimTypeEnum.Period);
        List periodDimIds = periodDims.stream().map(BaseBean::getId).collect(Collectors.toList());
        Map viewMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_struct_view"), (QFilter[])new QFilter[]{qFilter, new QFilter("dimension", "not in", periodDimIds)});
        Map periodViewMap = BusinessDataServiceHelper.loadFromCache((String)modelBean.getMetaDataEntity("epbs_period_view"), (QFilter[])new QFilter[]{qFilter, new QFilter("dimension", "in", periodDimIds)});
        LinkedHashMap beanMap = new LinkedHashMap(viewMap.size() + periodViewMap.size());
        this.putBeanMap(beanMap, viewMap, false);
        this.putBeanMap(beanMap, periodViewMap, true);
        return Collections.unmodifiableMap(beanMap);
    }

    private void putBeanMap(Map<Long, T> beanMap, Map<Object, DynamicObject> viewMap, Boolean isPeriodView) {
        for (Map.Entry<Object, DynamicObject> entry : viewMap.entrySet()) {
            DynamicObject dy = entry.getValue();
            ViewBean bean = new ViewBean();
            String number = dy.getString("number");
            bean.setNumber(number);
            bean.setName(dy.getLocaleString("name"));
            long id = dy.getLong("id");
            bean.setId(id);
            bean.setDimensionId(dy.getLong("dimension_id"));
            bean.setGroupId(dy.getLong("parent_id"));
            bean.setDefault(dy.getBoolean("isdefault"));
            bean.setViewScopeEnum(ViewScopeEnum.getViewScopeEnumByValue(dy.getString("type")));
            if (isPeriodView.booleanValue()) {
                bean.setStartDay(dy.getInt("startday"));
                bean.setStartMonth(dy.getInt("startmonth"));
                bean.setEndDay(dy.getInt("endday"));
                bean.setEndMonth(dy.getInt("endmonth"));
                bean.setPeriodTypeEnum(PeriodTypeEnum.getPeriodType(dy.getString("periodtype")));
            }
            beanMap.put(id, bean);
        }
    }
}

