/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.model.DefaultDimMember;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ModelBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationBaseEntityObject;
import kd.epm.epbs.common.model.bean.relation.RelationDimBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RelationModelBean
extends RelationBaseEntityObject {
    private static final long serialVersionUID = -4255414016617139586L;

    public long getModelId() {
        return this.get("modelId", 0L);
    }

    public void setModelId(long modelId) {
        this.put("modelId", (Object)modelId);
    }

    public String getModelNum() {
        return (String)this.get("modelNum");
    }

    public void setModelNum(String modelNum) {
        this.put("modelNum", (Object)modelNum);
    }

    public long getBizModelDomainId() {
        return this.get("bmdid", 0L);
    }

    protected void setBizModelDomainId(Long bizModelDomainId) {
        this.put("bmdid", (Object)bizModelDomainId);
    }

    public long getBizDataModelId() {
        return this.get("datamodelid", 0L);
    }

    public void setBizDataModelId(long dataModelId) {
        this.put("datamodelid", (Object)dataModelId);
    }

    public String getBizModelDomainNum() {
        return (String)this.get("bmdnum");
    }

    public void setBizModelDomainNum(String bizModelDomainNum) {
        this.put("bmdnum", (Object)bizModelDomainNum);
    }

    public List<String> getColFields() {
        return (List)this.get("cfnumlist");
    }

    public void setColFields(List<String> colFields) {
        this.put("cfnumlist", (Object)colFields);
    }

    public List<String> getMustInputFields() {
        return (List)this.get("mustinputfnums");
    }

    public void setMustInputFields(List<String> colFields) {
        this.put("mustinputfnums", (Object)colFields);
    }

    public Map<String, FieldBean> getFieldBeanMap() {
        return (Map)this.get("cfbeanmap");
    }

    public void setFieldBeanMap(Map<String, FieldBean> fieldBeanMap) {
        this.put("cfbeanmap", (Object)fieldBeanMap);
    }

    public Map<Long, String> getIdToNumMap() {
        return (Map)this.get("cfidtonummap");
    }

    public void setIdToNumMap(Map<Long, String> map) {
        this.put("cfidtonummap", (Object)map);
    }

    public String getRelationCubeNum() {
        return (String)this.get("cubenumber");
    }

    public void setRelationCubeNum(String relationCubeNum) {
        this.put("cubenumber", (Object)relationCubeNum);
    }

    public List<String> getUniqueCheckNums() {
        return (List)this.get("uniquecheck");
    }

    public void setUniqueCheckNums(List<String> nums) {
        this.put("uniquecheck", (Object)nums);
    }

    public boolean getStatus() {
        return this.get("enable", false);
    }

    public void setStatus(boolean status) {
        this.put("enable", (Object)status);
    }

    public RelationModelBean() {
        this.put("cfbeanmap", (Object)new HashMap(16));
        this.put("cfnumlist", (Object)new ArrayList(16));
        this.put("mustinputfnums", (Object)new ArrayList(16));
        this.put("uniquecheck", (Object)new ArrayList(16));
        this.put("cfidtonummap", (Object)new HashMap(16));
    }

    public RelationModelBean(long modelId, String bizModelNum) {
        ModelBean modelBean = (ModelBean)EpbsModelCacheHelper.getModel(modelId);
        String bizModelEntity = modelBean.getMetaDataEntity("epbs_bizmodel");
        String relaModelDataEntity = modelBean.getMetaDataEntity("epbs_relationmodelentity");
        DynamicObject object = QueryServiceHelper.queryOne((String)bizModelEntity, (String)String.join((CharSequence)",", this.getSimpleSelectProperties(true)), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bizModelNum).and("model", "=", (Object)modelId)});
        this.loadData(object, bizModelEntity, relaModelDataEntity);
    }

    public RelationModelBean(long modelId, long id) {
        ModelBean modelBean = (ModelBean)EpbsModelCacheHelper.getModel(modelId);
        String bizModelEntity = modelBean.getMetaDataEntity("epbs_bizmodel");
        String relaModelDataEntity = modelBean.getMetaDataEntity("epbs_relationmodelentity");
        DynamicObject object = QueryServiceHelper.queryOne((String)bizModelEntity, (String)String.join((CharSequence)",", this.getSimpleSelectProperties(true)), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        this.loadData(object, bizModelEntity, relaModelDataEntity);
    }

    public final void loadData(DynamicObject object, String bizModelEntity, String relaModelDataEntity) {
        this.loadSimpleDynamicObject(object);
        this.setRelationCubeNum(object.getString("cubenumber"));
        this.setModelId(object.getLong("model.id"));
        this.setModelNum(object.getString("model.number"));
        this.setBizModelDomainId(object.getLong("businessdomainid.id"));
        this.setBizModelDomainNum(object.getString("businessdomainid.number"));
        this.setBizDataModelId(object.getLong("datamodelid"));
        this.setStatus(object.getBoolean("enable"));
        List<Long> uniqueCheckIds = this.getUniqueCheckIds(object);
        DynamicObject[] fieldDyos = BusinessDataServiceHelper.load((String)relaModelDataEntity, (String)String.join((CharSequence)",", this.getSimpleSelectProperties(false)), (QFilter[])new QFilter[]{new QFilter("bizmodel", "=", (Object)object.getLong("id"))}, (String)"dseq");
        HashMap<Long, String> idToNumMap = new HashMap<Long, String>(16);
        HashMap<String, FieldBean> fieldBeanMap = new HashMap<String, FieldBean>(16);
        ArrayList<String> fieldNums = new ArrayList<String>(16);
        ArrayList<String> uniqueCheckNums = new ArrayList<String>(16);
        ArrayList<String> mustInputNums = new ArrayList<String>(16);
        for (DynamicObject dyo : fieldDyos) {
            FieldBean fieldBean = new FieldBean();
            fieldBean.loadSimpleDynamicObject(dyo);
            fieldBean.setDesc(dyo.getString("description"));
            RelationTypeEnum typeEnum = RelationTypeEnum.getEnumByNum(dyo.getString("type"));
            fieldBean.setTypeEnum(typeEnum);
            fieldBean.setConnect(dyo.getBoolean("isconnect"));
            switch (typeEnum) {
                case DIMLIB: {
                    this.setDimension(fieldBean, dyo, false);
                    this.setMemberScopes(fieldBean, dyo);
                    break;
                }
                case BASICDATA: {
                    fieldBean.setBaseData(dyo.getLong("basedataid.id"));
                    break;
                }
                case MODEL: {
                    long bizModelId = dyo.getLong("selectmodelid.id");
                    fieldBean.setBizModelId(bizModelId);
                    fieldBean.setBizModelDomainId(this.getBizModelDomainId());
                    this.setDimension(fieldBean, dyo, true);
                    break;
                }
                case NOTHING: {
                    fieldBean.setDataType(dyo.getString("datatye"));
                    break;
                }
            }
            fieldBean.setIsmustinput(dyo.getBoolean("ismustinput"));
            fieldBean.setDataEntityNumber(relaModelDataEntity);
            fieldBeanMap.put(dyo.getString("number"), fieldBean);
            idToNumMap.put(dyo.getLong("id"), dyo.getString("number"));
            fieldNums.add(dyo.getString("number"));
            if (uniqueCheckIds.contains(dyo.getLong("id"))) {
                uniqueCheckNums.add(dyo.getString("number"));
            }
            if (!fieldBean.isIsmustinput()) continue;
            mustInputNums.add(dyo.getString("number"));
        }
        this.setColFields(fieldNums);
        this.setFieldBeanMap(fieldBeanMap);
        this.setUniqueCheckNums(uniqueCheckNums);
        this.setMustInputFields(mustInputNums);
        this.setIdToNumMap(idToNumMap);
        this.setDataEntityNumber(bizModelEntity);
    }

    private void setMemberScopes(FieldBean fieldBean, DynamicObject dyo) {
        DynamicObjectCollection memberScpoes = dyo.getDynamicObjectCollection("dimmembers");
        ArrayList<IDimensionMember> memberList = new ArrayList<IDimensionMember>(16);
        Object memberCache = EpbsMemberCacheHelper.get(this.getModelId(), fieldBean.getDimension().getId());
        if (CollectionUtils.isNotEmpty((Collection)memberScpoes)) {
            memberScpoes.forEach(ms -> {
                long memberId = ms.getLong("memberid");
                MemberBean member = memberCache.getMember(memberId);
                MemberBean parentMem = memberCache.getMember(member.getParentId());
                DynamicObject viewDyo = ms.getDynamicObject("view");
                int scope = Integer.parseInt(ms.getString("scope"));
                String parentNum = parentMem == null ? member.getNumber() : parentMem.getNumber();
                memberList.add(new DefaultDimMember(memberId, member.getNumber(), member.getNumber(), scope, viewDyo.getLong("id"), viewDyo.getString("number"), parentNum));
            });
        }
        fieldBean.setMemberScopes(memberList);
    }

    private void setDimension(FieldBean fieldBean, DynamicObject dyo, boolean isBizModel) {
        RelationDimBean dimBean = new RelationDimBean();
        dimBean.setId(dyo.getLong("dimensionid.id"));
        dimBean.setName(dyo.getString("dimensionid.name"));
        dimBean.setNumber(dyo.getString("dimensionid.number"));
        fieldBean.setDimension(dimBean);
        if (isBizModel) {
            dimBean.setViewIds(RelationModelBeanProvider.getViewIdsByFieldBean(this.getModelId(), fieldBean));
        }
    }

    private List<Long> getUniqueCheckIds(DynamicObject object) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        String message = object.getString("uniquecheck");
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            for (String s : message.split(",")) {
                ids.add(LongUtil.toLong((Object)s));
            }
        }
        return ids;
    }

    private List<String> getSimpleSelectProperties(boolean isBizModel) {
        ArrayList<String> selectProperties = new ArrayList<String>(16);
        selectProperties.add("id");
        selectProperties.add("number");
        selectProperties.add("name");
        if (isBizModel) {
            selectProperties.add("enable");
            selectProperties.add("cubenumber");
            selectProperties.add("model.id");
            selectProperties.add("model.number");
            selectProperties.add("businessdomainid.id");
            selectProperties.add("businessdomainid.number");
            selectProperties.add("uniquecheck");
            selectProperties.add("datamodelid");
        } else {
            selectProperties.add("description");
            selectProperties.add("type");
            selectProperties.add("basedataid.id");
            selectProperties.add("selectmodelid.id");
            selectProperties.add("dimensionid.id");
            selectProperties.add("dimensionid.number");
            selectProperties.add("dimensionid.name");
            selectProperties.add("ismustinput");
            selectProperties.add("isconnect");
            selectProperties.add("datatye");
            selectProperties.add("accuracy");
            selectProperties.add("dimmembers.memberid");
            selectProperties.add("dimmembers.scope");
            selectProperties.add("dimmembers.view");
        }
        return selectProperties;
    }
}

