/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.bean.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.BizModelDomainBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class RelationModelBeanProvider {
    public static RelationModelBean getRelationModelBeanByNum(long modelId, String bizNum) {
        return (RelationModelBean)EpbsThreadCache.get(modelId, "getRelationModelBeanByNum", bizNum, () -> new RelationModelBean(modelId, bizNum));
    }

    public static RelationModelBean getRelationModelBeanById(long modelId, long id) {
        return (RelationModelBean)EpbsThreadCache.get(modelId, "getRelationModelBeanById", id, () -> new RelationModelBean(modelId, id));
    }

    public static List<Long> getViewIdsByFieldBean(long modelId, FieldBean fieldBean) {
        ArrayList<Long> viewIds = new ArrayList<Long>(16);
        if (fieldBean.getDimension() != null) {
            String dimNum = fieldBean.getDimension().getNumber();
            EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
            Object dimension = modelCache.getDimension(dimNum);
            if (dimension != null) {
                if (fieldBean.getBizModelId() != 0L) {
                    BizModelDimBean bizModelDimBean;
                    Object bizModelBean = modelCache.getBizModelById(fieldBean.getBizModelId());
                    if (bizModelBean != null && (bizModelDimBean = ((BizModelBean)bizModelBean).getDimMap().get(((BaseBean)dimension).getId())) != null) {
                        viewIds.addAll(bizModelDimBean.getViewIds());
                    }
                } else {
                    Object modelDomainBean = modelCache.getBizModelDomainById(fieldBean.getBizModelDomainId());
                    if (modelDomainBean != null) {
                        viewIds.addAll((Collection<Long>)((BizModelDomainBean)modelDomainBean).getDimViewMap().get(((BaseBean)dimension).getId()));
                    }
                }
            }
        }
        return viewIds;
    }

    public static MemberBean getMemberBean(FieldBean fieldBean, long modelId, String number) {
        MemberBean memberBean = fieldBean.getBizModelId() != 0L ? (MemberBean)EpbsThreadCache.get(modelId, fieldBean.getBizModelId(), fieldBean.getDimension().getNumber(), number, () -> EpbsModelCacheHelper.get(modelId).getMemberByBizModel(fieldBean.getBizModelId(), fieldBean.getDimension().getNumber(), null, number)) : (MemberBean)EpbsThreadCache.get(modelId, fieldBean.getBizModelDomainId(), fieldBean.getDimension().getNumber(), number, () -> EpbsModelCacheHelper.get(modelId).getMemberByBizModelDomainId(fieldBean.getBizModelDomainId(), fieldBean.getDimension().getNumber(), null, number));
        return memberBean;
    }
}

