/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.epm.epbs.common.model.bean.DimTypeBean;

public class DimTypeCache {
    private Map<Long, DimTypeBean> dimTypeMap = new LinkedHashMap<Long, DimTypeBean>(16);

    public Map<Long, DimTypeBean> getDimTypeMap() {
        return this.dimTypeMap;
    }

    public static DimTypeCache get() {
        DimTypeCache dimTypeCache = new DimTypeCache();
        dimTypeCache.init();
        return dimTypeCache;
    }

    private DimTypeCache() {
    }

    public void init() {
        this.dimTypeMap = DimTypeBean.getDimTypeMap();
    }

    public DimTypeBean getDimTypeById(long id) {
        return this.dimTypeMap.get(id);
    }

    public DimTypeBean getDimType(String appNumber, String type) {
        for (DimTypeBean value : this.dimTypeMap.values()) {
            if (!Objects.equals(value.getAppNumber(), appNumber) || !Objects.equals(value.getType(), type)) continue;
            return value;
        }
        return null;
    }

    public List<DimTypeBean> getDimTypeByApp(String appNumber) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)16);
        for (DimTypeBean value : this.dimTypeMap.values()) {
            if (!Objects.equals(value.getAppNumber(), appNumber) || !"1".equals(value.getStatus())) continue;
            resultList.add(value);
        }
        return resultList;
    }
}

