/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BaseMemberBean;
import kd.epm.epbs.common.model.bean.BaseMemberFactory;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.MemberFactory;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class EpbsMemberCache {
    private long modelId = 0L;
    private long dimensionId = 0L;
    private Map<Long, BaseMemberBean> baseMemberMap = new LinkedHashMap<Long, BaseMemberBean>(16);
    private Map<Long, MemberBean> memberMap = new LinkedHashMap<Long, MemberBean>(16);
    private Map<Long, LinkedHashMap<Long, MemberBean>> viewMemberMap = new LinkedHashMap<Long, LinkedHashMap<Long, MemberBean>>(16);
    private Map<Long, LinkedHashMap<String, MemberBean>> viewIdMemberMap = new LinkedHashMap<Long, LinkedHashMap<String, MemberBean>>(16);

    public void init(long modelId, long dimensionId) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.baseMemberMap = new BaseMemberFactory().queryBeanMap(modelId, dimensionId);
        this.viewMemberMap = new MemberFactory().queryBeanMap(modelId, dimensionId, this.baseMemberMap);
        for (Map.Entry<Long, LinkedHashMap<Long, MemberBean>> entry : this.viewMemberMap.entrySet()) {
            Long viewId = entry.getKey();
            LinkedHashMap<Long, MemberBean> beanMap = entry.getValue();
            this.memberMap.putAll(beanMap);
            LinkedHashMap<String, MemberBean> numberMemberMap = new LinkedHashMap<String, MemberBean>(beanMap.size());
            for (Map.Entry<Long, MemberBean> memberBeanEntry : beanMap.entrySet()) {
                MemberBean memberBean = memberBeanEntry.getValue();
                numberMemberMap.put(memberBean.getNumber(), memberBean);
            }
            this.viewIdMemberMap.put(viewId, numberMemberMap);
        }
        this.memberMap = Collections.unmodifiableMap(this.memberMap);
        this.viewIdMemberMap = Collections.unmodifiableMap(this.viewIdMemberMap);
    }

    public Map<Long, MemberBean> getMemberMap() {
        return this.memberMap;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public Collection<MemberBean> getMembers(long viewId) {
        LinkedHashMap<Long, MemberBean> memberMap = this.viewMemberMap.get(viewId);
        if (memberMap != null) {
            return memberMap.values();
        }
        return new ArrayList<MemberBean>(10);
    }

    public MemberBean getRootMember(long viewId) {
        List members = this.getMembers(viewId).stream().filter(o -> o.getLevel() == 1).collect(Collectors.toList());
        if (!members.isEmpty()) {
            return (MemberBean)members.get(0);
        }
        return null;
    }

    public MemberBean getMember(long id) {
        return this.memberMap.get(id);
    }

    public List<MemberBean> getMembers(List<Long> ids) {
        ArrayList<MemberBean> members = new ArrayList<MemberBean>(ids.size());
        for (Long id : ids) {
            MemberBean member = this.getMember(id);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    public MemberBean getMember(long viewId, String number) {
        LinkedHashMap<String, MemberBean> memberMap = this.viewIdMemberMap.get(viewId);
        if (memberMap != null) {
            return memberMap.get(number);
        }
        return null;
    }

    public MemberBean getMember(String viewNumber, String number) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get(this.modelId);
        Object view = modelCache.getView(this.dimensionId, viewNumber);
        LinkedHashMap<String, MemberBean> memberMap = this.viewIdMemberMap.get(((BaseBean)view).getId());
        if (memberMap != null) {
            return memberMap.get(number);
        }
        return null;
    }

    public MemberBean getParent(long id) {
        MemberBean memberBean = this.getMember(id);
        if (memberBean != null) {
            return this.getMember(memberBean.getParentId());
        }
        return null;
    }

    public List<MemberBean> getAllChildIncludeSelf(long id) {
        return this.getMembers(id, RangeEnum.ALL);
    }

    public List<MemberBean> getMembers(Long id, RangeEnum rangeEnum) {
        MemberBean parent;
        MemberBean member = this.getMember(id);
        if (rangeEnum == RangeEnum.ONLY) {
            return Collections.singletonList(member);
        }
        if (rangeEnum == RangeEnum.DIRECTSUB_EXCLUDE) {
            return member.getChildren();
        }
        if (rangeEnum == RangeEnum.DIRECTSUB) {
            ArrayList<MemberBean> children = new ArrayList<MemberBean>(10);
            children.add(member);
            children.addAll(member.getChildren());
            return children;
        }
        if (rangeEnum == RangeEnum.ALL_EXCLUDE) {
            return member.getAllChildren();
        }
        if (rangeEnum == RangeEnum.ALL) {
            ArrayList<MemberBean> allChildren = new ArrayList<MemberBean>(10);
            allChildren.add(member);
            allChildren.addAll(member.getAllChildren());
            return allChildren;
        }
        if (rangeEnum == RangeEnum.ALL_DETAIL) {
            return member.getAllChildrenOnlyLeaf();
        }
        if (rangeEnum == RangeEnum.ALL_DETAIL_INCLUDE) {
            ArrayList<MemberBean> allChildrenOnlyLeaf = new ArrayList<MemberBean>(10);
            allChildrenOnlyLeaf.add(member);
            allChildrenOnlyLeaf.addAll(member.getAllChildrenOnlyLeaf());
            return allChildrenOnlyLeaf;
        }
        if (rangeEnum == RangeEnum.ALL_NOTDETAIL) {
            return member.getAllChildrenOnlyNotLeaf();
        }
        if (rangeEnum == RangeEnum.PEERS_EXCLUDE) {
            MemberBean parent2 = this.getMember(member.getParentId());
            if (parent2 != null) {
                ArrayList<MemberBean> children = new ArrayList<MemberBean>(parent2.getChildren());
                children.remove(member);
                return children;
            }
        } else if (rangeEnum == RangeEnum.PEERS && (parent = this.getMember(member.getParentId())) != null) {
            return parent.getChildren();
        }
        return new ArrayList<MemberBean>(10);
    }

    public List<MemberBean> getMembersByBaseMemberIds(List<Long> baseMemberIds, Long viewId) {
        ArrayList<MemberBean> members = new ArrayList<MemberBean>(baseMemberIds.size());
        if (baseMemberIds.isEmpty()) {
            return members;
        }
        for (Long baseMemberId : baseMemberIds) {
            BaseMemberBean baseMemberBean = this.baseMemberMap.get(baseMemberId);
            List<Long> treeMemberIds = baseMemberBean.getTreeMemberIds();
            members.addAll(this.getMembers(treeMemberIds));
        }
        if (viewId == null) {
            return members;
        }
        return members.stream().filter(o -> o.getViewId() == viewId.longValue()).collect(Collectors.toList());
    }
}

