/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.epm.epbs.common.cache.model.ModelCache;
import kd.epm.epbs.common.enums.AppDBRouteEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.BizModelDomainBean;
import kd.epm.epbs.common.model.bean.BizModelDomainFactory;
import kd.epm.epbs.common.model.bean.BizModelFactory;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.DimensionFactory;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ModelBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.ViewFactory;
import kd.epm.epbs.common.model.cache.DimTypeCache;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EpbsModelCache<T extends ModelBean, Domain extends BizModelDomainBean, BizModel extends BizModelBean, Dim extends DimensionBean, View extends ViewBean>
extends ModelCache<T> {
    private volatile Map<Long, Domain> bizModelDomainMap;
    private volatile Map<Long, BizModel> bizModelMap;
    private volatile Map<Long, Dim> dimensionMap;
    private volatile Map<Long, View> viewMap;
    private volatile Map<String, BizModel> numberBizModelMap;
    private volatile Map<String, Dim> numberDimensionMap;
    private volatile Map<Long, Map<String, View>> dimViewMap;
    private volatile Map<String, String> shortDimNum2DimNum;

    @Override
    public void init(DynamicObject dy) {
        this.initModel(dy);
        super.init(dy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Domain> getBizModelDomainMap() {
        if (this.bizModelDomainMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                this.bizModelDomainMap = new BizModelDomainFactory().queryBeansByModel((ModelBean)this.getModel());
            }
        }
        return this.bizModelDomainMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, BizModel> getBizModelMap() {
        if (this.bizModelMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                this.bizModelMap = new BizModelFactory().queryBeansByModel((ModelBean)this.getModel());
            }
        }
        return this.bizModelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Dim> getDimensionMap() {
        if (this.dimensionMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                this.dimensionMap = new DimensionFactory().queryBeansByModel((ModelBean)this.getModel());
            }
        }
        return this.dimensionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, View> getViewMap() {
        if (this.viewMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                this.viewMap = new ViewFactory().queryBeansByModel(this);
            }
        }
        return this.viewMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BizModel> getNumberBizModelMap() {
        if (this.numberBizModelMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                Map<Long, BizModel> bizModelMap = this.getBizModelMap();
                this.numberBizModelMap = new LinkedHashMap<String, BizModel>(bizModelMap.size());
                for (BizModelBean bean : bizModelMap.values()) {
                    this.numberBizModelMap.put(bean.getNumber(), bean);
                }
                this.numberBizModelMap = Collections.unmodifiableMap(this.numberBizModelMap);
            }
        }
        return this.numberBizModelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Dim> getNumberDimensionMap() {
        if (this.numberDimensionMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                Map<Long, Dim> dimensionMap = this.getDimensionMap();
                this.numberDimensionMap = new LinkedHashMap<String, Dim>(dimensionMap.size());
                for (DimensionBean bean : dimensionMap.values()) {
                    this.numberDimensionMap.put(bean.getNumber(), bean);
                }
                this.numberDimensionMap = Collections.unmodifiableMap(this.numberDimensionMap);
            }
        }
        return this.numberDimensionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<String, View>> getDimViewMap() {
        if (this.dimViewMap == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                Map<Long, View> viewMap = this.getViewMap();
                this.dimViewMap = new LinkedHashMap<Long, Map<String, View>>(this.getDimensionMap().size());
                for (ViewBean bean : viewMap.values()) {
                    Map numberViewMap = this.dimViewMap.computeIfAbsent(bean.getDimensionId(), k -> new LinkedHashMap(16));
                    numberViewMap.put(bean.getNumber(), bean);
                }
                this.dimViewMap = Collections.unmodifiableMap(this.dimViewMap);
            }
        }
        return this.dimViewMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getShortDimNum2DimNum() {
        if (this.shortDimNum2DimNum == null) {
            EpbsModelCache epbsModelCache = this;
            synchronized (epbsModelCache) {
                this.shortDimNum2DimNum = new LinkedHashMap<String, String>(this.dimensionMap.size());
                for (DimensionBean bean : this.dimensionMap.values()) {
                    this.shortDimNum2DimNum.put(bean.getShortNumber(), bean.getNumber());
                }
            }
        }
        return this.shortDimNum2DimNum;
    }

    protected void initModel(DynamicObject dy) {
        ModelBean modelBean = new ModelBean();
        modelBean.fillData(dy);
        this.setModel(modelBean);
    }

    public Domain getBizModelDomainById(long id) {
        return (Domain)((BizModelDomainBean)this.getBizModelDomainMap().get(id));
    }

    public BizModel getBizModelById(long id) {
        return (BizModel)((BizModelBean)this.getBizModelMap().get(id));
    }

    public BizModel getBizModelByNum(String number) {
        return (BizModel)((BizModelBean)this.getNumberBizModelMap().get(number));
    }

    public Dim getDimensionById(long id) {
        return (Dim)((DimensionBean)this.getDimensionMap().get(id));
    }

    public Dim getDimensionByViewId(long viewId) {
        ViewBean viewBean = (ViewBean)this.getViewMap().get(viewId);
        return (Dim)((DimensionBean)this.getDimensionMap().get(viewBean.getDimensionId()));
    }

    public View getViewById(long id) {
        return (View)((ViewBean)this.getViewMap().get(id));
    }

    public DimTypeBean getDimTypeByDimensionId(long dimensionId) {
        Dim dimension = this.getDimensionById(dimensionId);
        if (dimension != null) {
            return this.getDimTypeById(((DimensionBean)dimension).getDimTypeId());
        }
        return null;
    }

    public DimTypeBean getDimTypeById(long id) {
        DimTypeCache dimTypeCache = DimTypeCacheHelper.get();
        return dimTypeCache.getDimTypeById(id);
    }

    public String getMemberTreeModelByDimensionId(long id) {
        return this.getDimTypeByDimensionId(id).getMemberTreemodel();
    }

    public String getMemberTreeModelByDimensionNumber(String dimNumber) {
        return this.getDimTypeByDimensionId(((BaseBean)this.getDimension(dimNumber)).getId()).getMemberTreemodel();
    }

    public String getMetaDataEntity(String entityName) {
        return ((ModelBean)this.getModel()).getMetaDataEntity(entityName);
    }

    public ViewBean getDefaultView(long dimensionId) {
        Map<Long, Map<String, View>> dimViewMap = this.getDimViewMap();
        Map<String, View> viewMap = dimViewMap.get(dimensionId);
        if (viewMap != null) {
            for (ViewBean view : viewMap.values()) {
                if (!view.isDefault()) continue;
                return view;
            }
            return (ViewBean)viewMap.values().iterator().next();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9ed8\u8ba4\u89c6\u56fe\u3002", (String)"EpbsModelCache_1", (String)"epm-epbs-common", (Object[])new Object[0]));
    }

    public ViewBean getDefaultView(String dimNumber) {
        Dim dimension = this.getDimension(dimNumber);
        return this.getDefaultView(((BaseBean)dimension).getId());
    }

    public Dim getDimension(String number) {
        return (Dim)((DimensionBean)this.getNumberDimensionMap().get(number));
    }

    public View getView(long dimId, String viewNumber) {
        return this.getView(this.getDimensionById(dimId), viewNumber);
    }

    public View getView(String dimNumber, String viewNumber) {
        return this.getView(this.getDimension(dimNumber), viewNumber);
    }

    private View getView(Dim dimension, String viewNumber) {
        Map<String, View> viewMap;
        Map<Long, Map<String, View>> dimViewMap = this.getDimViewMap();
        if (dimension != null && dimViewMap != null && (viewMap = dimViewMap.get(((BaseBean)dimension).getId())) != null) {
            return (View)((ViewBean)viewMap.get(viewNumber));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"EpbsModelCache_2", (String)"epm-epbs-common", (Object[])new Object[0]));
    }

    public List<Dim> getDimensionsByDimType(DimTypeEnum dimTypeEnum) {
        ArrayList<DimensionBean> list = new ArrayList<DimensionBean>(10);
        for (Map.Entry<Long, Dim> entry : this.getDimensionMap().entrySet()) {
            DimensionBean dim = (DimensionBean)entry.getValue();
            DimTypeBean dimType = this.getDimTypeById(dim.getDimTypeId());
            if (!dimTypeEnum.getValue().equals(dimType.getType())) continue;
            list.add(dim);
        }
        return list;
    }

    public Set<MemberBean> getBizModelAllDimMembers(long bizModelId, String dimNumber) {
        String newDimNumber = dimNumber;
        if (this.getShortDimNum2DimNum().containsKey(dimNumber)) {
            newDimNumber = this.getShortDimNum2DimNum().get(dimNumber);
        }
        long dimId = ((BaseBean)this.getDimension(newDimNumber)).getId();
        Map<Long, BizModelDimBean> dimMap = ((BizModelBean)this.getBizModelMap().get(bizModelId)).getDimMap();
        BizModelDimBean bizModelDimBean = dimMap.get(dimId);
        HashSet<MemberBean> allMembers = new HashSet<MemberBean>();
        if (bizModelDimBean != null) {
            List<Long> viewIds = dimMap.get(dimId).getViewIds();
            viewIds.forEach(viewId -> allMembers.addAll(((EpbsMemberCache)EpbsMemberCacheHelper.get(((ModelBean)this.getModel()).getId(), dimId)).getMembers((long)viewId)));
        }
        return allMembers;
    }

    public DimTypeEnum getDimTypeEnumByDimNumber(String dimNumber) {
        Dim dimension = this.getDimension(dimNumber);
        DimTypeCache dimTypeCache = DimTypeCacheHelper.get();
        DimTypeBean dimTypeById = dimTypeCache.getDimTypeById(((DimensionBean)dimension).getDimTypeId());
        return DimTypeEnum.getDimType(dimTypeById.getType());
    }

    public MemberBean getDefaultMember(String bizModelNumber, String dimensionNumber, String viewNumber) {
        BizModel bizModel = this.getBizModelByNum(bizModelNumber);
        Dim dimension = this.getDimension(dimensionNumber);
        return this.getDefaultMember(bizModel, dimension, this.getView((Dim)dimensionNumber, viewNumber));
    }

    public MemberBean getDefaultMember(Long bizModelId, Long dimensionId, Long viewId) {
        BizModel bizModel = this.getBizModelById(bizModelId);
        Dim dimension = this.getDimensionById(dimensionId);
        ViewBean viewBean = (ViewBean)this.getViewMap().get(viewId);
        return this.getDefaultMember(bizModel, dimension, viewBean);
    }

    public MemberBean getDefaultMember(BizModel bizModel, Dim dimension, View viewBean) {
        String dimensionNumber = ((BaseBean)dimension).getNumber();
        DimTypeEnum dimTypeEnum = this.getDimTypeEnumByDimNumber(dimensionNumber);
        if (bizModel != null && dimension != null) {
            Object epbsMemberCache = EpbsMemberCacheHelper.get(((ModelBean)this.getModel()).getId(), ((BaseBean)dimension).getId());
            if (dimTypeEnum == DimTypeEnum.Version || dimTypeEnum == DimTypeEnum.Custom) {
                return ((EpbsMemberCache)epbsMemberCache).getMember(((BaseBean)viewBean).getId(), ((DimensionBean)dimension).getNoneMemberNumber());
            }
            return ((EpbsMemberCache)epbsMemberCache).getRootMember(((BaseBean)viewBean).getId());
        }
        return null;
    }

    public MemberBean getMemberByBizModel(long bizModelId, String dimensionNumber, String parentNumber, String number) {
        BizModelDimBean bizModelDimBean;
        BizModel bizModel = this.getBizModelById(bizModelId);
        Dim dimension = this.getDimension(dimensionNumber);
        if (dimension != null && bizModel != null && (bizModelDimBean = ((BizModelBean)bizModel).getDimMap().get(((BaseBean)dimension).getId())) != null) {
            return this.getMemberBean(bizModelDimBean.getViewIds(), ((BaseBean)dimension).getNumber(), parentNumber, number);
        }
        return null;
    }

    public MemberBean getMemberByBizModelDomainId(long bizModelDomainId, String dimNum, String parentNum, String number) {
        Domain bizModelDomainBean = this.getBizModelDomainById(bizModelDomainId);
        Dim dimBean = this.getDimension(dimNum);
        if (bizModelDomainBean != null && dimBean != null) {
            return this.getMemberBean(((BizModelDomainBean)bizModelDomainBean).getDimViewMap().get(((BaseBean)dimBean).getId()), ((BaseBean)dimBean).getNumber(), parentNum, number);
        }
        return null;
    }

    public MemberBean getMemberBean(List<Long> views, String dimNum, String parentNum, String number) {
        Dim dimBean;
        if (CollectionUtils.isNotEmpty(views) && (dimBean = this.getDimension(dimNum)) != null) {
            Object epbsMemberCache = EpbsMemberCacheHelper.get(((ModelBean)this.getModel()).getId(), ((BaseBean)dimBean).getId());
            for (Long viewId : views) {
                MemberBean parentMember;
                MemberBean member = ((EpbsMemberCache)epbsMemberCache).getMember(viewId, number);
                if (member == null || !StringUtils.isEmpty((CharSequence)parentNum) && (parentMember = ((EpbsMemberCache)epbsMemberCache).getMember(member.getParentId())) != null && !Objects.equals(parentMember.getNumber(), parentNum)) continue;
                return member;
            }
        }
        return null;
    }

    public MemberBean getRoot(String dimNumber, long viewId) {
        Dim dimension = this.getDimension(dimNumber);
        Object epbsMemberCache = EpbsMemberCacheHelper.get(((ModelBean)this.getModel()).getId(), ((BaseBean)dimension).getId());
        Collection<MemberBean> members = ((EpbsMemberCache)epbsMemberCache).getMembers(viewId);
        for (MemberBean member : members) {
            if (member.getLevel() != 1) continue;
            return member;
        }
        return null;
    }

    public DBRoute getAppDBRoute() {
        return AppDBRouteEnum.getDbRouteByApp(((ModelBean)this.getModel()).getSrcAppNum());
    }
}

