/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.epbs.common.enums.model.PropTypeEnum;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.MemberPropBean;
import kd.epm.epbs.common.model.bean.PropBean;
import kd.epm.epbs.common.model.bean.PropFactory;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;

public class EpbsPropCache {
    private long modelId;
    private long dimensionId;
    private Map<Long, PropBean> propMap = new LinkedHashMap<Long, PropBean>(16);
    private Map<String, PropBean> propNumberMap = new LinkedHashMap<String, PropBean>(16);
    private Map<Long, PropValueBean> propValueMap = new LinkedHashMap<Long, PropValueBean>(16);
    private Map<Long, List<MemberPropBean>> membrePropMap = new LinkedHashMap<Long, List<MemberPropBean>>(16);

    public void init(long modelId, long dimensionId) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.propMap = new PropFactory().queryBeanMap(modelId, dimensionId);
        for (PropBean propBean : this.propMap.values()) {
            Map<String, List<MemberPropBean>> memberPropBeanMap = propBean.getMemberPropBeanMap();
            for (List<MemberPropBean> memberPropBeanList : memberPropBeanMap.values()) {
                for (MemberPropBean memberPropBean : memberPropBeanList) {
                    List memberPropBeans = this.membrePropMap.computeIfAbsent(memberPropBean.getMemberId(), k -> new ArrayList(10));
                    memberPropBeans.add(memberPropBean);
                }
            }
            this.propValueMap.putAll(propBean.getPropValueBeanIdMap());
            this.propNumberMap.put(propBean.getNumber(), propBean);
        }
        this.propNumberMap = Collections.unmodifiableMap(this.propNumberMap);
        this.membrePropMap = Collections.unmodifiableMap(this.membrePropMap);
    }

    public Collection<PropBean> getProps() {
        return this.propMap.values();
    }

    public PropBean getProp(long propId) {
        return this.propMap.get(propId);
    }

    public PropBean getProp(String number) {
        return this.propNumberMap.get(number);
    }

    public PropValueBean getPropValue(long propValueId) {
        return this.propValueMap.get(propValueId);
    }

    public List<MemberPropBean> getMemberPropList(long memberId) {
        Object memberCache = EpbsMemberCacheHelper.get(this.modelId, this.dimensionId);
        MemberBean member = ((EpbsMemberCache)memberCache).getMember(memberId);
        if (member == null) {
            return new ArrayList<MemberPropBean>(10);
        }
        return this.membrePropMap.get(member.getBaseMemberBean().getId());
    }

    @Deprecated
    public List<MemberBean> getMembers(String propNumber, String propValue) {
        return this.getMembers(propNumber, propValue, 0L);
    }

    public List<MemberBean> getMembers(long propId, String propValue, long viewId) {
        PropBean prop = this.getProp(propId);
        return this.getMembers(prop, propValue, viewId);
    }

    public List<MemberBean> getMembers(String propNumber, String propValue, long viewId) {
        PropBean prop = this.getProp(propNumber);
        return this.getMembers(prop, propValue, viewId);
    }

    public List<MemberBean> getMembers(long propValueId, long viewId) {
        PropValueBean propValue = this.getPropValue(propValueId);
        if (propValue == null) {
            return new ArrayList<MemberBean>(10);
        }
        PropBean prop = this.getProp(propValue.getPropId());
        return this.getMembers(prop, propValueId, viewId);
    }

    private List<MemberBean> getMembers(PropBean prop, String propValue, long viewId) {
        List<MemberPropBean> memberPropBeans = new ArrayList<MemberPropBean>(10);
        if (prop != null) {
            PropValueBean propValueBean;
            PropTypeEnum propType = prop.getPropType();
            if (propType.isHasPropValue() && (propValueBean = prop.getPropValueBeanMap().get(propValue)) != null) {
                propValue = String.valueOf(propValueBean.getId());
            }
            memberPropBeans = prop.getMemberPropBeanMap().get(propValue);
        }
        return this.getMembers(memberPropBeans, viewId);
    }

    private List<MemberBean> getMembers(PropBean prop, long propValueId, long viewId) {
        if (prop == null) {
            return new ArrayList<MemberBean>(10);
        }
        List<MemberPropBean> memberPropBeans = prop.getMemberPropBeanMap().get(String.valueOf(propValueId));
        return this.getMembers(memberPropBeans, viewId);
    }

    private List<MemberBean> getMembers(List<MemberPropBean> memberPropBeans, long viewId) {
        if (memberPropBeans != null) {
            List<Long> baseMemberIds = memberPropBeans.stream().map(MemberPropBean::getMemberId).collect(Collectors.toList());
            Object memberCache = EpbsMemberCacheHelper.get(this.modelId, this.dimensionId);
            return ((EpbsMemberCache)memberCache).getMembersByBaseMemberIds(baseMemberIds, viewId);
        }
        return new ArrayList<MemberBean>(10);
    }
}

