/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.model.cache;

import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.factory.CacheGenFactory;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.util.ReflectUtils;

public class EpbsPropCacheHelper {
    private static final String EPBS_PROP_CACHE = "epbs_prop_cache";

    public static <R extends EpbsPropCache> R get(long modelId, long dimensionId) {
        return (R)CacheGenFactory.getMemberCache().getOrLoad(EPBS_PROP_CACHE + dimensionId, () -> {
            EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
            String srcAppNum = ((ModelBean)modelCache.getModel()).getSrcAppNum();
            String clazz = ConfigurationContext.INSTANCE.loadProp(srcAppNum, AppConfigPropEnum.PROP_CACHE_CLASS);
            EpbsPropCache o = (EpbsPropCache)ReflectUtils.newInstance(clazz);
            o.init(modelId, dimensionId);
            return o;
        });
    }

    public static <R extends EpbsPropCache> R get(long modelId, String dimensionNumber) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get(modelId);
        Object dimension = modelCache.getDimension(dimensionNumber);
        return EpbsPropCacheHelper.get(modelId, ((BaseBean)dimension).getId());
    }

    public static void invalidate(long dimensionId) {
        CacheGenFactory.getMemberCache().invalidateByKeys(EPBS_PROP_CACHE + dimensionId);
    }
}

