/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.mq.publisher;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.mq.broadcast.Configure;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.mq.MQMessage;
import kd.epm.epbs.common.mq.MQMessageTypeEnum;
import org.apache.commons.collections4.MapUtils;

public class BroadcastMessagePublisher {
    private static final String CLASS_BROADCAST_NAME = "kd.epm.epbs.business.mq.consumer.BroadcastConsumerFacade";
    private static final String METHOD_BROADCAST_NAME = "onMessage";
    private static final Set<String> APP_IDS = Sets.newHashSet((Object[])new String[]{"epbs"});
    private static final WatchLogger log = EpbsLogFactory.getWatchLogInstance(true, BroadcastMessagePublisher.class);

    public static void publishBroadcastMessage(MQMessage msg) {
        BroadcastMessagePublisher.broadcastMessage(CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, new Object[]{msg.genSendMQFormatMessage()});
    }

    public static void publishBroadcastMessageWithAppId(MQMessage msg, Set<String> appIds) {
        for (String appId : appIds) {
            if (Configure.getSupportBroadcastAppids().contains(appId)) {
                BroadcastMessagePublisher.broadcastMessageWithApp(appId, CLASS_BROADCAST_NAME, METHOD_BROADCAST_NAME, new Object[]{msg.genSendMQFormatMessage()});
                log.info(String.format("reloadDimensionCache broadcast message success. appId:%s", appId));
                continue;
            }
            log.error(String.format("reloadDimensionCache broadcast message error. appId:%s is not config", appId));
        }
    }

    private static void broadcastMessageWithApp(String appId, String className, String methodName, Object[] params) {
        BroadcastService.broadcastMessageWithApp((String)appId, (String)className, (String)methodName, (Object[])params);
    }

    private static void broadcastMessage(String className, String methodName, Object[] params) {
        BroadcastService.broadcastMessage((String)className, (String)methodName, (Object[])params);
    }

    public static void publish(MQMessageTypeEnum type, Map<String, Object> params) {
        MQMessage msg = new MQMessage(type);
        HashMap<String, Object> messageMap = new HashMap<String, Object>(16);
        messageMap.put("accountId", RequestContext.get().getAccountId());
        messageMap.put("tenantId", RequestContext.get().getTenantId());
        if (MapUtils.isNotEmpty(params)) {
            messageMap.putAll(params);
        }
        msg.setSendMessage(messageMap);
        if (Instance.isAppSplit()) {
            BroadcastMessagePublisher.publishBroadcastMessageWithAppId(msg, APP_IDS);
        } else {
            BroadcastMessagePublisher.publishBroadcastMessageWithAppId(msg, Sets.newHashSet((Object[])new String[]{"epbs"}));
        }
    }
}

