/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.mq.publisher;

import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.elasticsearch.LocalDateFormat;
import kd.epm.epbs.common.elasticsearch.bean.OlapAuditSummaryEvent;
import kd.epm.epbs.common.mq.MQMessage;
import kd.epm.epbs.common.mq.MQMessageTypeEnum;
import kd.epm.epbs.common.util.JSONUtils;

public class MQCommonPublisher {
    private static final Log LOG = LogFactory.getLog(MQCommonPublisher.class);
    public static final String MQ_REGION = "epm";
    public static final String MQ_QUEUE_COMMON = "kd.epm.epbs.common";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMessage(MQMessage msg, boolean isTranscation, String quename) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher(MQ_REGION, quename);
            if (isTranscation) {
                pub.publishInDbTranscation(null, (Object)msg.genSendMQFormatMessage());
            } else {
                pub.publish(msg.genSendMQFormatMessage());
            }
        }
    }

    public static void publishLog(MQMessage msg, boolean isTranscation) {
        MQCommonPublisher.publishMessage(msg, isTranscation, MQ_QUEUE_COMMON);
    }

    public static void publishAuditSummaryLog(OlapAuditSummaryEvent event) {
        if (null == event) {
            return;
        }
        LOG.debug("start send audit_log message, index: " + event.getEsIndex());
        if (null == event || StringUtils.isEmpty((String)event.getEsIndex())) {
            throw new IllegalArgumentException("param 'indexName' is empty");
        }
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Audit_Summary_Log);
        HashMap<String, Object> messageBody = new HashMap<String, Object>(4);
        messageBody.put("_esindex", event.getEsIndex());
        messageBody.put("content", JSONUtils.toJson(event, new LocalDateFormat()));
        msg.setSendMessage(messageBody);
        MQCommonPublisher.publishLog(msg, false);
        LOG.debug("audit_log send message success, index: " + event.getEsIndex());
    }
}

