/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.annotation.SDKIgnore;
import kd.epm.epbs.common.annotation.SDKMsService;
import kd.epm.epbs.common.util.ClassSearchUtil;
import kd.epm.epbs.common.util.ReflectUtils;

public class ServiceFactoryHelper {
    private static final Log log = LogFactory.getLog(ServiceFactoryHelper.class);

    public static Map<String, String> getServiceMap(String ... packageNames) {
        HashMap<String, String> serviceMap = new HashMap<String, String>(16);
        for (String packageName : packageNames) {
            List<String> clazzNames = ClassSearchUtil.getClazzName(packageName, true);
            for (String clazzName : clazzNames) {
                Class<?> clazz = ReflectUtils.getClazz(clazzName);
                if (!clazz.isAnnotationPresent(SDKMsService.class) || clazz.isAnnotationPresent(SDKIgnore.class)) continue;
                String alias = clazz.getAnnotation(SDKMsService.class).alias();
                if (StringUtils.isEmpty((String)alias)) {
                    Class<?>[] interfaces;
                    alias = IUpgradeService.class.isAssignableFrom(clazz) ? clazz.getSimpleName() : ((interfaces = clazz.getInterfaces()).length == 1 ? interfaces[0].getSimpleName() : clazz.getSimpleName());
                }
                serviceMap.put(alias, clazz.getName());
            }
        }
        return serviceMap;
    }
}

