/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.page;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.epm.epbs.common.page.CommandParam;
import kd.epm.epbs.common.util.EpbsOperationResult;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class InteractivePageUtil {
    private static final String PAGE_POOL = "pagePool";

    public static String getPageIdAndCache(IPageCache pageCache, String formId) {
        return InteractivePageUtil.getPageIdAndCache(pageCache, formId, false);
    }

    public static String getPageIdAndCache(IPageCache pageCache, String formId, boolean isDistinct) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get(PAGE_POOL);
        Map map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            if (isDistinct) {
                map.entrySet().removeIf(p -> Objects.equals(formId, p.getValue()));
            }
        }
        map.put(pageId, formId);
        pageCache.put(PAGE_POOL, SerializationUtils.toJsonString(map));
        return pageId;
    }

    public static Collection<String> getPageId(IPageCache pageCache, String formId) {
        ArrayList<String> list = new ArrayList<String>(1);
        String cache = pageCache.get(PAGE_POOL);
        if (cache != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            map.forEach((k, v) -> {
                if (v.equals(formId)) {
                    list.add((String)k);
                }
            });
        }
        return list;
    }

    public static void removePageIdAndCache(IPageCache pageCache, String formId) {
        String cache = pageCache.get(PAGE_POOL);
        if (cache != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            map.entrySet().removeIf(p -> Objects.equals(formId, p.getValue()));
            pageCache.put(PAGE_POOL, SerializationUtils.toJsonString((Object)map));
        }
    }

    public static void closePage(IFormView formView, String formId) {
        Map<String, String> pagePool = InteractivePageUtil.getPagePool(formView.getPageCache());
        pagePool.entrySet().removeIf(p -> {
            if (formId.equals(p.getValue())) {
                IFormView childFormView = formView.getView((String)p.getKey());
                if (childFormView != null) {
                    childFormView.close();
                    formView.sendFormAction(childFormView);
                }
                return true;
            }
            return false;
        });
        formView.getPageCache().put(PAGE_POOL, SerializationUtils.toJsonString(pagePool));
    }

    public static Map<String, String> getPagePool(IPageCache pageCache) {
        String cache = pageCache.get(PAGE_POOL);
        if (cache != null) {
            return (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        return new HashMap<String, String>(16);
    }

    public static void invoke(IFormView iFormView, CommandParam commandParam) {
        commandParam.getDispatcher().dispatch(iFormView, commandParam);
    }

    public static EpbsOperationResult invokeCustomEvent(IFormView iFormView, String targetFormId, String opKey, Object paraval) {
        iFormView.getPageCache().saveChanges();
        EpbsOperationResult reslut = new EpbsOperationResult();
        for (String pageId : InteractivePageUtil.getPageId(iFormView.getPageCache(), targetFormId)) {
            Object res;
            IFormView view = iFormView.getViewNoPlugin(pageId);
            if (view == null) continue;
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("methodName", "customEvent");
            ArrayList<Object> args = new ArrayList<Object>(3);
            args.add(opKey);
            args.add("epbsCustomEvent");
            if (paraval != null) {
                if (paraval instanceof String) {
                    args.add(paraval);
                } else {
                    args.add(JSON.toJSONString((Object)paraval));
                }
            }
            params.put("args", args);
            ArrayList<HashMap<String, Object>> paramsList = new ArrayList<HashMap<String, Object>>(1);
            paramsList.add(params);
            String paramsStr = SerializationUtils.toJsonString(paramsList);
            String appId = view.getFormShowParameter().getServiceAppId();
            String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
            DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
            String t = (String)service.invoke("kd.bos.service.ServiceFactory", "FormService", "batchInvokeAction", new Object[]{view.getPageId(), paramsStr});
            if (!StringUtils.isNotEmpty((CharSequence)t) || !((res = JSON.parse((String)t)) instanceof JSONArray)) continue;
            IClientViewProxy service1 = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
            ((JSONArray)res).removeIf(e -> {
                JSONObject o1 = (JSONObject)e;
                String actionName = o1.getString("a");
                if ("epbsCustomEvent".equals(actionName)) {
                    reslut.setData(o1.get((Object)"p"));
                    return true;
                }
                return false;
            });
            if (((JSONArray)res).isEmpty()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("actions", res);
            map.put("pageId", pageId);
            service1.addAction("sendDynamicFormAction", map);
        }
        return reslut;
    }
}

