/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.page.dispatcher;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.page.CommandParam;
import kd.epm.epbs.common.page.InteractivePageUtil;
import kd.epm.epbs.common.page.annotation.KdInteractMethod;
import kd.epm.epbs.common.page.dispatcher.IPageDispatcher;
import org.apache.commons.lang.reflect.MethodUtils;

public class MainPageDispatcher
implements IPageDispatcher {
    protected static final Log logger = LogFactory.getLog(MainPageDispatcher.class);

    @Override
    public void dispatch(IFormView curview, CommandParam com) {
        if (curview == null) {
            return;
        }
        FormViewPluginProxy curproxy = (FormViewPluginProxy)curview.getService(FormViewPluginProxy.class);
        if (curproxy == null) {
            return;
        }
        IPageCache pageCache = null;
        for (IFormPlugin pl : curproxy.getPlugIns()) {
            if (!AbstractFormPlugin.class.isAssignableFrom(pl.getClass())) continue;
            pageCache = ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).getPageCache();
        }
        if (pageCache == null) {
            return;
        }
        Map<String, String> map = InteractivePageUtil.getPagePool(pageCache);
        map.put(curview.getPageId(), curview.getFormShowParameter().getFormId());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IFormView cv;
            if (entry.getValue().equals(com.getSender()) || StringUtils.isNotEmpty((String)com.getReceiver()) && !com.getReceiver().equals(entry.getValue()) || (cv = curview.getView(entry.getKey())) == null) continue;
            FormViewPluginProxy proxy = (FormViewPluginProxy)cv.getService(FormViewPluginProxy.class);
            IPageCache finalPageCache = pageCache;
            proxy.getPlugIns().forEach(e -> {
                try {
                    Class[] classes = new Class[com.getParam().length];
                    for (int i = 0; i < com.getParam().length; ++i) {
                        classes[i] = com.getParam()[i].getClass();
                    }
                    Method method = MethodUtils.getMatchingAccessibleMethod(e.getClass(), (String)com.getMethodName(), (Class[])classes);
                    if (method != null && (method.isAnnotationPresent(KdInteractMethod.class) || MainPageDispatcher.checkClazz(e.getClass(), method)) && com.check(finalPageCache, (IFormPlugin)e)) {
                        com.addResult(method.invoke(e, com.getParam()));
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    logger.error((Throwable)ex);
                    throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
                }
            });
            curview.sendFormAction(cv);
        }
    }

    public static boolean checkClazz(Class clazz, Method method) {
        if (clazz == null || !clazz.getName().startsWith("kd.") || clazz.getName().startsWith("kd.bos")) {
            return false;
        }
        for (Method method2 : clazz.getMethods()) {
            if (!method2.getName().equals(method.getName()) || method2.getParameterCount() != method.getParameterCount() || !method2.isAnnotationPresent(KdInteractMethod.class)) continue;
            return true;
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            if (!MainPageDispatcher.checkClazz((Class)genericDeclaration, method)) continue;
            return true;
        }
        return MainPageDispatcher.checkClazz(clazz.getSuperclass(), method);
    }
}

