/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.constant.SystemSeparator;
import kd.epm.epdm.common.util.MetadataUtil;

public class EPMDVoucherProChange {
    private final Map<String, String> propertyToAlias;
    private final Map<String, String> aliasToPropertyName;
    private final Map<String, BasedataProp> namePropertyMap = new HashMap<String, BasedataProp>(16);

    public EPMDVoucherProChange() {
        this.propertyToAlias = this.getPropertyToAlias("epdm_voucher");
        this.aliasToPropertyName = MetadataUtil.getAliasToPropertyName("epdm_voucherdesc");
    }

    public QFilter[] changeFilterByArray(QFilter[] filters) {
        return this.changeFilter(Lists.newArrayList((Object[])filters)).toArray(new QFilter[0]);
    }

    public List<QFilter> changeFilter(List<QFilter> filters) {
        ArrayList<QFilter> rs = new ArrayList<QFilter>(16);
        for (QFilter filter : filters) {
            String property = filter.getProperty();
            if ("ftlike".equals(filter.getCP())) {
                Object value = filter.getValue();
                String valueStr = value.toString();
                String[] valueSplit = valueStr.split(SystemSeparator.S_SPLIT + "");
                String properties = valueSplit[0];
                String val = valueSplit[valueSplit.length - 1];
                String[] pArr = properties.split(",");
                StringJoiner propertyJoiner = new StringJoiner(",");
                for (String singleP : pArr) {
                    String newProperty = this.getNewProperty(singleP);
                    propertyJoiner.add(newProperty);
                }
                String newVal = propertyJoiner.toString() + SystemSeparator.S_SPLIT + val;
                rs.add(new QFilter(filter.getProperty(), filter.getCP(), (Object)newVal));
                continue;
            }
            if ("id".equalsIgnoreCase(property)) {
                rs.add(this.uniFilter(filter));
                continue;
            }
            String newProperty = this.getNewProperty(property);
            rs.add(new QFilter(newProperty, filter.getCP(), filter.getValue()));
        }
        return rs;
    }

    private QFilter uniFilter(QFilter filter) {
        String cp = filter.getCP();
        Object value = filter.getValue();
        if ("in".equals(cp)) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(16);
            if (value instanceof Collection) {
                for (Object valueSingle : (Collection)value) {
                    String[] split = valueSingle.toString().split("\u3000");
                    if (split.length != 3) continue;
                    list.add(new QFilter("numberrow", "=", (Object)split[0]).and("sourcesysrow", "=", (Object)split[1]).and("sourcestyperow", "=", (Object)split[2]));
                }
            }
            if (!list.isEmpty()) {
                QFilter remove = (QFilter)list.remove(0);
                for (QFilter qFilter : list) {
                    remove.or(qFilter);
                }
                return remove;
            }
        } else {
            String[] split = value.toString().split("\u3000");
            if (split.length == 3) {
                return new QFilter("numberrow", "=", (Object)split[0]).and("sourcesysrow", "=", (Object)split[1]).and("sourcestyperow", "=", (Object)split[2]);
            }
        }
        return null;
    }

    private String getNewProperty(String property) {
        if (!property.contains(".")) {
            String target = this.propertyToAlias.get(property);
            return this.aliasToPropertyName.get(target.toUpperCase(Locale.ROOT));
        }
        String[] split = property.split("\\.");
        if (split.length > 1) {
            String prefix = split[0];
            if (this.namePropertyMap.containsKey(prefix)) {
                String target = this.propertyToAlias.get(prefix);
                String pro = this.aliasToPropertyName.get(target.toUpperCase(Locale.ROOT));
                StringJoiner joiner = new StringJoiner(".");
                joiner.add(pro);
                for (int i = 1; i < split.length; ++i) {
                    joiner.add(split[i]);
                }
                return joiner.toString();
            }
            String proName = prefix + "." + split[1];
            String target = this.propertyToAlias.get(proName);
            String pro = this.aliasToPropertyName.get(target.toUpperCase(Locale.ROOT));
            StringJoiner joiner = new StringJoiner(".");
            joiner.add(pro);
            for (int i = 1; i < split.length; ++i) {
                joiner.add(split[i]);
            }
            return joiner.toString();
        }
        return null;
    }

    public String changeOrderBy(String orderBy) {
        return orderBy;
    }

    public final Map<String, String> getPropertyToAlias(String entityNumber) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        this.getPropertyToAlias("", map, properties);
        return map;
    }

    private void getPropertyToAlias(String prefix, Map<String, String> map, DataEntityPropertyCollection properties) {
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectType itemPropertyType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
                this.getPropertyToAlias(name, map, itemPropertyType.getProperties());
                continue;
            }
            String alias = property.getAlias();
            if (StringUtils.isEmpty((String)alias)) continue;
            String key = StringUtils.isNotEmpty((String)prefix) ? prefix + "." + name : name;
            map.put(key, alias);
            if (!(property instanceof BasedataProp)) continue;
            this.namePropertyMap.put(key, (BasedataProp)property);
        }
    }
}

