/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.service;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.util.ExportUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportBillListService {
    private static final Log log = LogFactory.getLog(ExportBillListService.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.###############");
    private static final String SHEET_NAME = "sheet1";
    private final String expFileName;
    protected final Set<String> selectFields;
    protected final List<QFilter> filters;
    protected final List<String> listFieldKeys;
    protected final Map<String, BiConsumer<Row, SXSSFCell>> userActions;
    protected final BillList billList;
    protected int currentRow;
    protected final Set<String> decimalField;
    private final SXSSFWorkbook workBook;

    public static void exportConfirm(BillList billList, ConfirmCallBackListener confirmCallBackListener, Consumer<QFilter[]> dealQFilter) {
        Set collect = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            billList.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u51fa\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\uff1f", (String)"ExportBillListService_1", (String)"epm-epbs-common", (Object[])new Object[0]), collect.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        EntityType entityType = billList.getEntityType();
        FilterParameter parameter = billList.generalFilterParameter();
        List qFilters = parameter.getQFilters();
        dealQFilter.accept(qFilters.toArray(new QFilter[0]));
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        String name = primaryKey.getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityType.getName(), (String)name, (QFilter[])qFilters.toArray(new QFilter[0]));
        int size = query.size();
        billList.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u51fa\u5217\u8868\u5171%1$s\u6761\u8bb0\u5f55\uff1f", (String)"ExportBillListService_2", (String)"epm-epbs-common", (Object[])new Object[0]), size), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public List<QFilter> getFilters() {
        return this.filters;
    }

    public ExportBillListService(BillList billList, String expFileName) {
        this.billList = billList;
        this.expFileName = expFileName;
        this.listFieldKeys = new LinkedList<String>();
        this.filters = new LinkedList<QFilter>();
        this.selectFields = new HashSet<String>(16);
        this.currentRow = 0;
        this.workBook = new SXSSFWorkbook(10000);
        this.userActions = new HashMap<String, BiConsumer<Row, SXSSFCell>>(16);
        this.decimalField = new HashSet<String>(16);
        this.initFilters(billList);
    }

    public void addUserActions(String colNumber, BiConsumer<Row, SXSSFCell> action) {
        this.userActions.put(colNumber, action);
    }

    public void addSelectFields(String ... fields) {
        this.selectFields.addAll(Arrays.asList(fields));
    }

    private void initFilters(BillList billList) {
        EntityType entityType = billList.getEntityType();
        Set selectedPrimaryKeys = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (!selectedPrimaryKeys.isEmpty()) {
            String idProp = entityType.getPrimaryKey().getName();
            QFilter qFilter = new QFilter(idProp, "in", selectedPrimaryKeys);
            this.filters.add(qFilter);
        } else {
            FilterParameter parameter = billList.generalFilterParameter();
            List qFilters = parameter.getQFilters();
            this.filters.addAll(qFilters);
        }
    }

    public void dealCommonBaseDataFilter() {
    }

    public void queryData() {
        CellStyle cellStyle = this.getDefaultCellStyle(this.workBook);
        EntityType entityType = this.billList.getEntityType();
        String entityName = entityType.getName();
        SXSSFSheet sheet = this.newSheet();
        Map<String, String> fieldKeyRealFieldMap = this.buildSelectFields();
        this.doQuery(cellStyle, entityName, sheet, fieldKeyRealFieldMap);
    }

    public void doQuery(CellStyle cellStyle, String entityName, SXSSFSheet sheet, Map<String, String> fieldKeyRealFieldMap) {
        int count = 0;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BillListExport" + entityName, entityName, String.join((CharSequence)",", this.selectFields), this.filters.toArray(new QFilter[0]), this.billList.getOrderBy(), 1000000);){
            while (ds.hasNext()) {
                Row row = ds.next();
                SXSSFRow sheetRow = sheet.createRow(++this.currentRow);
                for (int i = 0; i < this.listFieldKeys.size(); ++i) {
                    String fieldKey = this.listFieldKeys.get(i);
                    String realField = fieldKeyRealFieldMap.get(fieldKey);
                    SXSSFCell cell = sheetRow.createCell(i);
                    cell.setCellStyle(cellStyle);
                    BiConsumer<Row, SXSSFCell> cellBiConsumer = this.userActions.get(fieldKey);
                    if (cellBiConsumer != null) {
                        cellBiConsumer.accept(row, cell);
                        continue;
                    }
                    if (realField == null) continue;
                    String value = this.decimalField.contains(fieldKey) ? this.getFormat(row, realField) : row.getString(realField);
                    cell.setCellValue(value);
                }
                SXSSFCell cellIndex = sheetRow.getCell(0);
                cellIndex = cellIndex == null ? sheetRow.createCell(0) : cellIndex;
                cellIndex.setCellValue((double)(++count));
                cellIndex.setCellStyle(cellStyle);
            }
        }
    }

    public String getFormat(Row row, String realField) {
        String format = DECIMAL_FORMAT.format(row.getBigDecimal(realField));
        return "0".equals(format) ? null : format;
    }

    private void autoColumnWidth(SXSSFSheet sheet) {
        for (int col = 0; col <= this.listFieldKeys.size(); ++col) {
            int maxWidth = 0;
            for (int row = 1; row < this.currentRow && row < sheet.getLastRowNum(); ++row) {
                int cellWidth;
                Cell cell;
                SXSSFRow sheetRow = sheet.getRow(row);
                if (sheetRow == null || (cell = sheetRow.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)) == null || cell.getCellType() != CellType.STRING) continue;
                String value = cell.getStringCellValue();
                int n = cellWidth = this.containsChinese(value) ? value.length() * 2 : value.length();
                if (cellWidth <= maxWidth) continue;
                maxWidth = cellWidth;
            }
            if ((maxWidth = Math.min(maxWidth, 100)) <= 0) continue;
            sheet.setColumnWidth(col, (maxWidth + 4) * 256);
        }
    }

    private boolean containsChinese(String str) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public Map<String, String> buildSelectFields() {
        EntityType entityType = this.billList.getEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, DataEntityPropertyCollection> collect = properties.stream().filter(EntryProp.class::isInstance).map(EntryProp.class::cast).collect(Collectors.toMap(DynamicProperty::getName, p -> p.getDynamicCollectionItemPropertyType().getProperties()));
        HashMap<String, String> fieldKeyRealFieldList = new HashMap<String, String>(this.listFieldKeys.size());
        for (String fieldKey : this.listFieldKeys) {
            String[] split = fieldKey.split("\\.");
            String fieldName = split[0];
            String laseFieldName = split.length > 1 ? split[1] : "";
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldName);
            if (property != null && !"".equals(property.getAlias()) || collect.containsKey(fieldName) && !"".equals(((IDataEntityProperty)collect.get(fieldName).get((Object)laseFieldName)).getAlias())) {
                this.selectFields.add(fieldKey);
                fieldKeyRealFieldList.put(fieldKey, fieldKey);
            }
            collect.entrySet().stream().filter(entry -> ((DataEntityPropertyCollection)entry.getValue()).containsKey((Object)fieldName) && !"".equals(((IDataEntityProperty)((DataEntityPropertyCollection)entry.getValue()).get((Object)fieldName)).getAlias())).findFirst().ifPresent(entry -> {
                String realField = (String)entry.getKey() + "." + fieldKey;
                this.selectFields.add(realField);
                fieldKeyRealFieldList.put(fieldKey, realField);
            });
        }
        return fieldKeyRealFieldList;
    }

    public void export() {
        SXSSFSheet sheet = this.workBook.getSheet(this.getSheetName());
        this.autoColumnWidth(sheet);
        try {
            String url = ExportUtil.writeFile((Workbook)this.workBook, this.expFileName);
            this.billList.getView().download(url);
        }
        catch (IOException e) {
            String format = String.format(ResManager.loadKDString((String)"%1$s\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ExportBillListService_3", (String)"epm-epbs-common", (Object[])new Object[0]), this.expFileName);
            log.error(format);
            throw new KDBizException(format);
        }
    }

    private SXSSFSheet newSheet() {
        SXSSFSheet sheet = this.workBook.createSheet(this.getSheetName());
        this.initTitle(sheet);
        List<Map<String, Object>> listFieldsControlColumns = this.getListFieldsControlColumns();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("caption", "#");
        map.put("visible", "11");
        map.put("listFieldKey", "");
        listFieldsControlColumns.add(0, map);
        LinkedList<Tuple<SXSSFCell, Integer>> cells = new LinkedList<Tuple<SXSSFCell, Integer>>();
        int headRowNum = 1;
        this.currentRow = this.createHeadList(sheet, listFieldsControlColumns, headRowNum, cells);
        int maxCol = 0;
        for (Tuple tuple : cells) {
            CellRangeAddress re;
            SXSSFCell cell = (SXSSFCell)tuple.item1;
            Integer range = (Integer)tuple.item2;
            int rowIndex = cell.getRowIndex();
            int columnIndex = cell.getColumnIndex();
            maxCol = Math.max(maxCol, columnIndex);
            if (cell.getStringCellValue() == null) continue;
            if (range == 0 && this.currentRow > cell.getRowIndex()) {
                re = new CellRangeAddress(rowIndex, rowIndex + this.currentRow - headRowNum, columnIndex, columnIndex);
                sheet.addMergedRegion(re);
            }
            if (range == 0) continue;
            re = new CellRangeAddress(rowIndex, rowIndex, columnIndex, columnIndex + range);
            sheet.addMergedRegion(re);
        }
        CellRangeAddress re = new CellRangeAddress(0, 0, 0, maxCol);
        sheet.addMergedRegion(re);
        this.setHeadCellStyle(sheet, maxCol);
        return sheet;
    }

    private List<Map<String, Object>> getListFieldsControlColumns() {
        List listFieldsControlColumns = this.billList.getListFieldsControlColumns();
        if (!listFieldsControlColumns.isEmpty()) {
            return listFieldsControlColumns;
        }
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        List showListColumns = this.billList.getShowListColumns();
        HashSet<String> selected = new HashSet<String>(showListColumns.size());
        for (IListColumn showListColumn : showListColumns) {
            Container parent = showListColumn.getParent();
            if (parent instanceof ListColumnGroup) {
                ListColumnGroup listColumnGroup = (ListColumnGroup)parent;
                String listFieldKey = listColumnGroup.getListFieldKey();
                if (!selected.add(listFieldKey)) continue;
                List items = listColumnGroup.getItems();
                HashMap<String, Object> groupMap = new HashMap<String, Object>();
                LinkedList<Map<String, Object>> itemMap = new LinkedList<Map<String, Object>>();
                for (Control item : items) {
                    if (!(item instanceof IListColumn)) continue;
                    Map<String, Object> col = this.columnToMap((IListColumn)item);
                    itemMap.add(col);
                }
                groupMap.put("caption", listColumnGroup.getName().getLocaleValue());
                groupMap.put("items", itemMap);
                groupMap.put("visible", listColumnGroup.getVisible());
                list.add(groupMap);
                continue;
            }
            Map<String, Object> col = this.columnToMap(showListColumn);
            list.add(col);
        }
        return list;
    }

    private Map<String, Object> columnToMap(IListColumn showListColumn) {
        LinkedHashMap<String, Object> col = new LinkedHashMap<String, Object>();
        int visible = showListColumn.getVisible();
        col.put("visible", visible);
        String textAlign = showListColumn.getTextAlign();
        col.put("textAlign", textAlign);
        LocaleString width = showListColumn.getWidth();
        col.put("width", width);
        String caption = showListColumn.getCaption().getLocaleValue();
        col.put("caption", caption);
        String listFieldKey = showListColumn.getListFieldKey();
        col.put("listFieldKey", listFieldKey);
        boolean fixed = showListColumn.isFixed();
        col.put("fixed", fixed);
        String className = showListColumn.getClass().getName();
        col.put("class", className);
        int seq = showListColumn.getSeq();
        col.put("seq", seq);
        return col;
    }

    private void setHeadCellStyle(SXSSFSheet sheet, int maxCol) {
        CellStyle style = this.getDefaultCellStyle(this.workBook);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int i = 0; i <= this.currentRow; ++i) {
            SXSSFRow sheetRow = sheet.getRow(i);
            for (int j = 0; j <= maxCol; ++j) {
                SXSSFCell cell = sheetRow.getCell(j, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                cell.setCellStyle(style);
            }
        }
    }

    private void initTitle(SXSSFSheet sheet) {
        SXSSFRow row = sheet.createRow(this.currentRow++);
        SXSSFCell cell = row.createCell(0, CellType.STRING);
        EntityType entityType = this.billList.getEntityType();
        cell.setCellValue(entityType.getDisplayName() + " " + entityType.getName());
    }

    private String getSheetName() {
        return SHEET_NAME;
    }

    private CellStyle getDefaultCellStyle(SXSSFWorkbook workBook) {
        CellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        return style;
    }

    private int createHeadList(SXSSFSheet sheet, List<Map<String, Object>> columns, int currentDeep, List<Tuple<SXSSFCell, Integer>> cells) {
        int maxDeep = -1;
        int tartCol = 0;
        for (Map<String, Object> itemMap : columns) {
            Tuple<Integer, Integer> cellPair = this.createCell(itemMap, sheet, tartCol, currentDeep, maxDeep, cells);
            tartCol = (Integer)cellPair.item1;
            maxDeep = (Integer)cellPair.item2;
        }
        return maxDeep;
    }

    private Tuple<Integer, Integer> createCell(Map<?, ?> cellConfig, SXSSFSheet sheet, int targetCol, int currentDeep, int maxDeep, List<Tuple<SXSSFCell, Integer>> cells) {
        SXSSFRow row;
        int nextCol = targetCol;
        if (maxDeep < currentDeep) {
            maxDeep = currentDeep;
            row = sheet.createRow(currentDeep);
        } else {
            row = sheet.getRow(currentDeep);
        }
        String caption = (String)cellConfig.get("caption");
        Object items = cellConfig.get("items");
        Object visible = cellConfig.get("visible");
        int i = Integer.parseInt(visible.toString());
        if ((i & 1) == 0) {
            return new Tuple((Object)nextCol, (Object)maxDeep);
        }
        if (items instanceof List) {
            List itemsList = (List)items;
            for (Object item : itemsList) {
                if (!(item instanceof Map)) continue;
                Map itemMap = (Map)item;
                Tuple<Integer, Integer> cellPair = this.createCell(itemMap, sheet, nextCol, currentDeep + 1, maxDeep, cells);
                nextCol = (Integer)cellPair.item1;
                maxDeep = (Integer)cellPair.item2;
            }
            if (nextCol > targetCol) {
                SXSSFCell cell = row.createCell(targetCol, CellType.STRING);
                cell.setCellValue(caption);
                cells.add((Tuple<SXSSFCell, Integer>)new Tuple((Object)cell, (Object)(itemsList.size() - 1)));
            }
        } else {
            SXSSFCell cell = row.createCell(targetCol, CellType.STRING);
            cell.setCellValue(caption);
            CreationHelper factory = this.workBook.getCreationHelper();
            SXSSFDrawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex());
            anchor.setCol2(cell.getColumnIndex() + 1);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 1);
            Comment comment = drawing.createCellComment(anchor);
            String listFieldKey = (String)cellConfig.get("listFieldKey");
            this.listFieldKeys.add(listFieldKey);
            if ("kd.bos.list.DecimalListColumn".equals(cellConfig.get("class"))) {
                this.decimalField.add(listFieldKey);
            }
            comment.setString(factory.createRichTextString(listFieldKey));
            cell.setCellComment(comment);
            cells.add((Tuple<SXSSFCell, Integer>)new Tuple((Object)cell, (Object)0));
            ++nextCol;
        }
        return new Tuple((Object)nextCol, (Object)maxDeep);
    }
}

