/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.service;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.list.BillList;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.service.EPMDVoucherProChange;
import kd.epm.epbs.common.service.ExportBillListService;
import kd.epm.epdm.common.util.MetadataUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExportVoucherService
extends ExportBillListService {
    public static final int MAX_EXPORT_DATA_NUM = 1048570;

    public static void exportConfirm(BillList billList, ConfirmCallBackListener confirmCallBackListener, Consumer<QFilter[]> dealQFilter) {
        Set collect = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            billList.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u51fa\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\uff1f", (String)"ExportVoucherService_1", (String)"epm-epbs-common", (Object[])new Object[0]), collect.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        EntityType entityType = billList.getEntityType();
        FilterParameter parameter = billList.generalFilterParameter();
        List<QFilter> qFilters = parameter.getQFilters();
        dealQFilter.accept(qFilters.toArray(new QFilter[0]));
        EPMDVoucherProChange change = new EPMDVoucherProChange();
        qFilters = change.changeFilter(qFilters);
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        String name = primaryKey.getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epdm_voucherdesc", (String)name, (QFilter[])qFilters.toArray(new QFilter[0]));
        int size = query.size();
        if (size > 1048570) {
            billList.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7531\u4e8eexcel\u8868\u9650\u5236\uff0c\u76ee\u524d\u6700\u591a\u5bfc\u51fa%1$s\u6761\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ExportVoucherService_2", (String)"epm-epbs-common", (Object[])new Object[0]), 1048570), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else {
            billList.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u51fa\u5217\u8868\u5171%1$s\u6761\u8bb0\u5f55\uff1f", (String)"ExportVoucherService_3", (String)"epm-epbs-common", (Object[])new Object[0]), size), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public ExportVoucherService(BillList billList, String expFileName) {
        super(billList, expFileName);
    }

    @Override
    public Map<String, String> buildSelectFields() {
        EntityType entityType = this.billList.getEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        Map<String, DataEntityPropertyCollection> collect = properties.stream().filter(EntryProp.class::isInstance).map(EntryProp.class::cast).collect(Collectors.toMap(DynamicProperty::getName, p -> p.getDynamicCollectionItemPropertyType().getProperties()));
        Map<String, String> aliasToPropertyName = MetadataUtil.getAliasToPropertyName("epdm_voucherdesc");
        HashMap<String, String> fieldKeyRealFieldList = new HashMap<String, String>(this.listFieldKeys.size());
        for (String fieldKey : this.listFieldKeys) {
            String alias;
            String[] split = fieldKey.split("\\.");
            String fieldName = split[0];
            String laseFieldName = split.length > 1 ? split[1] : "";
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldName);
            if (property != null && !"".equals(alias = property.getAlias()) || collect.containsKey(fieldName) && !"".equals(alias = ((IDataEntityProperty)collect.get(fieldName).get((Object)laseFieldName)).getAlias())) {
                String selectField = aliasToPropertyName.get(alias.toUpperCase(Locale.ROOT));
                this.selectFields.add(selectField);
                fieldKeyRealFieldList.put(fieldKey, selectField);
            }
            collect.entrySet().stream().filter(entry -> ((DataEntityPropertyCollection)entry.getValue()).containsKey((Object)fieldName) && !"".equals(((IDataEntityProperty)((DataEntityPropertyCollection)entry.getValue()).get((Object)fieldName)).getAlias())).findFirst().ifPresent(entry -> {
                String aliasRow = ((IDataEntityProperty)((DataEntityPropertyCollection)entry.getValue()).get((Object)fieldName)).getAlias();
                String selectField = (String)aliasToPropertyName.get(aliasRow.toUpperCase(Locale.ROOT));
                this.selectFields.add(selectField);
                fieldKeyRealFieldList.put(fieldKey, selectField);
            });
        }
        return fieldKeyRealFieldList;
    }

    @Override
    public void doQuery(CellStyle cellStyle, String entityName, SXSSFSheet sheet, Map<String, String> fieldKeyRealFieldMap) {
        int count = 0;
        ORM orm = ORM.create();
        entityName = "epdm_voucherdesc";
        List<QFilter> filters = this.filters;
        String orderBy = this.billList.getOrderBy();
        EPMDVoucherProChange change = new EPMDVoucherProChange();
        filters = change.changeFilter(filters);
        orderBy = change.changeOrderBy(orderBy);
        try (DataSet ds = orm.queryDataSet("BillListExport" + entityName, entityName, String.join((CharSequence)",", this.selectFields), filters.toArray(new QFilter[0]), orderBy, 1048570);){
            while (ds.hasNext()) {
                Row row = ds.next();
                SXSSFRow sheetRow = sheet.createRow(++this.currentRow);
                for (int i = 0; i < this.listFieldKeys.size(); ++i) {
                    String fieldKey = (String)this.listFieldKeys.get(i);
                    String realField = fieldKeyRealFieldMap.get(fieldKey);
                    SXSSFCell cell = sheetRow.createCell(i);
                    cell.setCellStyle(cellStyle);
                    BiConsumer cellBiConsumer = (BiConsumer)this.userActions.get(fieldKey);
                    if (cellBiConsumer != null) {
                        cellBiConsumer.accept(row, cell);
                        continue;
                    }
                    if (realField == null) continue;
                    String value = this.decimalField.contains(fieldKey) ? this.getFormat(row, realField) : row.getString(realField);
                    cell.setCellValue(value);
                }
                SXSSFCell cellIndex = sheetRow.getCell(0);
                cellIndex = cellIndex == null ? sheetRow.createCell(0) : cellIndex;
                cellIndex.setCellValue((double)(++count));
                cellIndex.setCellStyle(cellStyle);
            }
        }
    }
}

