/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.thread;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.epm.epbs.common.thread.EpbsThreadPools;

public class EpbsFuture<T>
implements Future<T>,
CompletionStage<T> {
    private static final Executor asyncPool = EpbsThreadPools::commonExecute;
    private final CompletableFuture<T> completableFuture;

    private EpbsFuture(CompletableFuture<T> future) {
        this.completableFuture = future;
    }

    public static <U> EpbsFuture<U> supplyAsync(Supplier<U> supplier) {
        return new EpbsFuture<U>(CompletableFuture.supplyAsync(supplier, asyncPool));
    }

    public static <U> EpbsFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return new EpbsFuture<U>(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static EpbsFuture<Void> runAsync(Runnable runnable) {
        return new EpbsFuture<Void>(CompletableFuture.runAsync(runnable, asyncPool));
    }

    public static EpbsFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return new EpbsFuture<Void>(CompletableFuture.runAsync(runnable, executor));
    }

    public static <U> EpbsFuture<U> completedFuture(U value) {
        return new EpbsFuture<U>(CompletableFuture.completedFuture(value));
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.completableFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.completableFuture.get(timeout, unit);
    }

    public T join() {
        return this.completableFuture.join();
    }

    public T getNow(T valueIfAbsent) {
        return this.completableFuture.getNow(valueIfAbsent);
    }

    public boolean complete(T value) {
        return this.completableFuture.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.completableFuture.completeExceptionally(ex);
    }

    @Override
    public <U> EpbsFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenApply(fn));
    }

    @Override
    public <U> EpbsFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenApplyAsync(fn, asyncPool));
    }

    @Override
    public <U> EpbsFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.thenApplyAsync(fn, executor));
    }

    public EpbsFuture<Void> thenAccept(Consumer<? super T> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAccept((Consumer)action));
    }

    public EpbsFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptAsync((Consumer)action, asyncPool));
    }

    public EpbsFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptAsync((Consumer)action, executor));
    }

    public EpbsFuture<Void> thenRun(Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRun(action));
    }

    public EpbsFuture<Void> thenRunAsync(Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRunAsync(action, asyncPool));
    }

    public EpbsFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> EpbsFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenCombine(other, fn));
    }

    @Override
    public <U, V> EpbsFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenCombineAsync(other, fn, asyncPool));
    }

    @Override
    public <U, V> EpbsFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.thenCombineAsync(other, fn, executor));
    }

    public <U> EpbsFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBoth(other, (BiConsumer)action));
    }

    public <U> EpbsFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBothAsync(other, (BiConsumer)action, asyncPool));
    }

    public <U> EpbsFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.thenAcceptBothAsync(other, (BiConsumer)action, executor));
    }

    public EpbsFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBoth((CompletionStage)other, action));
    }

    public EpbsFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBothAsync((CompletionStage)other, action, asyncPool));
    }

    public EpbsFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> EpbsFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new EpbsFuture<T>(this.completableFuture.applyToEither((CompletionStage)other, fn));
    }

    @Override
    public <U> EpbsFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return new EpbsFuture<T>(this.completableFuture.applyToEitherAsync((CompletionStage)other, fn, asyncPool));
    }

    @Override
    public <U> EpbsFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.applyToEitherAsync((CompletionStage)other, fn, executor));
    }

    public EpbsFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEither((CompletionStage)other, (Consumer)action));
    }

    public EpbsFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEitherAsync((CompletionStage)other, (Consumer)action, asyncPool));
    }

    public EpbsFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    public EpbsFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEither((CompletionStage)other, action));
    }

    public EpbsFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEitherAsync((CompletionStage)other, action, asyncPool));
    }

    public EpbsFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return new EpbsFuture<Void>((CompletableFuture<Void>)this.completableFuture.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> EpbsFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenCompose(fn));
    }

    @Override
    public <U> EpbsFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return new EpbsFuture<T>(this.completableFuture.thenComposeAsync(fn, asyncPool));
    }

    @Override
    public <U> EpbsFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.thenComposeAsync(fn, executor));
    }

    @Override
    public EpbsFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return new EpbsFuture<T>(this.completableFuture.whenComplete(action));
    }

    @Override
    public EpbsFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return new EpbsFuture<T>(this.completableFuture.whenCompleteAsync(action, asyncPool));
    }

    @Override
    public EpbsFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.whenCompleteAsync(action, executor));
    }

    @Override
    public <U> EpbsFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new EpbsFuture<T>(this.completableFuture.handle(fn));
    }

    @Override
    public <U> EpbsFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new EpbsFuture<T>(this.completableFuture.handleAsync(fn, asyncPool));
    }

    @Override
    public <U> EpbsFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return new EpbsFuture<T>(this.completableFuture.handleAsync(fn, executor));
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.completableFuture;
    }

    @Override
    public EpbsFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return new EpbsFuture<T>(this.completableFuture.exceptionally(fn));
    }

    public static EpbsFuture<Void> allOf(EpbsFuture<?> ... cfs) {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(cfs).map(future -> future.completableFuture).distinct().toArray(CompletableFuture[]::new);
        return new EpbsFuture<Void>(CompletableFuture.allOf(futures));
    }

    public static EpbsFuture<Object> anyOf(EpbsFuture<?> ... cfs) {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(cfs).map(future -> future.completableFuture).distinct().toArray(CompletableFuture[]::new);
        return new EpbsFuture<Object>(CompletableFuture.anyOf(futures));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.completableFuture.isCancelled();
    }

    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    public void obtrudeValue(T value) {
        this.completableFuture.obtrudeValue(value);
    }

    public void obtrudeException(Throwable ex) {
        this.completableFuture.obtrudeException(ex);
    }

    public int getNumberOfDependents() {
        return this.completableFuture.getNumberOfDependents();
    }
}

