/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.thread;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class EpbsThreadPools {
    private static final Log log = LogFactory.getLog(EpbsThreadPools.class);
    private static final int MaxThread = Runtime.getRuntime().availableProcessors() / 2 + 1;
    public static final ThreadPool CommPools = ThreadPools.newFixedThreadPool((String)"epbs_common", (int)16, (String)"epbs");

    public static void commonExecute(Runnable runnable) {
        String traceId = RequestContext.get().getTraceId();
        CommPools.execute(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error(String.format("CommPools execute error:traceId=%s", traceId), (Throwable)e);
                throw e;
            }
        });
    }
}

