/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.epm.epbs.common.member.f7.F7TreeUtils;
import kd.epm.epbs.common.tree.TreeContext;
import kd.epm.epbs.common.util.TreeNodeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTreeBuilder<T extends TreeContext> {
    protected static final Log log = LogFactory.getLog(AbstractTreeBuilder.class);
    public static final String ROOT = "root";
    protected TreeNode root;
    protected boolean isOnlyLeafCheck;
    protected boolean isOnlyNoLeafCheck;
    protected T _cxt;
    private TreeView treeView;
    private Set<Long> showSelectedIds = null;

    public AbstractTreeBuilder<T> setContext(T context) {
        this._cxt = context;
        return this;
    }

    public void init() {
        if (this._cxt == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u521d\u59cb\u5316\u53ef\u7528\u53c2\u6570\u3002", (String)"AbstractTreeBuilder_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        this.isOnlyLeafCheck = ((TreeContext)this._cxt).isOnlyLeafCheckAble();
        this.isOnlyNoLeafCheck = ((TreeContext)this._cxt).isOnlyNoLeafCheckAble();
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    protected void recursionIsOpen(int level, TreeNode node) {
        node.setIsOpened(true);
        int level1 = --level;
        if (level1 == 0) {
            return;
        }
        node.getChildren().forEach(e -> this.recursionIsOpen(level1, (TreeNode)e));
    }

    public void setShowSelectedIds(Set<Long> showSelectedIds) {
        this.showSelectedIds = showSelectedIds;
    }

    public Set<Long> getShowSelectedIds() {
        return this.showSelectedIds;
    }

    public static void cacheNode(@NotNull TreeView treeView, TreeNode root) {
        F7TreeUtils.cacheTreeNodeData(treeView.getView().getPageCache(), AbstractTreeBuilder.treeNodeCacheKey(treeView), root);
    }

    public AbstractTreeBuilder<T> buildTree(@NotNull TreeView treeView) {
        return this.buildTree(treeView, null);
    }

    public static String treeNodeCacheKey(@NotNull TreeView treeView) {
        return treeView.getView().getPageId() + "&" + treeView.getKey();
    }

    protected void createTreeNodeAfter() {
        if (this.root == null) {
            this.root = new TreeNode("", ROOT, ROOT);
        }
        this.root.setDisabled(!((TreeContext)this._cxt).isCanSelectRoot());
        this.recursionIsOpen(((TreeContext)this._cxt).getOpenLevel(), this.root);
    }

    public final AbstractTreeBuilder<T> buildTree(@NotNull TreeView treeView, Set<Long> selectNodeIds) {
        log.info("begin-buildTree");
        this.init();
        if (selectNodeIds != null && !selectNodeIds.isEmpty()) {
            this.setShowSelectedIds(selectNodeIds);
        }
        this.treeView = treeView;
        try {
            this.root = this.createTreeNode();
            this.createTreeNodeAfter();
            AbstractTreeBuilder.cacheNode(treeView, this.root);
            treeView.deleteAllNodes();
            treeView.setRootVisible(((TreeContext)this._cxt).isShowRoot());
            treeView.setDragEnable(((TreeContext)this._cxt).isDragEnable());
            treeView.setMulti(((TreeContext)this._cxt).isMulti());
            if (((TreeContext)this._cxt).isMultiRoot() && (this.root.getId().equals(ROOT) || this.root.getId().equals("0"))) {
                treeView.setRootVisible(false);
            }
            treeView.addNode(this.root);
            TreeNode node = this.getFocusNode(this.root);
            if (node != null) {
                TreeNode fucusNode = TreeNodeUtils.getBaseClone(node);
                treeView.focusNode(fucusNode);
                this.afterBuildTree(fucusNode);
                treeView.expand(node.getId());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            log.info("end-buildTree");
        }
        return this;
    }

    protected void afterBuildTree(TreeNode focusNode) {
        if (((TreeContext)this._cxt).isMulti() && kd.bos.util.StringUtils.isNotEmpty((String)((TreeContext)this._cxt).getFocusTreeId())) {
            boolean ischeck;
            boolean bl = ischeck = StringUtils.equals((CharSequence)this.getRoot().getId(), (CharSequence)focusNode.getId()) && ((TreeContext)this._cxt).isCanSelectRoot() || !((TreeContext)this._cxt).isOnlyLeafCheckAble() && !((TreeContext)this._cxt).isOnlyNoLeafCheckAble() || CollectionUtils.isNotEmpty((Collection)focusNode.getChildren()) && ((TreeContext)this._cxt).isOnlyNoLeafCheckAble() || CollectionUtils.isEmpty((Collection)focusNode.getChildren()) && ((TreeContext)this._cxt).isOnlyLeafCheckAble();
            if (ischeck) {
                this.treeView.checkNode(focusNode);
                this.treeView.treeNodeCheck(focusNode.getParentid(), focusNode.getId(), Boolean.valueOf(true));
            }
        }
    }

    protected abstract TreeNode createTreeNode();

    public static TreeNode getRootWithCache(TreeView treeView) {
        return F7TreeUtils.getCacheTreeNodeData(treeView.getView().getPageCache(), AbstractTreeBuilder.treeNodeCacheKey(treeView));
    }

    public AbstractTreeBuilder<T> nodeClick() {
        List children;
        TreeNode node = null;
        if (StringUtils.isNotEmpty((CharSequence)((TreeContext)this._cxt).getFocusTreeId())) {
            node = this.root.getTreeNode(((TreeContext)this._cxt).getFocusTreeId());
        }
        if (node == null && ((TreeContext)this._cxt).isClickFirstChild() && !CollectionUtils.isEmpty((Collection)(children = this.root.getChildren()))) {
            node = (TreeNode)children.get(0);
        }
        node = node == null ? this.root : node;
        this.treeView.focusNode(node);
        this.treeView.expand(node.getId());
        this.treeView.treeNodeClick(node.getParentid(), node.getId());
        return this;
    }

    public AbstractTreeBuilder<?> clickFirstChildNode() {
        TreeNode node = null;
        if (StringUtils.isNotEmpty((CharSequence)((TreeContext)this._cxt).getFocusTreeId())) {
            node = this.root.getTreeNode(((TreeContext)this._cxt).getFocusTreeId());
        }
        if (node == null) {
            List children = this.root.getChildren();
            node = !CollectionUtils.isEmpty((Collection)children) ? (TreeNode)children.get(0) : this.root;
        }
        this.treeView.focusNode(node);
        this.treeView.expand(node.getId());
        this.treeView.treeNodeClick(node.getParentid(), node.getId());
        return this;
    }

    protected TreeNode getFocusNode(TreeNode root) {
        TreeNode treeNode = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)((TreeContext)this._cxt).getFocusTreeId())) {
            treeNode = root.getTreeNode(((TreeContext)this._cxt).getFocusTreeId());
        }
        if (treeNode == null && ((TreeContext)this._cxt).isDefaultSelectRoot()) {
            treeNode = root;
        }
        return treeNode;
    }

    public static Map<String, Object> getFocusNodeData(TreeView treeView) {
        String focusNodeId;
        TreeNode treeNode;
        TreeNode root = AbstractTreeBuilder.getRootWithCache(treeView);
        Map<String, Object> nodeData = new HashMap<String, Object>(16);
        if (root != null && (treeNode = root.getTreeNode(focusNodeId = treeView.getTreeState().getFocusNodeId())) != null) {
            nodeData = (Map)treeNode.getData();
        }
        return nodeData;
    }

    public static List<String> getAllChildNodeIds(TreeNode treeNode, boolean containSelf) {
        ArrayList nodeIds = Lists.newArrayList();
        if (null == treeNode) {
            return nodeIds;
        }
        if (containSelf) {
            nodeIds.add(treeNode.getId());
        }
        AbstractTreeBuilder.getAllChildNodeIds(treeNode.getChildren(), nodeIds);
        return nodeIds;
    }

    public static void getAllChildNodeIds(List<TreeNode> childNodes, List<String> nodeIds) {
        if (CollectionUtils.isEmpty(childNodes)) {
            return;
        }
        for (TreeNode node : childNodes) {
            nodeIds.add(node.getId());
            if (!CollectionUtils.isNotEmpty((Collection)node.getChildren())) continue;
            AbstractTreeBuilder.getAllChildNodeIds(node.getChildren(), nodeIds);
        }
    }
}

