/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import org.apache.commons.lang3.StringUtils;

public interface LeftTreeSearch {
    public static final String SEARCHBEFORE = "searchbefore";
    public static final String SEARCHNEXT = "searchnext";

    default public void leftSearch(TreeView treeView, String text) {
        if (StringUtils.isEmpty((CharSequence)(text = text.trim()))) {
            return;
        }
        TreeNode root = AbstractTreeBuilder.getRootWithCache(treeView);
        this.leftSearch(treeView, root, text);
    }

    default public void leftSearch(TreeView treeView, TreeNode root, String text) {
        if (StringUtils.isEmpty((CharSequence)(text = text.trim()))) {
            return;
        }
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (root != null) {
            ArrayList<String> matchs = new ArrayList<String>(10);
            this.match(text, root, matchs);
            if (!matchs.isEmpty()) {
                TreeNode treeNode;
                int index = matchs.indexOf(focusNodeId);
                if (++index == matchs.size()) {
                    index = 0;
                }
                if ((treeNode = root.getTreeNode((String)matchs.get(index))) != null) {
                    treeView.focusNode(treeNode);
                    treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                }
                treeView.getView().getPageCache().put(treeView.getKey() + "left_tree_search", SerializationUtils.serializeToBase64(matchs));
            } else {
                treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5339\u914d\u7684\u6570\u636e", (String)"LeftTreeSearch_1", (String)"epm-epbs-common", (Object[])new Object[0]));
            }
        }
    }

    default public void match(String text, TreeNode treeNode, List<String> matchs) {
        List children;
        if (treeNode.getText().contains(text) || treeNode.getLongText().contains(text)) {
            matchs.add(treeNode.getId());
        }
        if ((children = treeNode.getChildren()) != null) {
            for (TreeNode node : children) {
                this.match(text, node, matchs);
            }
        }
    }

    default public void leftSearchNext(TreeView treeView, boolean isNext) {
        TreeNode root = AbstractTreeBuilder.getRootWithCache(treeView);
        this.leftSearchNext(treeView, root, isNext);
    }

    default public void leftSearchNext(TreeView treeView, String key) {
        this.leftSearchNext(treeView, SEARCHNEXT.equals(key));
    }

    default public void leftSearchNext(TreeView treeView, TreeNode root, boolean isNext) {
        IFormView formView = treeView.getView();
        IPageCache pageCache = treeView.getView().getPageCache();
        if (pageCache.get(treeView.getKey() + "left_tree_search") != null) {
            List searchResult = (List)SerializationUtils.deSerializeFromBase64((String)pageCache.get(treeView.getKey() + "left_tree_search"));
            Map focusNode = treeView.getTreeState().getFocusNode();
            if (focusNode != null) {
                String focusId = (String)focusNode.get("id");
                int index = searchResult.indexOf(focusId);
                if (index == -1) {
                    return;
                }
                if (index == 0 && !isNext) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u3002", (String)"LeftTreeSearch_2", (String)"epm-epbs-common", (Object[])new Object[0]));
                    return;
                }
                if (index == searchResult.size() - 1 && isNext) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u3002", (String)"LeftTreeSearch_3", (String)"epm-epbs-common", (Object[])new Object[0]));
                    return;
                }
                String string = focusId = isNext ? (String)searchResult.get(index + 1) : (String)searchResult.get(index - 1);
                if (root != null) {
                    TreeNode newtFocusNode = root.getTreeNode(focusId);
                    treeView.focusNode(newtFocusNode);
                    treeView.treeNodeClick(newtFocusNode.getParentid(), focusId);
                }
            }
        }
    }
}

