/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.TreeBuilderUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SimpleDynamicTreeBuilder<T extends DynamicTreeContext>
extends AbstractTreeBuilder<DynamicTreeContext> {
    public SimpleDynamicTreeBuilder(T cxt) {
        this._cxt = cxt;
    }

    public SimpleDynamicTreeBuilder() {
    }

    @Override
    protected TreeNode createTreeNode() {
        Map<String, List<TreeNode>> map = this.queryTreeNode();
        TreeNode root = this.getRoot();
        if (map.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u5efa\u6811\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9", (String)"SimpleDynamicTreeBuilder_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
        if (root != null) {
            root.addChildren(map.get(root.getId()));
        } else if (map.size() == 1) {
            String parentId = map.keySet().iterator().next();
            List treeNodes = map.getOrDefault(parentId, Collections.emptyList());
            if (treeNodes.size() == 1) {
                root = (TreeNode)treeNodes.get(0);
                root.setParentid("");
            } else {
                root = new TreeNode("", parentId, ((DynamicTreeContext)this._cxt).getRootName());
                root.addChildren(treeNodes);
            }
        }
        return root;
    }

    protected Map<String, List<TreeNode>> queryTreeNode() {
        LinkedHashMap<String, List<TreeNode>> map = new LinkedHashMap<String, List<TreeNode>>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTreeData", (String)((DynamicTreeContext)this._cxt).getBaseEntityId(), (String)((DynamicTreeContext)this._cxt).getSelectFields(), (QFilter[])((DynamicTreeContext)this._cxt).getqFilters(), (String)((DynamicTreeContext)this._cxt).getOrderby());){
            ds.iterator().forEachRemaining(e -> {
                TreeNode treeNode = this.newTreeNode((Row)e);
                map.computeIfAbsent(treeNode.getParentid(), k -> new ArrayList()).add(treeNode);
            });
        }
        if (!map.isEmpty()) {
            new ArrayList(map.keySet()).forEach(parentId -> this.recursionTree((List)map.get(parentId), map));
        }
        return map;
    }

    protected TreeNode newTreeNode(Row row) {
        TreeNode treeNode = new TreeNode(row.getString("parent"), row.getString("id"), TreeBuilderUtils.getShowText(((DynamicTreeContext)this._cxt).getShowTypeEnum(), row));
        treeNode.setLongText(row.getString("number") + " " + row.getString("name"));
        treeNode.setData(this.formatTreeNodeDataFieldValue(row));
        return treeNode;
    }

    protected Object formatTreeNodeDataFieldValue(Row row) {
        if (!((DynamicTreeContext)this._cxt).getFillNodeFields().isEmpty()) {
            HashMap<String, Object> data = new HashMap<String, Object>(((DynamicTreeContext)this._cxt).getFillNodeFields().size());
            for (String field : ((DynamicTreeContext)this._cxt).getFillNodeFields()) {
                data.put(field, row.get(field));
            }
            return data;
        }
        return null;
    }

    protected void recursionTree(List<TreeNode> childs, Map<String, List<TreeNode>> map) {
        if (CollectionUtils.isNotEmpty(childs)) {
            childs.forEach(e -> {
                List remove = (List)map.remove(e.getId());
                if (remove != null) {
                    e.setCheckable(this.isOnlyNoLeafCheck);
                    e.addChildren(remove);
                    this.recursionTree(remove, map);
                } else {
                    e.setLeaf(true);
                    e.setCheckable(this.isOnlyLeafCheck);
                }
            });
        }
    }
}

