/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.TreeBuilderUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TreeChangneHelper {
    private TreeView treeView;
    private TreeNode root;
    private BiFunction<TreeNode, TreeNode, Boolean> beforeOp;
    private BiFunction<TreeNode, TreeNode, TreeNode> aftereOp;
    private Consumer<TreeNode> afterRefreshOp;
    protected TreeNode matchFirstInsertNode;

    public TreeChangneHelper addBeforeOp(BiFunction<TreeNode, TreeNode, Boolean> beforeOp) {
        this.beforeOp = beforeOp;
        return this;
    }

    public TreeChangneHelper addAftereOp(BiFunction<TreeNode, TreeNode, TreeNode> aftereOp) {
        this.aftereOp = aftereOp;
        return this;
    }

    public TreeChangneHelper addAfterRefreshOp(Consumer<TreeNode> afterRefreshOp) {
        this.afterRefreshOp = afterRefreshOp;
        return this;
    }

    public TreeChangneHelper(TreeView treeView) {
        this(treeView, AbstractTreeBuilder.getRootWithCache(treeView));
    }

    public TreeChangneHelper(TreeView treeView, TreeNode root) {
        this.treeView = treeView;
        this.root = root;
    }

    protected TreeNode getRoot() {
        if (this.root == null) {
            this.root = AbstractTreeBuilder.getRootWithCache(this.treeView);
        }
        return this.root;
    }

    public boolean delete() {
        String focusNodeId = this.treeView.getTreeState().getFocusNodeId();
        TreeNode root = this.getRoot();
        if (root.getId().equals(focusNodeId)) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"TreeChangneHelper_1", (String)"epm-epbs-common", (Object[])new Object[0]));
            return false;
        }
        TreeNode focusNode = this.getRoot().getTreeNode(focusNodeId);
        TreeNode parentNode = this.getRoot().getTreeNode(focusNode.getParentid());
        if (this.beforeOp == null || this.beforeOp.apply(focusNode, parentNode).booleanValue()) {
            parentNode.deleteChildNode(focusNodeId);
            focusNode = this.aftereOp != null ? this.aftereOp.apply(focusNode, parentNode) : parentNode;
            if (CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
                parentNode.setChildren(null);
            }
            this.refreshTree(focusNode);
            return true;
        }
        return false;
    }

    public boolean move(boolean isUp) {
        Map focusNode = this.treeView.getTreeState().getFocusNode();
        TreeNode rootNode = this.getRoot();
        TreeNode treeNode = rootNode.getTreeNode(String.valueOf(focusNode.get("id")));
        if (rootNode.getId().equals(treeNode.getId())) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"TreeChangneHelper_2", (String)"epm-epbs-common", (Object[])new Object[0]));
            return false;
        }
        TreeNode parentNode = rootNode.getTreeNode(String.valueOf(focusNode.get("parentid")));
        List children = parentNode.getChildren();
        int currentIndex = 0;
        for (int i = 0; i < children.size(); ++i) {
            if (!((TreeNode)children.get(i)).getId().equals(treeNode.getId())) continue;
            currentIndex = i;
            break;
        }
        if (isUp) {
            if (currentIndex == 0) {
                this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u4e2a\uff0c\u4e0d\u5141\u8bb8\u4e0a\u79fb\u3002", (String)"TreeChangneHelper_3", (String)"epm-epbs-common", (Object[])new Object[0]));
                return false;
            }
            TreeNode prevNode = (TreeNode)children.get(currentIndex - 1);
            if (this.beforeOp == null || this.beforeOp.apply(treeNode, prevNode).booleanValue()) {
                children.set(currentIndex, prevNode);
                children.set(currentIndex - 1, treeNode);
                if (this.aftereOp != null) {
                    treeNode = this.aftereOp.apply(treeNode, parentNode);
                }
            }
            this.refreshTree(treeNode);
        } else {
            if (currentIndex == children.size() - 1) {
                this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\uff0c\u4e0d\u5141\u8bb8\u4e0b\u79fb\u3002", (String)"TreeChangneHelper_4", (String)"epm-epbs-common", (Object[])new Object[0]));
                return false;
            }
            TreeNode nextNode = (TreeNode)children.get(currentIndex + 1);
            children.set(currentIndex, nextNode);
            children.set(currentIndex + 1, treeNode);
            this.refreshTree(treeNode);
        }
        return true;
    }

    public boolean insertNode(TreeNode insertNode) {
        TreeNode root = this.getRoot();
        TreeNode parent = root.getTreeNode(insertNode.getParentid());
        if (parent == null) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"TreeChangneHelper_5", (String)"epm-epbs-common", (Object[])new Object[0]));
        } else if (CollectionUtils.isNotEmpty((Collection)parent.getChildren()) && parent.getTreeNode(insertNode.getId()) != null) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u3002", (String)"TreeChangneHelper_6", (String)"epm-epbs-common", (Object[])new Object[0]));
        } else if (this.beforeOp == null || this.beforeOp.apply(insertNode, parent).booleanValue()) {
            parent.addChild(insertNode);
            if (this.aftereOp != null) {
                insertNode = this.aftereOp.apply(insertNode, parent);
            }
            this.refreshTree(insertNode);
            return true;
        }
        return false;
    }

    public boolean mergeNode(TreeNode mergeNode, BiConsumer<TreeNode, TreeNode> matchSameNodeOp, BiConsumer<TreeNode, TreeNode> insert2Parent) {
        TreeNode root = this.getRoot();
        TreeNode parent = root.getTreeNode(mergeNode.getParentid());
        if (parent != null) {
            this.matchAndInsertTreeNode(mergeNode, parent, matchSameNodeOp, insert2Parent);
            if (this.matchFirstInsertNode == null) {
                String focusNodeId = this.treeView.getTreeState().getFocusNodeId();
                this.matchFirstInsertNode = mergeNode.getTreeNode(focusNodeId);
            }
            if (this.matchFirstInsertNode == null) {
                mergeNode.iterate(100, e -> {
                    if (CollectionUtils.isEmpty((Collection)e.getChildren())) {
                        this.matchFirstInsertNode = e;
                    }
                });
            }
            this.refreshTree(this.matchFirstInsertNode);
            this.matchFirstInsertNode = null;
            return true;
        }
        this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"TreeChangneHelper_5", (String)"epm-epbs-common", (Object[])new Object[0]));
        return false;
    }

    protected void matchAndInsertTreeNode(TreeNode insertNode, TreeNode parent, BiConsumer<TreeNode, TreeNode> matchSameNodeOp, BiConsumer<TreeNode, TreeNode> insert2ParentOp) {
        TreeNode treeNode = parent.getTreeNode(insertNode.getId());
        if (treeNode == null) {
            if (insertNode.getParentid().equals(parent.getId())) {
                if (insert2ParentOp != null) {
                    insert2ParentOp.accept(insertNode, parent);
                }
                if (this.matchFirstInsertNode == null) {
                    this.matchFirstInsertNode = insertNode;
                }
                parent.addChild(insertNode);
                ArrayList list = new ArrayList(1);
                insertNode.iterate(100, e -> {
                    if (CollectionUtils.isEmpty((Collection)e.getChildren())) {
                        list.add(e);
                    }
                });
            }
        } else {
            if (matchSameNodeOp != null) {
                matchSameNodeOp.accept(insertNode, treeNode);
            }
            if (CollectionUtils.isNotEmpty((Collection)insertNode.getChildren())) {
                for (TreeNode child : insertNode.getChildren()) {
                    this.matchAndInsertTreeNode(child, treeNode, matchSameNodeOp, insert2ParentOp);
                }
            }
        }
    }

    protected void refreshTree(TreeNode selectNode) {
        TreeBuilderUtils.refreshTree(this.treeView, this.getRoot(), selectNode);
        if (this.afterRefreshOp != null) {
            this.afterRefreshOp.accept(selectNode);
        }
    }
}

