/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.tree.TreeBuilderUtils;
import kd.epm.epbs.common.tree.TreePropEnum;

public class TreeContext
implements Serializable {
    private static final long serialVersionUID = 7619802398302553027L;
    private ShowTypeEnum showTypeEnum = ShowTypeEnum.NAME;
    private String focusTreeId;
    private int openLevel = 1;
    private int treePropBit = TreeBuilderUtils.DEFAULT_TREE_PROP_VALUE;
    private String rootName;
    private boolean multiRoot = false;
    private boolean clickFirstChild = false;

    public TreeContext() {
    }

    public TreeContext(String focusTreeId) {
        this.focusTreeId = focusTreeId;
    }

    protected boolean isShowRoot() {
        return TreePropEnum.TREEVIEW_RootVisible.computeBoolean(this.treePropBit);
    }

    public boolean isDragEnable() {
        return TreePropEnum.TREEVIEW_DragEnable.computeBoolean(this.treePropBit);
    }

    public boolean isMulti() {
        return TreePropEnum.TREEVIEW_Multi.computeBoolean(this.treePropBit);
    }

    public void addTreeBooleanProp(boolean flag, TreePropEnum ... props) {
        this.treePropBit = TreePropEnum.computeValue(this.treePropBit, flag, props);
    }

    public boolean isOnlyLeafCheckAble() {
        return TreePropEnum.TREENODE_ONLY_LEAF_Checkable.computeBoolean(this.treePropBit);
    }

    public boolean isDefaultSelectRoot() {
        return TreePropEnum.DEFAULT_SELECT_ROOT.computeBoolean(this.treePropBit);
    }

    public boolean isOnlyNoLeafCheckAble() {
        return TreePropEnum.TREENODE_ONLY_NOLEAF_Checkable.computeBoolean(this.treePropBit);
    }

    public boolean isCanSelectRoot() {
        return TreePropEnum.TREENODE_CanSelectRoot.computeBoolean(this.treePropBit);
    }

    public ShowTypeEnum getShowTypeEnum() {
        return this.showTypeEnum;
    }

    public void setShowTypeEnum(ShowTypeEnum showTypeEnum) {
        this.showTypeEnum = showTypeEnum;
    }

    public String getFocusTreeId() {
        return this.focusTreeId;
    }

    public void setFocusTreeId(String focusTreeId) {
        this.focusTreeId = focusTreeId;
    }

    public int getOpenLevel() {
        return this.openLevel;
    }

    public void setOpenLevel(int openLevel) {
        this.openLevel = openLevel;
    }

    public String getRootName() {
        if (this.rootName == null) {
            return ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeContext_1", (String)"epm-epbs-common", (Object[])new Object[0]);
        }
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public boolean isMultiRoot() {
        return this.multiRoot;
    }

    public void setMultiRoot(boolean multiRoot) {
        this.multiRoot = multiRoot;
    }

    public boolean isClickFirstChild() {
        return this.clickFirstChild;
    }

    public void setClickFirstChild(boolean clickFirstChild) {
        this.clickFirstChild = clickFirstChild;
    }
}

