/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

public enum TreePropEnum {
    TREEVIEW_RootVisible(1, true),
    TREEVIEW_Multi(2, false),
    TREEVIEW_DragEnable(4, false),
    TREENODE_CanSelectRoot(8, true),
    TREENODE_ONLY_LEAF_Checkable(16, false),
    TREENODE_ONLY_NOLEAF_Checkable(64, false),
    DEFAULT_SELECT_ROOT(128, true);

    private int val;
    private boolean defaultVal;

    private TreePropEnum(int val, boolean defaultVal) {
        this.val = val;
        this.defaultVal = defaultVal;
    }

    public int getVal() {
        return this.val;
    }

    public static int getComputeDefault() {
        int i = 0;
        for (TreePropEnum value : TreePropEnum.values()) {
            if (!value.defaultVal) continue;
            i += value.val;
        }
        return i;
    }

    public static int computeValue(int value, boolean flag, TreePropEnum ... propEnums) {
        for (TreePropEnum propEnum : propEnums) {
            int temp = value & propEnum.val;
            if (temp == 0 && flag) {
                value += propEnum.val;
                continue;
            }
            if (temp == 0 || flag) continue;
            value -= propEnum.val;
        }
        return value;
    }

    public boolean computeBoolean(int value) {
        if (value < 0) {
            return this.defaultVal;
        }
        return (value & this.val) == this.val;
    }
}

