/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.tree;

import java.util.ArrayList;
import java.util.Locale;
import java.util.function.BiFunction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeSearchHelper {
    protected String searchText;
    protected byte modeType = 1;
    protected boolean isCircle;
    protected TreeNode searchNode;
    protected TreeView treeView;
    protected TreeNode root;
    protected BiFunction<TreeNode, String, Boolean> matchFunction = (node, k) -> node.getText().toLowerCase(Locale.ENGLISH).contains((CharSequence)k);

    public TreeSearchHelper(String searchText) {
        this.searchText = searchText;
    }

    public TreeSearchHelper(TreeView treeView, String searchText) {
        this.treeView = treeView;
        this.searchText = searchText;
    }

    public TreeSearchHelper setMoveUp() {
        this.modeType = (byte)-1;
        return this;
    }

    public TreeSearchHelper setRoot(TreeNode root) {
        this.root = root;
        return this;
    }

    protected TreeNode getRoot() {
        if (this.root == null) {
            this.root = AbstractTreeBuilder.getRootWithCache(this.treeView);
        }
        return this.root;
    }

    public TreeSearchHelper setCircle(boolean circle) {
        this.isCircle = circle;
        return this;
    }

    public TreeSearchHelper setMatchFunction(BiFunction<TreeNode, String, Boolean> matchFunction) {
        this.matchFunction = matchFunction;
        return this;
    }

    protected boolean isMatcher(TreeNode node) {
        return this.matchFunction.apply(node, this.searchText);
    }

    public void search() {
        TreeNode lastNode;
        String focusNodeId;
        if (StringUtils.isEmpty((CharSequence)this.searchText)) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TreeSearchHelper_1", (String)"epm-epbs-common", (Object[])new Object[0]));
            return;
        }
        ArrayList list = new ArrayList(16);
        this.getRoot().iterate(100, node -> {
            if (this.isMatcher((TreeNode)node)) {
                list.add(node);
            }
        });
        if (CollectionUtils.isEmpty(list)) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchHelper_2", (String)"epm-epbs-common", (Object[])new Object[0]));
            return;
        }
        int i = 0;
        if ((this.modeType == -1 || this.modeType == 1) && StringUtils.isNotEmpty((CharSequence)(focusNodeId = this.treeView.getTreeState().getFocusNodeId())) && (lastNode = this.getRoot().getTreeNode(focusNodeId)) != null && this.isMatcher(lastNode)) {
            i = list.indexOf(lastNode) + this.modeType;
            if (i < 0) {
                if (!this.isCircle) {
                    this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeSearchHelper_3", (String)"epm-epbs-common", (Object[])new Object[0]));
                    return;
                }
                i = list.size() - 1;
            } else if (i >= list.size()) {
                if (!this.isCircle) {
                    this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeSearchHelper_4", (String)"epm-epbs-common", (Object[])new Object[0]));
                    return;
                }
                i = 0;
            }
        }
        this.searchNode = (TreeNode)list.get(i);
        if (this.searchNode != null) {
            TreeNode treeNode = this.searchNode;
            this.treeView.focusNode(treeNode);
            this.treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            while (treeNode != null && StringUtils.isNotEmpty((CharSequence)treeNode.getParentid())) {
                this.treeView.expand(treeNode.getParentid());
                treeNode = this.root.getTreeNode(treeNode.getParentid());
            }
        } else {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeSearchHelper_2", (String)"epm-epbs-common", (Object[])new Object[0]));
        }
    }
}

