/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.enums.AppModelEnum;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.ModelUtil;

public class AppUtils {
    private static final Log LOG = LogFactory.getLog(ModelUtil.class);
    private static final String FLAG_CACHE = "epbs_apptype_cache";

    public static Collection<String> getAppNumsCache() {
        return GlobalCacheServiceHelper.getCommonCache().getOrLoad(FLAG_CACHE, () -> QueryServiceHelper.query((String)"epbs_apptype", (String)"number", null).stream().map(e -> e.getString("number")).collect(Collectors.toList()));
    }

    public static void removeCache() {
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey(FLAG_CACHE);
    }

    public static Collection<AppTypeEnum> getAppTypesCache() {
        return AppUtils.getAppNumsCache().stream().map(e -> AppTypeEnum.getEnumByAppnum(e.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    public static Collection<String> getAppNumsByMetadataCache() {
        Collection<String> list = AppUtils.getAppNumsCache();
        ArrayList appInfos = Lists.newArrayListWithCapacity((int)list.size());
        for (String appnum : list) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appnum);
                try {
                    Method isVisible = appInfo.getClass().getMethod("isVisible", new Class[0]);
                    if (!((Boolean)isVisible.invoke((Object)appInfo, new Object[0])).booleanValue()) continue;
                    appInfos.add(appInfo);
                }
                catch (Exception e) {
                    appInfos.add(appInfo);
                }
            }
            catch (Exception exception) {}
        }
        return appInfos.stream().map(AppInfo::getAppId).collect(Collectors.toList());
    }

    public static String getAppPkId(IFormView formView) {
        return AppMetadataCache.getAppInfo((String)formView.getFormShowParameter().getAppId()).getId();
    }

    public static void buildValueMapItems(ListField listField, Collection<AppTypeEnum> appTypes) {
        try {
            if (listField != null) {
                List<AppModelEnum> appModelByEnum = ModelUtil.getAppModelByEnum(appTypes);
                appModelByEnum = appTypes != null ? appModelByEnum.stream().filter(e -> appTypes.contains(e.getAppType())).collect(Collectors.toList()) : appModelByEnum.stream().filter(e -> e.getAppType() != AppTypeEnum.FAR).collect(Collectors.toList());
                ComboProp comboProp = (ComboProp)listField.getSrcFieldProp().clone();
                comboProp.getComboItems().clear();
                listField.setSrcFieldProp((IDataEntityProperty)comboProp);
                appModelByEnum.stream().forEach(appModel -> comboProp.getComboItems().add(new ValueMapItem(null, appModel.getAppType().getAppNum(), appModel.getAppType().getDescWithLocale())));
            }
        }
        catch (Exception e2) {
            LOG.error("model not found:" + e2.getMessage());
        }
    }

    public static void buildComboItems(ComboEdit comboEdit, Collection<AppTypeEnum> appTypes) {
        List<AppModelEnum> appModelByEnum = ModelUtil.getAppModelByEnum(appTypes);
        appModelByEnum = appTypes != null ? appModelByEnum.stream().filter(e -> appTypes.contains(e.getAppType())).collect(Collectors.toList()) : appModelByEnum.stream().filter(e -> e.getAppType() != AppTypeEnum.FAR).collect(Collectors.toList());
        List list = appModelByEnum.stream().map(appModel -> new ComboItem(appModel.getAppType().getDescWithLocale(), appModel.getAppType().getAppNum())).collect(Collectors.toList());
        comboEdit.setComboItems(list);
    }
}

